<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class UsAppToPersonUsecaseList extends ListResource {
    /**
     * Construct the UsAppToPersonUsecaseList
     *
     * @param Version $version Version that contains the resource
     * @param string $messagingServiceSid The unique string that identifies the
     *                                    resource
     */
    public function __construct(Version $version, string $messagingServiceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['messagingServiceSid' => $messagingServiceSid, ];

        $this->uri = '/Services/' . \rawurlencode($messagingServiceSid) . '/Compliance/Usa2p/Usecases';
    }

    /**
     * Fetch the UsAppToPersonUsecaseInstance
     *
     * @param array|Options $options Optional Arguments
     * @return UsAppToPersonUsecaseInstance Fetched UsAppToPersonUsecaseInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): UsAppToPersonUsecaseInstance {
        $options = new Values($options);

        $params = Values::of(['BrandRegistrationSid' => $options['brandRegistrationSid'], ]);

        $payload = $this->version->fetch('GET', $this->uri, $params);

        return new UsAppToPersonUsecaseInstance(
            $this->version,
            $payload,
            $this->solution['messagingServiceSid']
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Messaging.V1.UsAppToPersonUsecaseList]';
    }
}