<?php

call_user_func(function() {

    $pluginEntryFile = wp_normalize_path(__DIR__.'/plugin.php');

    register_activation_hook($pluginEntryFile, function() {

        $otherPluginVersions = array();
        foreach (get_option('active_plugins') as $pluginFile) {
            $data = get_file_data(WP_PLUGIN_DIR.'/'.$pluginFile, array('PluginFamilyId' => 'Plugin Family Id'));
            $id = @$data['PluginFamilyId'];
            if ($id === 'dangoodman/wc-weight-based-shipping') {
                $otherPluginVersions[] = $pluginFile;
            }
        }

        if ($otherPluginVersions) {
            deactivate_plugins($otherPluginVersions);
        }
    });

    // This fixes the following issue:
    // 1. Activate the 'Real Cookie Banner (Free)' plugin (probably any plugin with plugin-update-checker "scoped" with php-scoper).
    // 2. Activate this plugin.
    // 3. Notice the fatal error saying Puc_v4_Factory class not found in the UpdateService.
    //
    // The issue happens because composers' "files" autoload type includes an only autoload file out of all
    // available having the same hash. The hash is based on package name and file path.
    //
    // "Scoping" plugin-update-checker with composer-capsule breaks it since PUC depends on the class name structure
    // which is changed due to the way CC handles classes in the root namespace.
    if (!class_exists('Puc_v4_Factory')) {
        require_once(__DIR__ . '/server/vendor/yahnis-elsts/plugin-update-checker/load-v4p11.php');
    }

    if (!class_exists('Wbs\Plugin', false)) {
        require_once(__DIR__ . "/server/vendor/autoload.php");
        \Wbs\Plugin::setupOnce($pluginEntryFile);
    }
});