<div class="jet-abaf-bookings-add-new">
	<cx-vui-button
		button-style="accent"
		size="mini"
		@click="showAddDialog()"
	>
		<template slot="label"><?php esc_html_e( 'Add New', 'jet-booking' ); ?></template>
	</cx-vui-button>

	<cx-vui-popup
		v-model="addDialog"
		body-width="400px"
		ok-label="<?php esc_html_e( 'Add New', 'jet-booking' ) ?>"
		@on-cancel="addDialog = false"
		@on-ok="handleAdd"
	>
		<div class="cx-vui-subtitle" slot="title">
			<?php esc_html_e( 'Add New Booking:', 'jet-booking' ); ?>
		</div>

		<div
			class="jet-abaf-bookings-error"
			slot="content"
			v-if="overlappingBookings"
			v-html="overlappingBookings"
		></div>

		<div class="jet-abaf-details" slot="content">
			<br>
			<div class="jet-abaf-details__fields">
				<template v-for="field in fields">
					<div
						v-if="beVisible( field )"
						:key="field"
						:class="[ 'jet-abaf-details__field', 'jet-abaf-details__field-' + field ]"
					>
						<div class="jet-abaf-details__label">{{ field }}:</div>

						<div class="jet-abaf-details__content">
							<select v-if="'status' === field" v-model="newItem.status">
								<option v-for="( label, value ) in statuses" :value="value" :key="value">
									{{ label }}
								</option>
							</select>

							<select v-else-if="'apartment_id' === field" v-model="newItem.apartment_id">
								<option v-for="( label, value ) in bookingInstances" :value="value" :key="value">
									{{ label }}
								</option>
							</select>

							<vuejs-datepicker
								v-else-if="'check_in_date' === field || 'check_out_date' === field"
								input-class="cx-vui-input size-fullwidth"
								placeholder="<?php esc_html_e( 'dd/mm/yyyy', 'jet-booking' ); ?>"
								:format="datePickerFormat"
								:v-model="newItem[ field ]"
								:monday-first="true"
								@selected="selectedDate( $event, field )"
							></vuejs-datepicker>

							<input type="text" v-model="newItem[ field ]" v-else />
						</div>
					</div>
				</template>
			</div>
		</div>
	</cx-vui-popup>
</div>