( function () {

	'use strict';

	window.scheduleManager = {
		data: function () {
			return {
				editDay: false,
				date: {
					start: null,
					startTimeStamp: null,
					end: null,
					endTimeStamp: null,
					name: null,
					type: null,
					editIndex: null,
				},
				deleteDayTrigger: null,
				datePickerFormat: 'dd-MM-yyyy',
				dateMomentFormat: 'DD-MM-YYYY',
				disabledDate: {},
			};
		},
		components: {
			vuejsDatepicker: window.vuejsDatepicker
		},
		methods: {
			showEditDay: function( daysType = false , date = false ) {

				if ( date && daysType ) {
					let index = this.settings[ daysType ].indexOf( date );

					this.date = Object.assign( {}, date );
					this.date.editIndex = index;
				}

				this.updateDisabledDates( daysType, date );

				this.date.type = daysType;
				this.editDay = true;

			},

			updateDisabledDates: function( daysType = false, excludedDate = false ) {

				let newDisabledDates = [],
					_excludedDate = JSON.stringify( excludedDate );

				for ( let date in this.settings[ daysType ] ) {
					if ( this.settings[ daysType ].hasOwnProperty( date ) ) {
						if ( JSON.stringify( this.settings[ daysType ][ date ] )  === _excludedDate ) {
							continue;
						}

						let daysFrom = moment.unix( this.settings[ daysType ][ date ].startTimeStamp ).utc(),
							toFrom = moment.unix( this.settings[ daysType ][ date ].endTimeStamp ).utc().add( 1, 'days' );

						if ( excludedDate ) {
							daysFrom.add( -1, 'days' )
						}

						newDisabledDates.push( {
							from: daysFrom.toDate(),
							to: toFrom.toDate(),
						} );
					}
				}

				this.$set( this.disabledDate, 'ranges', newDisabledDates );

			},

			handleDayCancel: function() {

				for ( let key in this.date ) {
					if ( this.date.hasOwnProperty( key ) ) {
						this.$set( this.date, key, null );
					}
				}

				this.editDay = false;

			},

			handleDayOk: function() {

				if ( ! this.date.endTimeStamp ) {
					this.date.endTimeStamp = this.date.startTimeStamp;
				}

				if ( ! this.date.start || this.date.startTimeStamp > this.date.endTimeStamp ) {
					this.$CXNotice.add( {
						message: wp.i18n.__( 'Date is not correct', 'jet-booking' ),
						type: 'error',
						duration: 7000,
					} );

					return;
				}

				let date = Object.assign( {}, this.date ),
					dates = this.settings[ date.type ],
					index = null !== date.editIndex ? date.editIndex : dates.length;

				this.$set( dates, index, date );

				this.updateSetting( dates, date.type );
				this.handleDayCancel();

			},

			selectedDate: function( date, daysType ) {

				let dateTimestamp = this.objectDateToTimestamp( date ),
					formattedDate = this.parseDate( date, this.dateMomentFormat );

				this.$set( this.date, daysType, formattedDate );
				this.$set( this.date, `${ daysType }TimeStamp`, dateTimestamp );

			},

			confirmDeleteDay: function( dateObject ) {
				this.deleteDayTrigger = dateObject;
			},

			deleteDay: function( daysType = false , date = false  ) {

				let index = this.settings[ daysType ].indexOf( date );

				this.$delete( this.settings[ daysType ], index );

				this.$nextTick( function() {
					this.saveSettings();
				} );

			},
		}
	};

} )();