/*!
 * Transition Name: Grid Flip
 */
!function(e){(function(e){"use strict";var t={name:"GridFlip",effect:function(e,t){this.viewer=t;this.shader={uniforms:{texture1:{value:null},texture2:{value:null},progress:{value:0},time:{value:0},timeDelta:{value:0},resolution:{value:new THREE.Vector2},pause:{value:.1},dividerWidth:{value:.05},bgcolor:{value:new THREE.Vector4(0,0,0,1)},randomness:{value:.1}},vertexShader:["varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);","}"].join("\n"),fragmentShader:["varying vec2 vUv;","uniform sampler2D texture1;","uniform sampler2D texture2;","uniform float progress;","uniform float time;","uniform float timeDelta;","uniform vec2 resolution;","const float PI = 3.141592653589793;","vec4 getFromColor(vec2 uv) {","return texture2D(texture1, uv);","}","vec4 getToColor(vec2 uv) {","return texture2D(texture2, uv);","}","uniform float pause;","uniform float dividerWidth;","uniform vec4 bgcolor;","uniform float randomness;","const ivec2 size = ivec2(4);","float rand (vec2 co) {","return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);","}","float getDelta(vec2 p) {","vec2 rectanglePos = floor(vec2(size) * p);","vec2 rectangleSize = vec2(1.0 / vec2(size).x, 1.0 / vec2(size).y);","float top = rectangleSize.y * (rectanglePos.y + 1.0);","float bottom = rectangleSize.y * rectanglePos.y;","float left = rectangleSize.x * rectanglePos.x;","float right = rectangleSize.x * (rectanglePos.x + 1.0);","float minX = min(abs(p.x - left), abs(p.x - right));","float minY = min(abs(p.y - top), abs(p.y - bottom));","return min(minX, minY);","}","float getDividerSize() {","vec2 rectangleSize = vec2(1.0 / vec2(size).x, 1.0 / vec2(size).y);","return min(rectangleSize.x, rectangleSize.y) * dividerWidth;","}","void main() {","vec2 uv = vUv;","vec2 p = vUv;","if(progress < pause) {","float currentProg = progress / pause;","float a = 1.0;","if(getDelta(p) < getDividerSize()) {","a = 1.0 - currentProg;","}","gl_FragColor = mix(bgcolor, getFromColor(p), a);","} else if(progress < 1.0 - pause) {","if(getDelta(p) < getDividerSize()) {","gl_FragColor = bgcolor;","} else {","float currentProg = (progress - pause) / (1.0 - pause * 2.0);","vec2 q = p;","vec2 rectanglePos = floor(vec2(size) * q);","float r = rand(rectanglePos) - randomness;","float cp = smoothstep(0.0, 1.0 - r, currentProg);","float rectangleSize = 1.0 / vec2(size).x;","float delta = rectanglePos.x * rectangleSize;","float offset = rectangleSize / 2.0 + delta;","p.x = (p.x - offset)/abs(cp - 0.5)*0.5 + offset;","vec4 a = getFromColor(p);","vec4 b = getToColor(p);","float s = step(abs(vec2(size).x * (q.x - delta) - 0.5), abs(cp - 0.5));","gl_FragColor = mix(bgcolor, mix(b, a, step(cp, 0.5)), s);","}","} else {","float currentProg = (progress - 1.0 + pause) / pause;","float a = 1.0;","if(getDelta(p) < getDividerSize()) {","a = currentProg;","}","gl_FragColor = mix(bgcolor, getToColor(p), a);","}","}"].join("\n"),side:THREE.DoubleSide};this.material=new THREE.ShaderMaterial(this.shader);this.init(e)}};t.effect.prototype={init:function(e){},getMaterial:function(){return this.material},destroy:function(){this.material.dispose()},onStart:function(e,t,o){},onUpdate:function(e,t,o){},onComplete:function(e,t){}},e.SceneTransitionEffect=e.SceneTransitionEffect||{},e.SceneTransitionEffect.GridFlip=t})((e=e||self).IPANORAMA=e.IPANORAMA||{})}(this);