<?php

if (!defined('ABSPATH')) exit;

if (!class_exists('InstalinkWidget')) {
	/**
	 * Adds InstalinkWidget widget.
	 */
	class InstalinkWidget extends WP_Widget {

		/**
		 * Register widget with WordPress.
		 */
		function __construct() {
			parent::__construct(
				'InstalinkWidget',
				__('InstaLink Widget', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				array('description' => __('InstaLink - WordPress Instagram Widget', ELFSIGHT_INSTALINK_TEXTDOMAIN))
			);
		}

		/**
		 * Front-end display of widget.
		 *
		 * @see WP_Widget::widget()
		 *
		 * @param array $args     Widget arguments.
		 * @param array $instance Saved values from database.
		 */
		public function widget($args, $instance) {
			extract($instance, EXTR_SKIP);

			if (!empty($instance['id'])) {
				echo do_shortcode('[instalink id="' . $instance['id'] . '"]');
			}
		}

		/**
		 * Back-end widget form.
		 *
		 * @see WP_Widget::form()
		 *
		 * @param array $instance Previously saved values from database.
		 */
		public function form($instance) {
			global $wpdb;

			$widgets_table_name = elfsight_instalink_widgets_get_table_name();
			$select_sql = '
				SELECT id, name FROM `' . esc_sql($widgets_table_name) . '`
				WHERE `active` = "1" ORDER BY `id` DESC
			';

			$widgets = $wpdb->get_results($select_sql, ARRAY_A);?>

			<?php if(!empty($widgets)) {?>
				<p>
					<label for="<?php echo $this->get_field_id('id'); ?>"><?php _e('Select Widget:', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></label>
					<select class='widefat' id="<?php echo $this->get_field_id('id'); ?>" name="<?php echo $this->get_field_name('id'); ?>">
						<option value="0">— Select —</option>
						<?php foreach ($widgets as $widget) { ?>
							<option value="<?php echo $widget['id'] ?>"<?php echo (!empty($instance['id']) && $instance['id'] == $widget['id']) ? ' selected' : ''; ?>><?php echo $widget['name']; ?></option>
						<?php } ?>
					</select>
				</p>
			<?php } else { ?>
				<p>
					<?php _e('No InstaLink widgets yet.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                	<a href="<?php echo esc_url(admin_url('admin.php?page=elfsight-instalink')); ?>#/add-widget/" data-il-admin-page="add-widget"><?php _e('Create the first one.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></a>
				</p>
			<?php }
		}

		/**
		 * Sanitize widget form values as they are saved.
		 *
		 * @see WP_Widget::update()
		 *
		 * @param array $new_instance Values just sent to be saved.
		 * @param array $old_instance Previously saved values from database.
		 *
		 * @return array Updated safe values to be saved.
		 */
		public function update($new_instance, $old_instance) {
			$instance = $old_instance;
		    $instance['id'] = !empty($new_instance['id']) ? $new_instance['id'] : '';

		    return $instance;
		}
	}

	if(!function_exists('elfsight_instalink_register_widget')) {
		function elfsight_instalink_register_widget() {
		    register_widget('InstalinkWidget');
		}
		add_action('widgets_init', 'elfsight_instalink_register_widget');	
	}
}

?>