<?php

if (!defined('ABSPATH')) exit;

function elfsight_instalink_shortcode_get_optons($id) {
	global $wpdb;

	$id = intval($id);
	$widgets_table_name = elfsight_instalink_widgets_get_table_name();
	$select_sql = '
		SELECT options FROM `' . esc_sql($widgets_table_name) . '`
		WHERE `id` = "' . esc_sql($id) . '" and `active` = "1"
	';

	$item = $wpdb->get_row($select_sql, ARRAY_A);
	$options = !empty($item['options']) ? json_decode($item['options'], true) : array();

	return $options;
}

// shortcode [instalink]
function elfsight_instalink_shortcode($atts) {
	global $elfsight_instalink_defaults, $elfsight_instalink_add_scripts;

	$elfsight_instalink_add_scripts = true;
	$api_url = get_option('elfsight_instalink_custom_api_url', ELFSIGHT_INSTALINK_API_URL);

	if (!empty($atts['id'])) {
		$stored_options = elfsight_instalink_shortcode_get_optons($atts['id']);
		$stored_options_prepared = array();
		if (is_array($stored_options)) {
			foreach($stored_options as $name => $value) {
				$stored_options_prepared[ltrim(strtolower(preg_replace('/[A-Z]/', '_$0', $name)), '_')] = is_array($value) ? implode(', ', $value) : $value;
			}
		}

		$atts = array_combine(
			array_merge(array_keys($stored_options_prepared), array_keys($atts)),
			array_merge(array_values($stored_options_prepared), array_values($atts))
		);

		unset($atts['id']);
	}

	if (!empty($_GET['vc_editable'])) {
		$atts['debug'] = 'true';

		if (empty($atts['username']) && empty($atts['hashtag'])) {
			$atts['username'] = 'instagram';
		}
	}

	foreach ($elfsight_instalink_defaults as $name => $value) {
		if (isset($atts[$name]) && is_bool($value)) {
			$atts[$name] = !empty($atts[$name]) && $atts[$name] !== 'false';
		}
	}

	$options = shortcode_atts($defaults = $elfsight_instalink_defaults, $atts, 'instalink');

	$result = '<div data-il';
	$result .= ' data-il-api="' . $api_url . '"';

	foreach ($options as $name => $value) {
		if ($value !== $elfsight_instalink_defaults[$name]) {

			// boolean
			if (is_bool($value)) {
				$value = $value ? 'true' : 'false';
			}

			$result .= sprintf(' data-il-%s="%s"', str_replace('_', '-', $name), esc_attr($value));
		}
	}
	$result .= '></div>';

	return $result;
}
add_shortcode('instalink', 'elfsight_instalink_shortcode');

?>
