<?php

if (!defined('ABSPATH')) exit;


// register styles and scripts
function elfsight_instalink_lib() {
	global $elfsight_instalink_add_scripts;

	$force_script_add = get_option('elfsight_instalink_force_script_add');

	$uploads_dir_params = wp_upload_dir();
	$uploads_dir = $uploads_dir_params['basedir'] . '/' . ELFSIGHT_INSTALINK_SLUG;
	$uploads_url = $uploads_dir_params['baseurl'] . '/' . ELFSIGHT_INSTALINK_SLUG;

	wp_register_script('instalink', plugins_url('assets/instalink/instalink-2.1.4.min.js', ELFSIGHT_INSTALINK_FILE), array(), ELFSIGHT_INSTALINK_VERSION);
	wp_register_script('instalink-custom', $uploads_url . '/instalink-custom.js', array(), ELFSIGHT_INSTALINK_VERSION);
	
	wp_register_style('instalink', plugins_url('assets/instalink/instalink-2.1.4.min.css', ELFSIGHT_INSTALINK_FILE), array(), ELFSIGHT_INSTALINK_VERSION);
	wp_register_style('instalink-custom', $uploads_url . '/instalink-custom.css', array(), ELFSIGHT_INSTALINK_VERSION);

	if ($elfsight_instalink_add_scripts || $force_script_add === 'on') {
		$custom_css_path = $uploads_dir . '/instalink-custom.css';
		$custom_js_path = $uploads_dir . '/instalink-custom.js';

		wp_print_scripts('instalink');
		wp_print_styles('instalink');

		if (is_readable($custom_js_path) && filesize($custom_js_path) > 0) {
			wp_print_scripts('instalink-custom');
		}

		if (is_readable($custom_css_path) && filesize($custom_css_path) > 0) {
			wp_print_styles('instalink-custom');
		}
	}
}
add_action('wp_footer', 'elfsight_instalink_lib');

?>
