<?php

if (!defined('ABSPATH')) exit;


function elfsight_instalink_vc() {
	global $elfsight_instalink_defaults, $elfsight_instalink_add_scripts;
	extract($elfsight_instalink_defaults, EXTR_SKIP);

	if (!empty($_GET['vc_editable'])) {
		$elfsight_instalink_add_scripts = true;
	}

	if (empty($username) && empty($hashtag)) {
	 	$username = 'instagram';
	}

	vc_map(array(
		'name' => __('InstaLink', ELFSIGHT_INSTALINK_TEXTDOMAIN),
		'description' => __('Instagram Widget', ELFSIGHT_INSTALINK_TEXTDOMAIN),
		'base' => 'instalink',
		'class' => '',
		'category' => __('Social', ELFSIGHT_INSTALINK_TEXTDOMAIN),
		'icon' => plugins_url('assets/img/instalink-vc-icon.png', ELFSIGHT_INSTALINK_FILE),
		'params' => array(
			array(
				'type' => 'textfield',
				'heading' => __('Username', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'username',
				'value' => (!empty($username) ? esc_attr($username) : ''),
				'description' => __('Instagram username.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'textfield',
				'heading' => __('Hashtag', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'hashtag',
				'value' => (!empty($hashtag) ? esc_attr($hashtag) : ''),
				'description' => __('Instagram hashtag. You can specify multiple tags separated by comma or space.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'dropdown',
				'heading' => __('Language', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'lang',
				'value' => array(
					__('English', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'en',
					__('Bahasa Indonesia', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'id',
					__('Español', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'es',
					__('Français', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'fr',
					__('Italiano', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'it',
					__('Nederlands', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'nl',
					__('Polski', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'pl',
					__('Português', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'pt-BR',
					__('Русский', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'ru',
					__('Svenska', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'sv',
					__('Türkçe', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'tr',
					__('中文', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'zh-HK',
					__('日本語', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'ja',
					__('한국의', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'ko',
					__('עִבְרִית', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'he'
				),
				'std' => (!empty($lang) ? esc_attr($lang) : ''),
				'description' => __('Choose widget\'s UI language.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'checkbox',
				'param_name' => 'show_heading',
				'value' => array(
					__('Show Heading', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'true'
				),
				'std' => (!empty($show_heading) ? esc_attr($show_heading) : ''),
				'description' => __('Show heading panel.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'checkbox',
				'param_name' => 'scroll',
				'value' => array(
					__('Scroll', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'true'
				),
				'std' => (!empty($scroll) ? esc_attr($scroll) : ''),
				'description' => __('Enable pagination and scroll.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'textfield',
				'heading' => __('Width', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'width',
				'value' => (!empty($width) ? esc_attr($width) : ''),
				'description' => __('Widget width (any CSS valid value: px, %, em, etc). Set "auto" to make the widget responsive.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'textfield',
				'heading' => __('Height', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'height',
				'value' => (!empty($height) ? esc_attr($height) : ''),
				'description' => __('Widget height (any CSS valid value: px, %, em, etc).', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'dropdown',
				'heading' => __('Image Size', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'image_size',
				'value' => array(
					__('Small', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'small',
					__('Medium', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'medium',
					__('Large', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'large',
					__('xLarge', ELFSIGHT_INSTALINK_TEXTDOMAIN) => 'xlarge'
				),
				'std' => (!empty($image_size) ? esc_attr($image_size) : ''),
				'description' => __('Size of images (small, medium, large, xlarge).', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'colorpicker',
				'heading' => __('Header and Button Color', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'bg_color',
				'value' => (!empty($bg_color) ? esc_attr($bg_color) : ''),
				'description' => __('Header and button background color (any CSS valid value).', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'colorpicker',
				'heading' => __('Content Background Color', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'content_bg_color',
				'value' => (!empty($content_bg_color) ? esc_attr($content_bg_color) : ''),
				'description' => __('Content background color (any CSS valid value).', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'colorpicker',
				'heading' => __('Text Color', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'font_color',
				'value' => (!empty($font_color) ? esc_attr($font_color) : ''),
				'description' => __('Header and button text color (any CSS valid value).', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'textfield',
				'heading' => __('Ban by Username', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'ban',
				'value' => (!empty($ban) ? esc_attr($ban) : ''),
				'description' => __('List of usernames to hide their photos from feed separated by comma or space.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			),
			array(
				'type' => 'textfield',
				'heading' => __('Cache media time', ELFSIGHT_INSTALINK_TEXTDOMAIN),
				'param_name' => 'cache_media_time',
				'value' => (!empty($cache_media_time) ? esc_attr($cache_media_time) : ''),
				'description' => __('It defines how long in seconds the photos will be cached in browsers\' localStorage. Set "0" to turn the cache off.', ELFSIGHT_INSTALINK_TEXTDOMAIN)
			)
		)
   ));
}
add_action('vc_before_init', 'elfsight_instalink_vc');

?>
