<?php

if (!defined('ABSPATH')) exit;

?><article class="instalink-admin-page-preferences instalink-admin-page" data-il-admin-page-id="preferences">
	<div class="instalink-admin-page-heading">
		<h2><?php _e('Preferences', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></h2>

		<div class="instalink-admin-page-heading-subheading">
			<?php _e('These settings will be accepted for each InstaLink widget<br> on your website.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
		</div>
    </div>

    <div class="instalink-admin-divider"></div>

	<div class="instalink-admin-page-preferences-form" data-nonce="<?php echo wp_create_nonce('elfsight_instalink_update_preferences_nonce'); ?>">
        <div class="instalink-admin-page-preferences-option-force-script instalink-admin-page-preferences-option">
            <div class="instalink-admin-page-preferences-option-info">
                <h4 class="instalink-admin-page-preferences-option-info-name">
                    <label for="forceScriptAdd"><?php _e('Add InstaLink script to every page', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></label>
                </h4>

                <div class="instalink-admin-caption">
                    <?php _e('By default the plugin adds its scripts only on pages with InstaLink shortcode. This option makes the plugin add scripts on every page. It is useful for ajax websites.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                </div>
            </div>

            <div class="instalink-admin-page-preferences-option-input-container">
                <input type="checkbox" name="preferences_force_script_add" value="true" id="forceScriptAdd" class="instalink-admin-page-preferences-option-input-toggle"<?php echo ($preferences_force_script_add === 'on') ? ' checked' : ''?>>
                <label for="forceScriptAdd"><i></i></label>
            </div>
        </div>

        <div class="instalink-admin-divider"></div>

        <div class="instalink-admin-page-preferences-option-css instalink-admin-page-preferences-option">
            <div class="instalink-admin-page-preferences-option-info">
                <h4 class="instalink-admin-page-preferences-option-info-name">
                    <?php _e('Custom CSS', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                </h4>

                <div class="instalink-admin-caption">
                    <?php _e('Here you can specify custom styles for InstaLink. It will be printed on each page with the widget.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                </div>
            </div>

            <div class="instalink-admin-page-preferences-option-input-container">
                <div class="instalink-admin-page-preferences-option-editor">
                    <div class="instalink-admin-page-preferences-option-editor-code" id="instaLinkPreferencesSnippetCSS"><?php echo htmlspecialchars($preferences_custom_css)?></div>
                </div>

                <div class="instalink-admin-page-preferences-option-save-container">
                    <a href="#" class="instalink-admin-page-preferences-option-css-save instalink-admin-page-preferences-option-save instalink-admin-button-green instalink-admin-button">
                        <span class="instalink-admin-page-preferences-option-save-label"><?php _e('Save', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>

                        <span class="instalink-admin-page-preferences-option-save-loader"></span>
                    </a>

                    <span class="instalink-admin-page-preferences-option-save-success">
                        <span class="instalink-admin-icon-check-green-small instalink-admin-icon"></span><span class="instalink-admin-page-preferences-option-save-success-label"><?php _e('Done!', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>
                    </span>

                    <span class="instalink-admin-page-preferences-option-save-error"></span>
                </div>
            </div>
        </div>

        <div class="instalink-admin-divider"></div>

        <div class="instalink-admin-page-preferences-option-js instalink-admin-page-preferences-option">
            <div class="instalink-admin-page-preferences-option-info">
                <h4 class="instalink-admin-page-preferences-option-info-name">
                    <?php _e('Custom JavaScript', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                </h4>

                <div class="instalink-admin-caption">
                    <?php _e('Here you can specify custom JS for initiation of InstaLink. This script will be printed on each page with the widget.', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                </div>
            </div>
            
            <div class="instalink-admin-page-preferences-option-input-container">
                <div class="instalink-admin-page-preferences-option-editor">
                    <div class="instalink-admin-page-preferences-option-editor-code" id="instaLinkPreferencesSnippetJS"><?php echo htmlspecialchars($preferences_custom_js) ?></div>
                </div>

                <div class="instalink-admin-page-preferences-option-save-container">
                    <a href="#" class="instalink-admin-page-preferences-option-js-save instalink-admin-page-preferences-option-save instalink-admin-button-green instalink-admin-button">
                        <span class="instalink-admin-page-preferences-option-save-label"><?php _e('Save', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>

                        <span class="instalink-admin-page-preferences-option-save-loader"></span>
                    </a>

                    <span class="instalink-admin-page-preferences-option-save-success">
                        <span class="instalink-admin-icon-check-green-small instalink-admin-icon"></span><span class="instalink-admin-page-preferences-option-save-success-label"><?php _e('Done!', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>
                    </span>

                    <span class="instalink-admin-page-preferences-option-save-error"></span>
                </div>
            </div>
        </div>

        <div class="instalink-admin-divider"></div>

        <div class="instalink-admin-page-preferences-option-api-settings instalink-admin-page-preferences-option">
            <div class="instalink-admin-page-preferences-option-info">
                <h4 class="instalink-admin-page-preferences-option-info-name">
                    <label><?php _e('API Settings (Advanced)', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></label>
                </h4>

                <div class="instalink-admin-caption">
                    <div><?php _e('You can manage some settings of the plugin\'s API. There are 4 available options:', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></div>
                    <ul>
                        <li><b><?php _e('Media limit', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></b> <?php _e('allows you to restrict the number of photos which you get from Instagram. The number of photos influences of the plugin\'s performance. We don\'t recommend you to set more than 100 photos without a real need. Default value: 100', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></li>
                        <li><b><?php _e('Cache time', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></b> <?php _e('defines how often in seconds the plugin requests Instagram and loads new photos. The option also affects the plugin\'s loading speed and your server load. We don\'t recommend you to set less than 3600 seconds. Default value: 3600', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></li>
                        <li><b><?php _e('Allowed usernames', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></b> <?php _e('is a security option. You can set the list of available usernames (without "@" symbol) separated by commas to prevent the usage of the plugin by third-parties. Default value: *', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></li>
                        <li><b><?php _e('Allowed tags', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></b> <?php _e('is a security option. You can set the list of available hashtags (without "#"" symbol) separated by commas to prevent the usage of the plugin by third-parties. Default value: *', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></li>
                    </ul>
                </div>
            </div>

            <div class="instalink-admin-page-preferences-option-input-container">
                <label class="instalink-admin-page-preferences-option-api-settings-media-limit">
                    <?php _e('Media limit', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                    <input type="text" name="preferences_media_limit" value="<?php echo $preferences_media_limit; ?>">
                </label>

                <label class="instalink-admin-page-preferences-option-api-settings-cache-time">
                    <?php _e('Cache time', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                    <input type="text" name="preferences_cache_time" value="<?php echo $preferences_cache_time; ?>">
                </label>

                <label class="instalink-admin-page-preferences-option-api-settings-allowed-usernames">
                    <?php _e('Allowed usernames', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                    <input type="text" name="preferences_allowed_usernames" value="<?php echo $preferences_allowed_usernames; ?>">
                </label>

                <label class="instalink-admin-page-preferences-option-api-settings-allowed-tags">
                    <?php _e('Allowed tags', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                    <input type="text" name="preferences_allowed_tags" value="<?php echo $preferences_allowed_tags; ?>">
                </label>
                
                <div class="instalink-admin-page-preferences-option-save-container">
                    <?php if(empty($preferences_api_config_error)) {?>
                        <a href="#" class="instalink-admin-page-preferences-option-api-settings-save instalink-admin-page-preferences-option-save instalink-admin-button-green instalink-admin-button">
                            <span class="instalink-admin-page-preferences-option-save-label"><?php _e('Save', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>

                            <span class="instalink-admin-page-preferences-option-save-loader"></span>
                        </a>

                        <span class="instalink-admin-page-preferences-option-save-success">
                            <span class="instalink-admin-icon-check-green-small instalink-admin-icon"></span><span class="instalink-admin-page-preferences-option-save-success-label"><?php _e('Done!', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>
                        </span>

                        <span class="instalink-admin-page-preferences-option-save-error"></span>
                    <?php } else { ?>
                        <div class="instalink-admin-page-preferences-option-save-error"><?php echo $preferences_api_config_error; ?></div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="instalink-admin-divider"></div>

        <div class="instalink-admin-page-preferences-option-custom-api-url instalink-admin-page-preferences-option">
            <div class="instalink-admin-page-preferences-option-info">
                <h4 class="instalink-admin-page-preferences-option-info-name">
                    <label for="customApiUrl"><?php _e('Custom API URL', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></label>
                </h4>

                <div class="instalink-admin-caption">
                    <?php _e('Defines URL address to the plugin api directory. In case you don\'t know how this option works, please, don\'t change the specified URL. Default value: ' , ELFSIGHT_INSTALINK_TEXTDOMAIN); ?>
                    <?php echo ELFSIGHT_INSTALINK_API_URL; ?>
                </div>
            </div>

            <div class="instalink-admin-page-preferences-option-input-container">
                <input type="text" name="preferences_custom_api_url" id="customApiUrl" value="<?php echo $preferences_custom_api_url; ?>">
                
                <div class="instalink-admin-page-preferences-option-save-container">
                    <a href="#" class="instalink-admin-page-preferences-option-custom-api-url-save instalink-admin-page-preferences-option-save instalink-admin-button-green instalink-admin-button">
                        <span class="instalink-admin-page-preferences-option-save-label"><?php _e('Save', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>

                        <span class="instalink-admin-page-preferences-option-save-loader"></span>
                    </a>

                    <span class="instalink-admin-page-preferences-option-save-success">
                        <span class="instalink-admin-icon-check-green-small instalink-admin-icon"></span><span class="instalink-admin-page-preferences-option-save-success-label"><?php _e('Done!', ELFSIGHT_INSTALINK_TEXTDOMAIN); ?></span>
                    </span>

                    <span class="instalink-admin-page-preferences-option-save-error"></span>
                </div>
            </div>
        </div>
    </div>
</article>