<?php

/**
 * Initialize license client on 'qligg_pro_init' hook.
 * This hook is fired BEFORE the Pro plugin decides whether to initialize,
 * allowing the license client to verify license status first.
 *
 * @since 4.4.1
 */
add_action(
	'qligg_pro_init',
	function() {
		global $qligg_license_client;

		if ( ! isset( $qligg_license_client ) ) {

			$qligg_license_client = ql_license_client(
				array(
					'api_url'           => 'https://quadlayers.com/wp-json/wc/wlm/',
					'product_key'       => 'dc9213682a2360ae82d0d03ea09a9f83',
					'rest_namespace'    => 'qligg',
					'parent_menu_slug'  => 'qligg_backend',
					'license_menu_slug' => false,
					'license_url'       => admin_url( 'admin.php?page=qligg_backend&tab=license' ),
					'license_key_url'   => 'https://quadlayers.com/account/licenses/?utm_source=qligg_plugin_pro&utm_medium=dashboard_notice&utm_campaign=license&utm_content=license_key_link',
					'support_url'       => 'https://quadlayers.com/account/support/?utm_source=qligg_plugin_pro&utm_medium=dashboard_notice&utm_campaign=support&utm_content=support_link',
					'plugin_file'       => QLIGG_PRO_PLUGIN_FILE,
				)
			);
		}

		return $qligg_license_client;
	},
	5 // Priority 5: Execute BEFORE the Pro plugin's callback (default priority 10).
);
