<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Shortcode: us_btn
 *
 * @var   $shortcode string Current shortcode name
 * @var   $config    array Shortcode's config
 *
 * @param $config    ['atts'] array Shortcode's attributes and default values
 */
vc_map(
	array(
		'base' => 'us_btn',
		'name' => __( 'Button', 'us' ),
		'description' => '',
		'icon' => 'icon-wpb-ui-button',
		'category' => us_translate( 'Content', 'js_composer' ),
		'weight' => 330,
		'params' => array(
			array(
				'param_name' => 'text',
				'heading' => __( 'Button Label', 'us' ),
				'type' => 'textfield',
				'value' => __( 'Click Me', 'us' ),
				'std' => $config['atts']['text'],
				'edit_field_class' => 'vc_col-sm-6',
				'holder' => 'button',
				'class' => 'wpb_button',
				'weight' => 120,
			),
			array(
				'param_name' => 'link',
				'heading' => __( 'Button Link', 'us' ),
				'type' => 'vc_link',
				'std' => $config['atts']['link'],
				'edit_field_class' => 'vc_col-sm-6',
				'weight' => 110,
			),
			array(
				'param_name' => 'style',
				'heading' => __( 'Button Style', 'us' ),
				'type' => 'dropdown',
				'value' => array(
					__( 'Solid', 'us' ) => 'solid',
					__( 'Outlined', 'us' ) => 'outlined',
				),
				'std' => $config['atts']['style'],
				'edit_field_class' => 'vc_col-sm-6',
				'weight' => 100,
			),
			array(
				'param_name' => 'color',
				'heading' => __( 'Button Color', 'us' ),
				'type' => 'dropdown',
				'value' => array(
					__( 'Primary (theme color)', 'us' ) => 'primary',
					__( 'Secondary (theme color)', 'us' ) => 'secondary',
					__( 'Border (theme color)', 'us' ) => 'light',
					__( 'Text (theme color)', 'us' ) => 'contrast',
					us_translate( 'Black' ) => 'black',
					us_translate( 'White' ) => 'white',
					__( 'Purple', 'us' ) => 'purple',
					__( 'Pink', 'us' ) => 'pink',
					__( 'Red', 'us' ) => 'red',
					__( 'Yellow', 'us' ) => 'yellow',
					__( 'Lime', 'us' ) => 'lime',
					__( 'Green', 'us' ) => 'green',
					__( 'Teal', 'us' ) => 'teal',
					__( 'Blue', 'us' ) => 'blue',
					__( 'Navy', 'us' ) => 'navy',
					__( 'Midnight', 'us' ) => 'midnight',
					__( 'Brown', 'us' ) => 'brown',
					__( 'Cream', 'us' ) => 'cream',
					__( 'Transparent', 'us' ) => 'transparent',
				),
				'std' => $config['atts']['color'],
				'edit_field_class' => 'vc_col-sm-6',
				'weight' => 90,
			),
			array(
				'param_name' => 'size',
				'heading' => __( 'Button Size', 'us' ),
				'type' => 'textfield',
				'std' => $config['atts']['size'],
				'edit_field_class' => 'vc_col-sm-6',
				'weight' => 60,
			),
			array(
				'param_name' => 'align',
				'heading' => __( 'Button Alignment', 'us' ),
				'type' => 'dropdown',
				'value' => array(
					us_translate( 'Left' ) => 'left',
					us_translate( 'Center' ) => 'center',
					us_translate( 'Right' ) => 'right',
				),
				'std' => $config['atts']['align'],
				'edit_field_class' => 'vc_col-sm-6',
				'weight' => 50,
			),
			array(
				'type' => 'us_icon',
				'heading' => __( 'Icon', 'us' ),
				'param_name' => 'icon',
				'std' => $config['atts']['icon'],
				'weight' => 40,
			),
			array(
				'param_name' => 'iconpos',
				'heading' => __( 'Icon Position', 'us' ),
				'type' => 'dropdown',
				'value' => array(
					us_translate( 'Left' ) => 'left',
					us_translate( 'Right' ) => 'right',
				),
				'std' => $config['atts']['iconpos'],
				'weight' => 30,
			),
			array(
				'param_name' => 'el_class',
				'heading' => us_translate( 'Extra class name', 'js_composer' ),
				'type' => 'textfield',
				'std' => $config['atts']['el_class'],
				'weight' => 10,
			),
		),
		'js_view' => 'VcButtonView',
	)
);
