<?php

if ( $settings->three_d ) {
	$bg_grad_start = FLBuilderColor::adjust_brightness( $settings->bg_color, 30, 'lighten' );
	$border_color = FLBuilderColor::adjust_brightness( $settings->bg_color, 20, 'darken' );
}
if ( $settings->three_d && ! empty( $settings->bg_hover_color ) ) {
	$bg_hover_grad_start = FLBuilderColor::adjust_brightness( $settings->bg_hover_color, 30, 'lighten' );
	$border_hover_color = FLBuilderColor::adjust_brightness( $settings->bg_hover_color, 20, 'darken' );
}

?>
.fl-node-<?php echo $id; ?> .fl-module-content {
	font-size: <?php echo $settings->size; ?>px;
	line-height: 1;
<?php if ( ! empty( $settings->align ) ) : ?>
	text-align: <?php echo $settings->align; ?>
<?php endif; ?>
}

.fl-node-<?php echo $id; ?> .fl-icon-wrap {
	line-height: 1;
	text-align: center;
	vertical-align: middle;
	box-shadow:none;
	<?php if ( $settings->bg_color ) : // Rounded Styles ?>
	border-radius: 100%;
	padding: 0.3em;
	background: #<?php echo $settings->bg_color; ?>;
	<?php endif; ?>
	<?php if ( $settings->bg_color && $settings->three_d ) : // 3D Styles ?>
	background: linear-gradient(to bottom,  #<?php echo $bg_grad_start; ?> 0%,#<?php echo $settings->bg_color; ?> 100%); /* W3C *//* IE6-9 */
	border: 1px solid #<?php echo $border_color; ?>;
	<?php endif; ?>
}

.fl-node-<?php echo $id; ?> .iconpress-icon {
	<?php if ( $settings->color ) : ?>
	color: #<?php echo $settings->color; ?>;
	<?php endif; ?>
	font-size: 1em;
	display:block;
}
.fl-node-<?php echo $id; ?> .fl-icon-wrap:hover,
.fl-node-<?php echo $id; ?> a:hover .fl-icon-wrap {
	<?php if ( ! empty( $settings->bg_hover_color ) ) : ?>
	background: #<?php echo $settings->bg_hover_color; ?>;
	<?php endif; ?>
	<?php if ( $settings->three_d && ! empty( $settings->bg_hover_color ) ) : // 3D Styles ?>
	background: linear-gradient(to bottom,  #<?php echo $bg_hover_grad_start; ?> 0%,#<?php echo $settings->bg_hover_color; ?> 100%); /* W3C */
	border: 1px solid #<?php echo $border_hover_color; ?>;
	<?php endif; ?>
	<?php if ( ! empty( $settings->hover_color ) ) : ?>
	color: #<?php echo $settings->hover_color; ?>;
	<?php endif; ?>
}

<?php if ( $global_settings->responsive_enabled && ( 'custom' == $settings->r_align ) ) : ?>
@media (max-width: <?php echo $global_settings->responsive_breakpoint; ?>px) {
	.fl-node-<?php echo $id; ?> .fl-module-content {
		text-align: <?php echo $settings->r_custom_align ?> !important;
	}
}
<?php endif; ?>
