<?php

namespace IconPress\Helpers;

use IconPress\Helpers\Option;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Utility
 *
 * Various helpers
 *
 * @package IconPress\Helpers
 */
class Utility
{

	public static $user_id = 0;

	function __construct(){
		add_action('init', [ $this, 'getUser' ]);
	}


	public static function unslugify( $slug ) {
		$slug = str_replace( '.svg', '', $slug );
		$slug = str_replace( '-', ' ', $slug );
		$slug = str_replace( '_', ' ', $slug );
		$slug = str_replace( ',', ' ', $slug );
		$slug = str_replace( '.', ' ', $slug );
		return ucwords( $slug );
	}

	public static function getUser(){
		$current_user = wp_get_current_user();
		self::$user_id = $current_user->ID;
	}

	public static function debugMode() {
		$ip_options = get_option( Option::getOptionName( Option::PLUGIN_OPTIONS ), [] );
		return isset( $ip_options['enable_debug'] ) ? $ip_options['enable_debug'] : '0';
	}

}
new Utility();