<?php
/**
 * Plugin Name: IconPress PRO
 * Plugin URI: https://iconpress.io/?utm_source=wp-plugins&utm_campaign=plugin-uri&utm_medium=wp-dash
 * Description: IconPress PRO adds new features to IconPress Lite plugin. Access over 100000 icons, upload SVG's and edit your icons.
 * TextDomain: iconpress
 * DomainPath: /languages
 * Author: پرشین اسکریپت
 * Version: 1.4.2
 * Author URI: https://www.persianscript.ir
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * Skip loading when installing.
 */
if ( defined( 'WP_INSTALLING' ) && WP_INSTALLING ) {
	return;
}

if ( isset( $_REQUEST['action'] ) && ( 'heartbeat' == strtolower( $_REQUEST['action'] ) ) ) {
	return;
}

define( 'ICONPRESS_VERSION', '1.4.2' );
define( 'ICONPRESS_DIR', plugin_dir_path( __FILE__ ) );
define( 'ICONPRESS_URI', plugin_dir_url( __FILE__ ) );
define( 'ICONPRESS_P', file_exists( ICONPRESS_DIR . 'extend/extend.php') );

/**
 * Check requirements
 */
$IconPress_InitErrors = array();
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

//#! Required for svg parser
if ( ! class_exists( 'SimpleXMLElement' ) ) {
	$IconPress_InitErrors[] = sprintf( __( 'The <strong>%s</strong> class is not available on your server. Please contact your hosting support and ask them to enable this function for you.', 'iconpress' ), 'SimpleXMLElement' );
}
//#! Required in Option
elseif ( ! class_exists( 'ReflectionClass' ) ) {
	$IconPress_InitErrors[] = sprintf( __( 'The <strong>%s</strong> class is not available on your server. Please contact your hosting support and ask them to enable this function for you.', 'iconpress' ), 'ReflectionClass' );
}
//#! [PHP >= v5.4.0] Required PHP min version
elseif ( version_compare( phpversion(), '5.4.0', '<' ) ) {
	$IconPress_InitErrors[] = sprintf( __( 'The PHP version <strong>%s</strong> is needed in order to be able to run the <strong>%s</strong> plugin. Please contact your hosting support and ask them to upgrade the PHP version to at least v<strong>%s</strong> for you.', 'iconpress' ),
		'5.4.0', 'IconPress', '5.4.0' );
}
// REST API was included starting with WordPress 4.7.
elseif ( version_compare( get_bloginfo( 'version' ), '4.7', '<' ) || ! class_exists( 'WP_REST_Server' ) ) {
	$IconPress_InitErrors[] = __( '<strong>WordPress Rest API</strong> is needed in order to be able to run the <strong>IconPress</strong> plugin. Please update WordPress to the latest version, or at least version 4.7 .', 'iconpress' );
}

// If Disable JSON API plugin is installed
if ( is_plugin_active( 'disable-json-api/disable-json-api.php' ) ) {
	$IconPress_InitErrors[] = __( '<strong><a href="https://wordpress.org/plugins/disable-json-api/" target="_blank">Disable REST API</a></strong> plugin is installed and active. WordPress Rest API is needed in order to be able to run the <strong>IconPress</strong> plugin. If you intentionally disabled WordPress Rest API by installing this plugin, please drop us an email at hello@iconpress.io and let us know. We want to gather as much feedback as possible to see if we can find a workaround for it.', 'iconpress' );
}

/**
 * Render the notices about the plugin's requirements
 */
if ( ! empty( $IconPress_InitErrors ) ) {

	function IconPress_showInstallErrors() {
		global $IconPress_InitErrors;
		echo '<div class="notice notice-error">';
		foreach ( $IconPress_InitErrors as $error ) {
			echo "<p>{$error}</p>";
		}
		echo '<p>' . sprintf( __( '<strong>%s</strong> has been deactivated.', 'iconpress' ), 'IconPress PRO' ) . '</p>';
		echo '</div>';
	}

	add_action( 'admin_notices', 'IconPress_showInstallErrors' );

	\deactivate_plugins( 'iconpress/iconpress.php' );
	unset( $_GET['activate'], $_GET['plugin_status'], $_GET['activate-multi'] );

	return;
}

//#! Load core files
require( ICONPRESS_DIR . 'lib/Base.php' );
require( ICONPRESS_DIR . 'lib/helpers/Utility.php' );
require( ICONPRESS_DIR . 'lib/helpers/Svg_support.php' );
require( ICONPRESS_DIR . 'lib/helpers/Generator.php' );
require( ICONPRESS_DIR . 'lib/helpers/Option.php' );
require( ICONPRESS_DIR . 'lib/helpers/FileSystem.php' );
require( ICONPRESS_DIR . 'lib/helpers/Importer.php' );
require( ICONPRESS_DIR . 'lib/helpers/RestAPI.php' );
require( ICONPRESS_DIR . 'lib/helpers/Validator.php' );
require( ICONPRESS_DIR . 'lib/helpers/Portability.php' );

require( ICONPRESS_DIR . 'lib/db/Base.php' );
require( ICONPRESS_DIR . 'lib/db/Collections.php' );
require( ICONPRESS_DIR . 'lib/db/Icons.php' );

require_once( ICONPRESS_DIR . 'lib/svg-sanitizer/load.php' );
//#! Extends SvgSanitizer, so it must be loaded after
require( ICONPRESS_DIR . 'lib/helpers/SvgTagExt.php' );

// Integrations
require( ICONPRESS_DIR . 'lib/integrations/inc.php' );

register_activation_hook( __FILE__, [ '\\IconPress\\Base', 'hook_on_activate' ] );
register_deactivation_hook( __FILE__, [ '\\IconPress\\Base', 'hook_on_deactivate' ] );
register_uninstall_hook( __FILE__, [ '\\IconPress\\Base', 'hook_on_uninstall' ] );


//#! Upgrade + integrity check
add_action( 'init', [ '\\IconPress\\Database\\Base', 'checkTables' ] );
add_action( 'rest_api_init', [ '\\IconPress\\Helpers\\RestAPI', 'registerRoutes' ], 190 );

if( ICONPRESS_P ) require( ICONPRESS_DIR . 'extend/extend.php' );