<?php

namespace IconPress\IconFinder;

use IconPress\IconFinder\Api;
use IconPress\IconFinder\Rest;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Class Base
 * @package IconPress\IconFinder
 */
class Base
{
	const ICONFINDER_API_URL = 'https://api.iconfinder.com/v3/';
	const ICONFINDER_ENDPOINT_NAMESPACE = 'iconpress/v1/iconfinder/';

	function __construct()
	{
		add_action( 'admin_enqueue_scripts', [ $this, 'loadAdminScripts' ] );
		add_filter( 'iconpress/panes', [ $this, 'addIconfinderPane' ] );
		add_filter( 'iconpress/download_info', [ $this, 'addIconfinderDownloadMethod' ], 10, 2 );
		add_filter( 'iconpress/icon_endpoint', [ $this, 'addIconfinderIconEndpoint' ] );
	}

	function loadAdminScripts()
	{
		wp_enqueue_script( 'iconfinder-api-integration-js', ICONPRESS_URI . '/extend/lib/iconfinder/js/app.js', [ 'jquery' ], ICONPRESS_VERSION, true );

		// check if it's an IconFinder PRO account
		$if_pro = false;

		if ( $if_pro_details = get_transient( 'iconpress_iconfinder_user_details' ) ) {
			$if_pro = $if_pro_details;
		}
		else {
			if ( $user_details = Rest::iconfinder_getUserDetails() ) {
				$if_pro = $user_details;
			}
		}

		if ( is_array( $if_pro ) ) {
			$if_pro = ( isset( $if_pro['organization']['pro_subscription']['is_usable'] ) && $if_pro['organization']['pro_subscription']['is_usable'] );
		}

		wp_localize_script( 'iconfinder-api-integration-js', 'iconFinderApiLocale', [
			'if_nonce_name' => Api::NONCE_NAME,
			'if_nonce' => wp_create_nonce( Api::NONCE_ACTION ),
			'if_pro' => $if_pro
		] );
	}

	function addIconfinderPane( $panes = [] )
	{
		$ifApi = Api::getInstance();
		if ( $ifApi->isConnected() ) {
			$panes[] = [
				'id' => 'iconFinder',
				'title' => __( 'IconFinder', 'iconpress' ),
				'type' => 'iconfinder',
				// How many collections to load on each request
				'count_collections' => 3,
				// How many icons to load on each request
				'count_icons' => 20,
				// Collections Endpoint
				'collectionsEndpoint' => rest_url( self::ICONFINDER_ENDPOINT_NAMESPACE ) . 'iconsets',
				// Icons Endpoint
				'iconsEndpoint' => rest_url( self::ICONFINDER_ENDPOINT_NAMESPACE ) . 'iconsets_icons',
				// enable browser cache?
				'cache' => true,
				// show filter?
				'showFilter' => true
			];
		}
		return $panes;
	}

	function addIconfinderDownloadMethod( $types = [], $icon )
	{
		if( isset( $icon['type'] ) && $icon['type'] == 'iconfinder' ){

			$types['iconfinder']['download_method'] = 'svg_file';

			$ifApi = Api::getInstance();
			if ( $ifApi->isConnected() ) {
				//#! Send request
				$authInfo = \IconPress\Dashboard\Base::getAuthInfo();
				if ( empty( $authInfo ) || ! $authInfo['connected'] || empty( $authInfo['api_key'] ) ) {
					$types['iconfinder']['download_url'] = '';
				}
				else {

					$types['iconfinder']['download_url'] = add_query_arg( [
						'ipif' => base64_encode( json_encode( [
								'action' => 'download_icon',
								'api_key' => $authInfo['api_key'],
								'site_url' => trailingslashit( get_bloginfo( 'url' ) ),
								'url' => $icon['download_url']
							] ) )
						], 'https://customers.iconpress.io/index.php' );
				}
			}
		}

		return $types;
	}

	function addIconfinderIconEndpoint( $endpoints = [] )
	{
		$endpoints['iconfinder'] = rest_url( self::ICONFINDER_ENDPOINT_NAMESPACE ) . 'icons';
		return $endpoints;
	}
}

//#! Initialize the class
new Base();
