<?php

namespace IconPress\Extend;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Base
 *
 * The plugin's base class
 *
 * @package IconPress
 */
class Base
{

	/**
	 * Holds the reference to the instance of this class
	 * @var Base
	 */
	private static $_instance = null;

	/**
	 * Base constructor.
	 */
	private function __construct()
	{
		add_action( 'admin_menu', [ $this, 'addMenuPages' ] );

		add_filter('iconpress/iconPressConfig', [ $this, 'addIpConfig' ], 10 );
		add_action( 'iconpress/topmenu', [ $this, 'addActivateButton' ], 10 );

		add_filter( 'plugin_action_links', [ $this, 'plugin_action_links_activate' ], 20, 2 );
	}

	/**
	 * Retrieve the reference to the instance of this class
	 * @return Base
	 */
	public static function getInstance()
	{
		if ( is_null( self::$_instance ) || ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self;
		}
		return self::$_instance;
	}


	/**
	 * Create the plugin's main menu
	 * @see add_action( 'admin_menu')
	 * @see action "addMenuPages"
	 * @param string $hook
	 */
	public function addMenuPages( $hook = '' )
	{
		$isConnected = \IconPress\Dashboard\Base::isConnected();

		if ( $isConnected ) {
			$int_title = __( 'Integrations', 'iconpress' );
		}
		else {
			$int_title = __( 'Activate IconPress', 'iconpress' );
		}

		add_submenu_page(
			\IconPress\Base::PLUGIN_SLUG,
			$int_title,
			$int_title,
			\IconPress\Base::CAPABILITY,
			\IconPress\Base::PLUGIN_SLUG . '_integrations',
			[ $this, 'page_render_integrations' ]
		);

		if ( $isConnected ) {
			add_submenu_page(
				\IconPress\Base::PLUGIN_SLUG,
				__( 'Upload icons', 'iconpress' ),
				__( 'Upload icons', 'iconpress' ),
				\IconPress\Base::CAPABILITY,
				\IconPress\Base::PLUGIN_SLUG . '_upload',
				[ $this, 'page_render_upload' ]
			);
		}
	}

	public function page_render_integrations()
	{
		require( ICONPRESS_DIR . 'extend/admin/pages/integrations.php' );
	}

	public function page_render_upload()
	{
		wp_enqueue_script( 'dropzone-js', ICONPRESS_URI . 'assets/js/vendor/dropzone/dropzone.min.js' );
		wp_enqueue_style( 'dropzone-css', ICONPRESS_URI . 'assets/js/vendor/dropzone/basic.min.css', [], ICONPRESS_VERSION );

		require( ICONPRESS_DIR . 'extend/admin/pages/upload.php' );
	}

	public function addIpConfig( $options ){
		$options['is_connected'] = \IconPress\Dashboard\Base::isConnected();
		$options['more_icons_url'] = !\IconPress\Dashboard\Base::isConnected() ? admin_url( 'admin.php?page=' . \IconPress\Base::PLUGIN_SLUG . '_integrations' ) : '';
		// translations
		$options['translations']['ICONFINDER_PRO'] = __( "IconFinder PRO", 'iconpress' );
		$options['translations']['BUY_COLLECTION_FOR'] = __( "Buy Collection for", 'iconpress' );
		$options['translations']['PREMIUM'] = __( "PREMIUM", 'iconpress' );
		$options['translations']['BUY_FOR'] = __( "Buy for", 'iconpress' );
		$options['translations']['FREE_ONLY'] = __( "Free", 'iconpress' );
		$options['translations']['PREMIUM_ONLY'] = __( "Premium", 'iconpress' );
		$options['translations']['SVG_CODE_EDITOR'] = __( "SVG CODE EDITOR", 'iconpress' );
		$options['translations']['DOWNLOAD_ICON'] = __( "Download Icon", 'iconpress' );
		$options['translations']['EDIT_CODE'] = __( "Edit Code", 'iconpress' );

		return $options;
	}

	public function addActivateButton(){

		if( !\IconPress\Dashboard\Base::isConnected() ):
		 ?>
		<li class="ip-btnGoPro ip-dropDown">
			<?php

			$c = add_query_arg( [ 'page' => \IconPress\Base::PLUGIN_SLUG . '_integrations' ], admin_url( 'admin.php' ) );
			$activateLink = sprintf( trailingslashit( \IconPress\Dashboard\Base::API_URL ) . 'index.php?site_url=%s&action=%s&client=%s&version=%s', $c, 'connect', 'IconPress', ICONPRESS_VERSION );
			?>

			<a href="<?php echo esc_url( $activateLink ); ?>" target="_blank" class="ip-btn ip-btn--lined ip-btn--blue"><?php _e( 'ACTIVATE NOW', 'iconpress' ); ?></a>

			<div class="ip-btnGoPro-popover ip-dropDown-popover">
				<div class="ip-btnGoPro-popoverInner ip-dropDown-popoverInner">
					<h3><?php _e( 'Why should you activate IconPress?', 'iconpress' ); ?></h3>
					<ul class="ip-goPro-featureList">
						<li><?php echo IconPress__getSvgIcon( [ 'id' => 'iconpress-icon-check', 'style' => 'opacity:.3' ] ); ?><?php echo sprintf(__( 'Access to tens of thousand of icons (in all sorts of colors and shapes) from <a href="%s">IconFinder</a>.', 'iconpress' ), 'https://www.iconfinder.com/?ref=iconpress'); ?></li>
						<li><?php echo IconPress__getSvgIcon( [ 'id' => 'iconpress-icon-check', 'style' => 'opacity:.3' ] ); ?><?php _e( 'Upload your own icons.', 'iconpress' ); ?></li>
						<li><?php echo IconPress__getSvgIcon( [ 'id' => 'iconpress-icon-check', 'style' => 'opacity:.3' ] ); ?><?php _e( 'Edit Icon\'s code', 'iconpress' ); ?></li>
						<li><?php echo IconPress__getSvgIcon( [ 'id' => 'iconpress-icon-check', 'style' => 'opacity:.3' ] ); ?><?php _e( 'Download Icons', 'iconpress' ); ?></li>
						<li><?php echo IconPress__getSvgIcon( [ 'id' => 'iconpress-icon-check', 'style' => 'opacity:.3' ] ); ?><?php _e( 'and so much more to come!', 'iconpress' ); ?></li>
					</ul>
				</div>
			</div>

		</li>
		<?php
		endif;
	}

	public static function registerRoutes()
	{

		register_rest_route( \IconPress\Helpers\RestAPI::ICONPRESS_NAMESPACE, '/download_icon', [
			[
				'methods' => \WP_REST_Server::CREATABLE,
				'callback' => [ '\\IconPress\\Extend\\Helpers\\RestAPI', 'getIconCode' ],
				'args' => [
					'internal_id' => [
						'required' => true,
						'type' => 'string',
						'sanitize_callback' => 'sanitize_text_field',
						'validate_callback' => 'rest_validate_request_arg',
					],
				],
			],
		] );


		register_rest_route( \IconPress\Helpers\RestAPI::ICONPRESS_NAMESPACE, '/save_icon_code', [
			[
				'methods' => \WP_REST_Server::CREATABLE,
				'callback' => [ '\\IconPress\\Extend\\Helpers\\RestAPI', 'saveIconCode' ],
				'args' => [
					'internal_id' => [
						'required' => true,
						'type' => 'string',
						'sanitize_callback' => 'sanitize_text_field',
						'validate_callback' => 'rest_validate_request_arg',
					],
					'code' => [
						'required' => true,
						'type' => 'string',
						// 'sanitize_callback' => 'SANITIZE_SVG',
						'validate_callback' => 'rest_validate_request_arg',
					],
					'overwrite' => [
						'required' => true,
						'type' => 'boolean',
						'sanitize_callback' => [ '\\IconPress\\Helpers\\RestAPI', 'sanitizeBool' ],
						'validate_callback' => 'rest_validate_request_arg',
					]
				],
			],
		] );

		/**
		 * Used for uploading SVG files in IconPress > Upload icons.
		 */
		register_rest_route( \IconPress\Helpers\RestAPI::ICONPRESS_NAMESPACE, '/upload_svg', [
			[
				'methods' => \WP_REST_Server::CREATABLE,
				'callback' => [ '\\IconPress\\Extend\\Helpers\\RestAPI', 'upload_icon' ],
			]
		] );

	}

	public static function plugin_action_links_activate( $links, $file ) {

		if ( $file == plugin_basename( ICONPRESS_DIR . 'iconpress.php') && !\IconPress\Dashboard\Base::isConnected() ) {
			$links[] = '<a href="' . esc_url( admin_url( 'admin.php?page=' . \IconPress\Base::PLUGIN_SLUG . '_integrations') ) . '">'.esc_html__( 'Activate License' , 'iconpress').'</a>';
		}

		return $links;
	}


}

Base::getInstance();