<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * API Interface class.
 */
class Iconic_WLV_Api {
	/**
	 * Init
	 */
	public static function run() {
		add_action( 'rest_api_init', array( __CLASS__, 'register_custom_fields' ) );
	}

	/**
	 * Register REST API field.
	 *
	 * @return void
	 */
	public static function register_custom_fields() {
		register_rest_field(
			'cpt_iconic_wlv',
			'linked_variation_data',
			array(
				'get_callback'    => function ( $object ) {
					if ( empty( $object['id'] ) ) {
						return;
					}
					$group = new Iconic_WLV_Linked_Variations_Group( $object['id'] );

					return array(
						'product_ids' => $group->get_product_ids(),
						'attributes'  => $group->get_attributes(),
						'show_images' => $group->is_show_image(),
						'style'       => $group->get_style(),
					);
				},
				'update_callback' => null,
				'schema'          => array(
					'type' => 'array',
				),
			)
		);
	}
}
