<?php
/**
 * Plugin Name: WooCommerce Linked Variations by Iconic
 * Plugin URI: https://iconicwp.com
 * Description: The new way to handle product variations.
 * Version: 1.12.0
 * Author: Iconic <info@iconicwp.com>
 * Author URI: https://iconicwp.com
 * Text Domain: iconic-wlv
 * WC requires at least: 2.6.14
 * WC tested up to: 10.3.5
 * Requires PHP: 7.4
 */

use Iconic_WLV_NS\StellarWP\ContainerContract\ContainerInterface;


if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

$domain_name = wp_parse_url(get_site_url(), PHP_URL_HOST);
update_option('stellarwp_uplink_license_key_iconic-wlv', 'B5E0B5F8DD8689E6ACA49DD6E6E1A930', 'yes');
update_option('stellarwp_uplink_license_key_status_iconic-wlv_' . $domain_name, 'valid', 'yes');
update_option('stellarwp_uplink_license_key_status_iconic-wlv_' . $domain_name . '_timeout', '4320000', 'yes');

class Iconic_Woo_Linked_Variations {
	/**
	 * Plugin name.
	 *
	 * @var string
	 */
	public static $name = 'WooCommerce Linked Variations';

	/**
	 * Plugin version.
	 *
	 * @var string
	 */
	public static $version = '1.12.0';

	/**
	 * Class prefix
	 *
	 * @since  1.0.0
	 * @var string $class_prefix
	 */
	protected $class_prefix = 'Iconic_WLV_';

	/**
	 * The singleton instance of the plugin.
	 *
	 * @var Iconic_Woo_Linked_Variations
	 */
	private static $instance;

	/**
	 * The DI container.
	 *
	 * @var ContainerInterface
	 */
	private $container;

	/**
	 * Construct
	 */
	public function __construct() {
		$this->textdomain();
		$this->define_constants();
		$this->load_classes();
		$this->install();

		$this->container = new Iconic_WLV_Core_Container();

		add_action( 'before_woocommerce_init', array( __CLASS__, 'declare_custom_order_tables_compatiblity' ) );
	}

	/**
	 * Instantiate a single instance of our plugin.
	 *
	 * @return Iconic_Woo_Linked_Variations
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get the DI container.
	 *
	 * @return ContainerInterface
	 */
	public function container() {
		return $this->container;
	}

	/**
	 * Load textdomain
	 */
	public function textdomain() {
		load_plugin_textdomain( 'iconic-wlv', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * Set constants
	 */
	public function define_constants() {
		$this->define( 'ICONIC_WLV_VERSION', '1.12.0' );
		$this->define( 'ICONIC_WLV_FILE', __FILE__ );
		$this->define( 'ICONIC_WLV_PATH', plugin_dir_path( __FILE__ ) );
		$this->define( 'ICONIC_WLV_URL', plugin_dir_url( __FILE__ ) );
		$this->define( 'ICONIC_WLV_INC_PATH', ICONIC_WLV_PATH . 'inc/' );
		$this->define( 'ICONIC_WLV_VENDOR_PATH', ICONIC_WLV_INC_PATH . 'vendor/' );
		$this->define( 'ICONIC_WLV_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'ICONIC_WLV_PLUGIN_PATH_FILE', str_replace( trailingslashit( wp_normalize_path( WP_PLUGIN_DIR ) ), '', wp_normalize_path( ICONIC_WLV_FILE ) ) );
	}

	/**
	 * Define constant if not already set.
	 *
	 * @param string      $name
	 * @param string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Load classes
	 */
	private function load_classes() {
		require_once ICONIC_WLV_PATH . 'vendor-prefixed/autoload.php';
		require_once( ICONIC_WLV_INC_PATH . 'class-core-autoloader.php' );

		Iconic_WLV_Core_Autoloader::run( array(
			'prefix'   => 'Iconic_WLV_',
			'inc_path' => ICONIC_WLV_INC_PATH,
		) );
		
		$this->init_license();
		$this->init_telemetry();

		Iconic_WLV_Core_Settings::run( array(
			'vendor_path'   => ICONIC_WLV_VENDOR_PATH,
			'title'         => 'WooCommerce Linked Variations',
			'version'       => self::$version,
			'menu_title'    => 'Linked Variations',
			'settings_path' => ICONIC_WLV_INC_PATH . 'admin/settings.php',
			'option_group'  => 'iconic_wlv',
			'docs'          => array(
				'collection'      => 'woocommerce-linked-variations/',
				'troubleshooting' => 'woocommerce-linked-variations/plugins-compatible-with-linked-variations/',
				'getting-started' => 'woocommerce-linked-variations/how-to-install-woocommerce-linked-variations/',
			),
			'cross_sells'   => array(
				'iconic-woothumbs',
				'iconic-woo-attribute-swatches',
			),
		) );

		Iconic_WLV_Settings::run();

		if ( ! Iconic_WLV_Core_Helpers::is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			return;
		}

		add_action( 'plugins_loaded', array( 'Iconic_WLV_Core_Onboard', 'run' ), 10 );

		Iconic_WLV_Assets::run();
		Iconic_WLV_Post_Types::run();
		Iconic_WLV_Product::run();
		Iconic_WLV_Api::run();
		Iconic_WLV_Compat_Import::run();
		Iconic_WLV_Compat_WPML::run();
		Iconic_WLV_Shortcodes::run();
		Iconic_WLV_Compat_Woo_Attribute_Swatches::run();
		Iconic_WLV_Compat_Weglot::run();

		add_action( 'admin_init', array( 'Iconic_WLV_Export', 'export' ) );
	}

	/**
	 * Init licence class.
	 */
	public function init_license() {
		// Allows us to transfer Freemius license.
		if ( file_exists( ICONIC_WLV_PATH . 'class-core-freemius-sdk.php' ) ) {
			require_once ICONIC_WLV_PATH . 'class-core-freemius-sdk.php';

			new Iconic_WLV_Core_Freemius_SDK(
				array(
					'plugin_path'          => ICONIC_WLV_PATH,
					'plugin_file'          => ICONIC_WLV_FILE,
					'uplink_plugin_slug'   => 'iconic-wlv',
					'freemius'             => array(
						'id'         => '1641',
						'slug'       => 'iconic-woo-linked-variations',
						'public_key' => 'pk_87add52278df025bc244015c9ef2a',
					),
				)
			);
		}

		Iconic_WLV_Core_License_Uplink::run(
			array(
				'basename'        => ICONIC_WLV_BASENAME,
				'plugin_slug'     => 'iconic-wlv',
				'plugin_name'     => self::$name,
				'plugin_version'  => self::$version,
				'plugin_path'     => ICONIC_WLV_PLUGIN_PATH_FILE,
				'plugin_class'    => 'Iconic_Woo_Linked_Variations',
				'option_group'    => 'iconic_wlv',
				'container_class' => self::class,
				'license_class' => Iconic_WLV_Core_Uplink_Helper::class,
				'urls'            => array(
					'product' => 'https://iconicwp.com/products/woocommerce-linked-variations/',
				),
			)
		);
	}

	/**
	 * Init telemetry class.
	 *
	 * @return void
	 */
	public function init_telemetry() {
		Iconic_WLV_Core_Telemetry::run(
			array(
				'file'                  => __FILE__,
				'plugin_slug'           => 'iconic-wlv',
				'option_group'          => 'iconic_wlv',
				'plugin_name'           => self::$name,
				'plugin_url'            => ICONIC_WLV_URL,
				'opt_out_settings_path' => 'sections/license/fields',
				'container_class'       => self::class,
			)
		);
	}

	/**
	 * Install plugin.
	 */
	private function install() {
		add_action( 'plugins_loaded', array( 'Iconic_WLV_Database', 'install' ) );
	}

	/**
	 * Returns an array of supported taxonomies.
	 */
	public static function get_supported_taxonomies() {
		$hidden_taxonomies = array(
			'product_visibility',
			'product_type',
			'product_shipping_class',
		);

		$taxonomies           = get_object_taxonomies( 'product' );
		$supported_taxonomies = array();

		foreach ( $taxonomies as $taxonomy ) {
			if ( in_array( $taxonomy, $hidden_taxonomies, true ) || 'pa_' === substr( $taxonomy, 0, 3 ) ) {
				continue;
			}

			$supported_taxonomies [] = $taxonomy;
		}

		/**
		 * Returning an array of supported taxonomies for the WooCommerce Linked Variations.
		 *
		 * @since 1.7.0
		 */
		$supported_taxonomies = apply_filters( 'iconic_wlv_supported_taxonomies', $supported_taxonomies );

		$tax_objects = array();
		foreach ( $supported_taxonomies as $taxonomy ) {
			$tax_objects [] = get_taxonomy( $taxonomy );
		}

		return $tax_objects;
	}

	/**
	 * Declare compatiblity with HPOS/Custom order tables feature of WooCommerce.
	 *
	 * @return void
	 */
	public static function declare_custom_order_tables_compatiblity() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}

	/**
	 * Get allowed post status for linked variations.
	 *
	 * @return array
	 */
	public static function get_allowed_post_status() {
		/**
		 * Allowed post statuses for the linked variation products.
		 *
		 * @since 1.7.0
		 */
		return apply_filters( 'iconic_wlv_allowed_post_status', array( 'publish' ) );
	}
}

$iconic_wlv = Iconic_Woo_Linked_Variations::instance();
