(function ($, document) {
  var iconic_wlv = {
    /**
     * Set up cache with common elements and vars.
     */
    cache() {
      iconic_wlv.els = [];
      iconic_wlv.els.tooltips = $('.woocommerce-help-tip');
      iconic_wlv.els.attributes = $('.iconic-wlv-attributes');
    },
    /**
     * Run on doc ready.
     */
    on_ready() {
      iconic_wlv.cache();
      iconic_wlv.setup_tooltips();
      iconic_wlv.setup_attributes();
      iconic_wlv.watch_link_by_selector();
      iconic_wlv.setup_select2();
    },
    /**
     * Setup tooltips.
     */
    setup_tooltips() {
      const tiptip_args = {
        attribute: 'data-tip',
        fadeIn: 50,
        fadeOut: 50,
        delay: 200
      };
      iconic_wlv.els.tooltips.tipTip(tiptip_args);
    },
    /**
     * Setup attributes.
     */
    setup_attributes() {
      iconic_wlv.els.attributes.sortable({
        handle: '.iconic-wlv-attributes__attribute-handle',
        items: '> .iconic-wlv-attributes__attribute'
      });
    },
    /**
     * Watch change in 'Link by' setting.
     */
    watch_link_by_selector() {
      $('#iconic-wlv-link-by').change(function () {
        $('.iconic-wlv-selector').addClass('wlv-form-field--hidden');
        $('.iconic-wlv-selector--' + $(this).val()).removeClass('wlv-form-field--hidden');
      });
      $('#iconic-wlv-link-by').trigger('change');
    },
    /**
     * Setup select2.
     */
    setup_select2() {
      jQuery('.iconic-wlv-select-taxonomy').select2();
    }
  };
  $(document).ready(iconic_wlv.on_ready);
})(jQuery, document);