<?php

// register TinyMCE buttons
add_filter( 'mce_buttons', 'hashbar_wpnbp_register_mce_buttons' );
function hashbar_wpnbp_register_mce_buttons( $buttons ) {
    $buttons[] = 'btn_trigger';
    return $buttons;
}

// add new buttons to tinymce
add_filter( 'mce_external_plugins', 'hashbar_wpnbp_register_mce_plugin' );
function hashbar_wpnbp_register_mce_plugin( $plugin_array ) {
   $plugin_array['btn_trigger'] = HASHBAR_WPNBP_URI.'/admin/js/shortcode.js';
   return $plugin_array;
}


add_shortcode( 'hashbar_btn', 'hashbar_wpnbp_btn_shortcode' );
function hashbar_wpnbp_btn_shortcode($atts){
    $atts = shortcode_atts( 
        array(
            'btn_text'  => 'DOWNLOAD NOW!',
            'btn_link'  => 'https://devitems.com/',
            'target'  => '',
            'add_nofollow'  => '',
            'btn_bg_color'  => '',
            'btn_text_color'  => '',
            'btn_style'  => 'style_2',
        ),
        $atts,
        $shortcode = 'hashbar_btn'
    );

    extract($atts);

    $css = '';
    $css .= $btn_bg_color ? 'background-color:'.$btn_bg_color.';' : '';
    $css .= $btn_text_color ? 'color:'.$btn_text_color.';' : '';

    $nofollow = $add_nofollow == 'yes' ? 'rel="nofollow"' : '';

    return '<a class="ht_btn '.$btn_style.'" href="'.$btn_link.'" target="'.$target.'" '. $nofollow .'  style="'.$css.'">'.$btn_text.'</a>';
}

add_shortcode( 'hashbar_socials', 'hashbar_wpnbp_social_bookmarks' );
function hashbar_wpnbp_social_bookmarks($atts){
    $atts = shortcode_atts(
        array(
            'target'  => '_blank',
            'facebook'  => '',
            'twitter'  => '',
            'google_plus'  => '',
            'instagram'  => '',
            'pinterest'  => '',
            'youtube'  => '',
            'vimeo'  => '',
        ),
        $atts,
        'hashbar_socials'
    );

    extract($atts);

    ob_start();
    ?>
    <span class="ht-notification-social">

        <?php if($facebook): ?>
        <a href="<?php echo esc_url($facebook); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-facebook"></i></a>
        <?php endif; ?>

        <?php if($twitter): ?>
        <a href="<?php echo esc_url($twitter); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-twitter"></i></a>
        <?php endif; ?>

        <?php if($google_plus): ?>
        <a href="<?php echo esc_url($google_plus); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-google-plus"></i></a>
        <?php endif; ?>

        <?php if($instagram): ?>
        <a href="<?php echo esc_url($instagram); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-instagram"></i></a>
        <?php endif; ?>

        <?php if($pinterest): ?>
        <a href="<?php echo esc_url($pinterest); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-pinterest"></i></a>
        <?php endif; ?>

        <?php if($youtube): ?>
        <a href="<?php echo esc_url($youtube); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-youtube"></i></a>
        <?php endif; ?>

        <?php if($vimeo): ?>
        <a href="<?php echo esc_url($vimeo); ?>" target="<?php echo esc_attr( $target ); ?>"><i class="zmdi zmdi-vimeo"></i></a>
        <?php endif; ?>
    </span>
    <?php

    return ob_get_clean();
}



// youtube shortcode
add_shortcode( 'hashbar_fb_likebox', 'hashbar_wpnbp_facebook_likebox' );
function hashbar_wpnbp_facebook_likebox($atts){
    $atts = shortcode_atts(
        array(
            'page_name' => 'devitems',
            'width' => 300,
            'height' => '',
        ),
        $atts,
        'hashbar_fb_likebox'
    );

    extract($atts);

    ob_start();
    ?>
    
    <span class="ht-fb-likebox">
        <div class="fb-page" data-href="https://www.facebook.com/<?php echo esc_attr( $page_name ); ?>" data-tabs="" data-width="<?php echo esc_attr( $width ); ?>" data-height="<?php echo esc_attr( $height ); ?>"></div>
    </span>
    <?php

    return ob_get_clean();
}

function hasbar_wpnbp_facebook_jssdk(){
    ?>
    <div id="fb-root"></div>
    <script>(function(d, s, id) {
      var js, fjs = d.getElementsByTagName(s)[0];
      if (d.getElementById(id)) return;
      js = d.createElement(s); js.id = id;
      js.src = 'https://connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v2.11';
      fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));
    </script>
    <?php
}
add_action( 'wp_head', 'hasbar_wpnbp_facebook_jssdk');