<?php
/**
 * Plugin Name: HashBar - WordPress Notification Bar Pro
 * Plugin URI: http://demo.wphash.com/hashbar/
 * Description: Notification Bar plugin for WordPress
 * Version: 1.1.0
 * Author: پرشین اسکریپت
 * Author URI: https://www.persianscript.ir
 * Text Domain: hashbar
*/


// define path
define( 'HASHBAR_WPNBP_URI', plugins_url('', __FILE__) );
define( 'HASHBAR_WPNBP_DIR', dirname( __FILE__ ) );

// include all files
include_once( HASHBAR_WPNBP_DIR. '/inc/custom-posts.php');
include_once( HASHBAR_WPNBP_DIR. '/inc/post-duplicator.php');
include_once( HASHBAR_WPNBP_DIR. '/inc/shortcode.php');
include_once( HASHBAR_WPNBP_DIR. '/admin/plugin-options.php');

if( !defined('CMB2_LOADED') ){
	include_once( HASHBAR_WPNBP_DIR. '/admin/cmb2/init.php');
}

include_once( HASHBAR_WPNBP_DIR. '/inc/metabox-multiple-select.php');


add_action( 'cmb2_admin_init', 'hashbar_wpnbp_add_metabox' );
function hashbar_wpnbp_add_metabox(){
    $post_type =  '';

    if(isset($_REQUEST['post_type'])){
    	$post_type =  $_REQUEST['post_type'];
    } elseif(isset($_REQUEST['post'])){
    	$post_id = $_REQUEST['post'];
    	$post_type = get_post_type($post_id);
    }

    if($post_type == 'wphash_ntf_bar'){
    	include_once( HASHBAR_WPNBP_DIR. '/inc/metabox.php');	
    }
}

// define text domain path
function hashbar_wpnbp_textdomain() {
    load_plugin_textdomain( 'hashbar', false, basename(HASHBAR_WPNBP_URI) . '/languages/' );
}
add_action( 'init', 'hashbar_wpnbp_textdomain' );

// enqueue scripts
add_action( 'wp_enqueue_scripts','hashbar_wpnbp_enqueue_scripts');
function  hashbar_wpnbp_enqueue_scripts(){
    // enqueue styles
    wp_enqueue_style( 'material-design-iconic-font', HASHBAR_WPNBP_URI.'/css/material-design-iconic-font.min.css');
    wp_enqueue_style( 'hashbar-notification-bar', HASHBAR_WPNBP_URI.'/css/notification-bar.css');

    // enqueue js
     wp_enqueue_script( 'js-cookie', HASHBAR_WPNBP_URI.'/js/js.cookie.min.js', '3.4.4', false);
     wp_enqueue_script( 'hashbar-main-js', HASHBAR_WPNBP_URI.'/js/main.js', array('jquery'), '', false);


     $options = get_option( 'hashbar_wpnbp_opt' );
     $checkbox_value = isset($options['dont_show_bar_after_close']) ? $options['dont_show_bar_after_close'] : '';
     $localized_vars = array(
        'dont_show_bar_after_close'     => $checkbox_value,
     );
     // hasbar localize
     wp_localize_script( "jquery", "hashbar_wpnbp_localize", $localized_vars );
}

add_action( 'wp_footer', 'hashbar_wpnbp_load_notification_to_footer' );
function hashbar_wpnbp_load_notification_to_footer(){

    $current_page_id = get_the_ID();

    $args = array('post_type' => 'wphash_ntf_bar', 'posts_per_page' => -1);

    $ntf_query = new WP_Query($args);

    while($ntf_query->have_posts()){
        $ntf_query->the_post();

        $post_id = get_the_id();

        // shedule notification meta
        $schedule = get_post_meta( $post_id, '_wphash_notification_schedule', true );
        $schedule_datetime = get_post_meta( $post_id, '_wphash_notification_schedule_datetime', true );

        if( $schedule == 'on' && current_time('timestamp') > $schedule_datetime){
            $draft_post = array();
            $draft_post['ID'] = $post_id;
            $draft_post['post_status'] = 'draft';

            // Update the post into the database
            wp_update_post( $draft_post );
        }


        $where_to_show = get_post_meta( $post_id , '_wphash_notification_where_to_show', true );


        if(is_single() && $where_to_show == 'post'){

            $ids_arr = get_post_meta( $post_id , '_wphash_notification_where_to_show_Post', true );
            if($ids_arr && in_array($current_page_id, $ids_arr)){
                hashbar_wpnbp_output($post_id);
            }
            
        } elseif(is_page() && $where_to_show == 'page'){

            $ids_arr = get_post_meta( $post_id , '_wphash_notification_where_to_show_Page', true );
            if($ids_arr && in_array($current_page_id, $ids_arr)){
                hashbar_wpnbp_output($post_id);
            }

        } elseif($where_to_show == 'product'){

            $ids_arr = get_post_meta( $post_id , '_wphash_notification_where_to_show_Product', true );
            if($ids_arr && in_array($current_page_id, $ids_arr)){
                hashbar_wpnbp_output($post_id);
            }

        } elseif ($where_to_show == 'homepage' && is_front_page()){

            hashbar_wpnbp_output($post_id);

        } elseif ($where_to_show == 'everywhere'){

            hashbar_wpnbp_output($post_id);
        }
    }
}

//notification bar output
function hashbar_wpnbp_output($post_id){

    $positon = get_post_meta( $post_id , '_wphash_notification_position', true );
    $positon = !empty($positon) ? $positon : 'ht-n-top';

    $transparent_selector = get_post_meta( $post_id , '_wphash_notification_transparent_selector', true );

    $width = get_post_meta( $post_id , '_wphash_notification_width', true );
    $height = get_post_meta( $post_id , '_wphash_notification_height', true );

    $on_desktop = get_post_meta( $post_id, '_wphash_notification_on_desktop', true );
    $on_mobile = get_post_meta( $post_id, '_wphash_notification_on_mobile', true );
    $display = get_post_meta( $post_id , '_wphash_notification_display', true );
    $display = !empty($display) ? $display : 'ht-n-open';

    $content_width = get_post_meta( $post_id, '_wphash_notification_content_width', true );

    $content_color = get_post_meta( $post_id, '_wphash_notification_content_text_color', true );
    $content_bg_color = get_post_meta( $post_id, '_wphash_notification_content_bg_color', true );
    $content_bg_image = get_post_meta( $post_id, '_wphash_notification_content_bg_image', true );
    $content_bg_opacity = get_post_meta( $post_id, '_wphash_notification_content_bg_opcacity', true );

    //button options
    $close_button = get_post_meta( $post_id, '_wphash_notification_close_button', true );
    $button_text = get_post_meta( $post_id, '_wphash_notification_close_button_text', true );
    $button_text = !empty($button_text) ? $button_text : '';

    $close_button_bg_color = get_post_meta( $post_id, '_wphash_notification_close_button_bg_color', true );
    $close_button_color = get_post_meta( $post_id, '_wphash_notification_close_button_color', true );
    $close_button_hover_color = get_post_meta( $post_id, '_wphash_notification_close_button_hover_color', true );
    $close_button_hover_bg_color = get_post_meta( $post_id, '_wphash_notification_close_button_hover_bg_color', true );

    $arrow_color = get_post_meta( $post_id, '_wphash_notification_arrow_color', true );
    $arrow_bg_color = get_post_meta( $post_id, '_wphash_notification_arrow_bg_color', true );
    $arrow_hover_color = get_post_meta( $post_id, '_wphash_notification_arrow_hover_color', true );
    $arrow_hover_bg_color = get_post_meta( $post_id, '_wphash_notification_arrow_hover_bg_color', true );

    $css_style = '';
    if(!empty($content_color)){
        $css_style .= "#notification-$post_id .ht-notification-text,#notification-$post_id .ht-notification-text p{color:$content_color}";
    }

    if(!empty($content_bg_color)){
        $css_style .= "#notification-$post_id::before{background-color:$content_bg_color}";
    }

    if(!empty($content_bg_image)){
        $css_style .= "#notification-$post_id::before{background-image:url($content_bg_image)}";
    }

    if(!empty($content_bg_opacity)){
        $css_style .= "#notification-$post_id::before{opacity:$content_bg_opacity}";
    }

    $css_style .= "#notification-$post_id{width:$width}";
    $css_style .= "#notification-$post_id.ht-n-open{height:{$height}px}";

    $css_style .= "#notification-$post_id .ht-n-close-toggle{background-color:$close_button_bg_color}";
    $css_style .= "#notification-$post_id .ht-n-close-toggle,#notification-$post_id .ht-n-close-toggle i{color:$close_button_color}";
    $css_style .= "#notification-$post_id .ht-n-close-toggle:hover{background-color:$close_button_hover_bg_color}";
    $css_style .= "#notification-$post_id .ht-n-close-toggle:hover{color:$close_button_hover_color}";
    $css_style .= "#notification-$post_id .ht-n-close-toggle:hover i{color:$close_button_hover_color}";

    $css_style .= "#notification-$post_id .ht-n-open-toggle{background-color:$arrow_bg_color}";
    $css_style .= "#notification-$post_id .ht-n-open-toggle{color:$arrow_color}";

    $css_style .= "#notification-$post_id .ht-n-open-toggle:hover i{color:$arrow_hover_color}";
    $css_style .= "#notification-$post_id .ht-n-open-toggle:hover{background-color:$arrow_hover_bg_color}";

    // transparent header
    if($transparent_selector && $height){
        if(is_user_logged_in()){
            $height = ($height + 32) .'px';
        } else {
            $height = $height. 'px';
        }
        $css_style .= "html body $transparent_selector{top:$height !important}";
        $css_style .= ".admin-bar $transparent_selector{top:$height !important}";
        $css_style .= "html body.ht-n-top-close $transparent_selector{top:0px !important}";
        $css_style .= "html body.ht-n-top-close #notification-$post_id{height:auto}";
        $css_style .= "html body.admin-bar.ht-n-top-close $transparent_selector{top:32px !important}";
    }

    // mobile device breakpoint
    $hashbar_wpnbp_opt = get_option( 'hashbar_wpnbp_opt');
    $mobile_device_width = isset($hashbar_wpnbp_opt['mobile_device_breakpoint']) ? $hashbar_wpnbp_opt['mobile_device_breakpoint'] : '';
    $mobile_device_width = empty($mobile_device_width) ? 768 : $mobile_device_width; 
    $desktop_device_width = $mobile_device_width + 1;

    $responsive_style = '';
    if($on_mobile == 'off'){
        $responsive_style = "@media (max-width: ".$mobile_device_width ."px){#notification-$post_id{display:none}}";
    }
    if($on_desktop == 'off'){
        $responsive_style = "@media (min-width: ". $desktop_device_width ."px){#notification-$post_id{display:none}}";
    }

    $dont_show_bar_after_close = isset($hashbar_wpnbp_opt['dont_show_bar_after_close']) ? $hashbar_wpnbp_opt['dont_show_bar_after_close'] : '';



    // get the number input of how many time this notifcation will show
    $count_input = get_post_meta($post_id, '_wphash_notification_how_many_times_to_show', true);
    $count_input = (int) $count_input;

    // dont show if dont_show_bar bar coockie value is 1
    if(
        ($dont_show_bar_after_close == '' || !(isset($_COOKIE['dont_show_bar']) && $_COOKIE['dont_show_bar'] == '1'))
    ):

    ?>

    <!--Notification Section-->
    <div id="notification-<?php echo esc_attr( $post_id ); ?>" class="ht-notification-section <?php echo esc_attr($content_width); ?> <?php echo esc_attr($positon); ?> <?php echo esc_attr($display); ?> on-desktop-<?php echo $on_desktop; ?>" <?php echo $count_input ? 'data-show="'. $count_input .'"' : '' ?> >

        <!--Notification Open Buttons-->
        <span class="ht-n-open-toggle"><i class="zmdi zmdi-long-arrow-down"></i></span>

        <div class="ht-notification-wrap">
            <div class="<?php echo $content_width == 'ht-n-full-width' ? esc_attr( 'ht-n-container_full_width' ) : esc_attr('ht-n-container'); ?>">

                <?php if($close_button != 'off' && $button_text && ($positon == 'ht-n-top' || $positon == 'ht-n-bottom')): ?>
                <!--Notification Buttons-->
                <div class="ht-notification-buttons">
                    <button class="ht-n-close-toggle" data-text="<?php echo esc_html( $button_text ); ?>"><i class="zmdi zmdi-close"></i><span class="close_text"><?php echo esc_html($button_text); ?></span></button>
                </div>
                <?php elseif($close_button != 'off'): ?>
                    <!--Notification Buttons-->
                    <div class="ht-notification-buttons">
                        <button  class="ht-n-close-toggle" data-text="<?php echo esc_html( $button_text ); ?>"><i class="zmdi zmdi-close"></i></button>
                    </div>
                <?php endif; ?>

                <!--Notification Text-->
                <div class="ht-notification-text">
                    <?php the_content(); ?>
                </div>


            </div>
        </div>

    </div>


    <style type="text/css">
        <?php echo esc_html($css_style.$responsive_style); ?>
    </style>

    <?php

    endif;
}


// page builder support for content editor
add_action( 'init', 'hashbar_wpnbp_page_builder_support' );
function hashbar_wpnbp_page_builder_support(){
    //king composer support
    global $kc;

    if($kc){
        $kc->add_content_type( 'wphash_ntf_bar' );
    }

    //vc support
    if( class_exists( 'VC_Manager' ) ){
		$default_post_types = vc_default_editor_post_types();

		if(!in_array('wphash_ntf_bar', $default_post_types)){
			$default_post_types[] = 'wphash_ntf_bar';
		}
	    
	    vc_set_default_editor_post_types( $default_post_types );
    }
}


//Hashbar Single Template
function hashbar_wpnbp_template( $single_template ) {
    global $post;
    if ( 'wphash_ntf_bar' == $post->post_type ) {
        $elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';
        if ( file_exists( $elementor_2_0_canvas ) ) {
            return $elementor_2_0_canvas;
        } else {
            return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
        }
    }
    return $single_template;
}
add_filter( 'single_template', 'hashbar_wpnbp_template' );