<?php

add_action('cmb2_meta_boxes','hashbar_wpnbp_meta_boxes');
if( ! function_exists('hashbar_wpnbp_meta_boxes') ){

	if(!function_exists('is_plugin_active')){
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	}

	function hashbar_wpnbp_meta_boxes(){

		$prefix = '_wphash_';

		// prepare where to show options array
		$where_to_show_options = array(
			'everywhere'    => esc_html__( 'Everywhere', 'hashbar' ),
			'homepage'      => esc_html__( 'Homepage Only', 'hashbar' ),
		);

		$custom_posts = array(
			'post'       	=> esc_html__( 'Post', 'hashbar' ),
			'page'       	=> esc_html__( 'Page', 'hashbar' ),
		);

		if(is_plugin_active( 'woocommerce/woocommerce.php' )){
			$custom_posts['product']	= esc_html__( 'Product', 'hashbar' );
		}

		$where_to_show_options = array_merge($where_to_show_options, $custom_posts);
		$where_to_show_options['none'] = esc_html__( 'Don\'t show', 'hashbar' );

		$meta_box = new_cmb2_box( array(
			'id'           		 => $prefix . 'notification_options',
			'title'        		 => esc_html__( 'Notification Bar Options', 'hashbar' ),
			'object_types' 		 => array('wphash_ntf_bar'),
			'context'      		 => 'normal',
			'priority'     		 => 'high',
			'show_names'         => true,
		) );

		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_where_to_show',
			'name'        		 => esc_html__( 'Choose option where to show', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => $where_to_show_options,
			'default'     		 => 'everywhere',
		) );

		$hashbar_wpnbp_opt = get_option( 'hashbar_wpnbp_opt');

		foreach($custom_posts as $item){

			if($item == 'Post'){
				$limit = isset($hashbar_wpnbp_opt['posts_limit']) ? $hashbar_wpnbp_opt['posts_limit'] : 10;
			} elseif($item == 'Page'){
				$limit = isset($hashbar_wpnbp_opt['pages_limit']) ? $hashbar_wpnbp_opt['pages_limit'] : 10;
			} else {
				$limit = 1;
			}

			$posts = get_posts( array('post_type' => $item, 'posts_per_page' => $limit ) );
 
			$post_list_arr = array();
			foreach($posts as $post){
				$post_list_arr[$post->ID] = $post->post_title;
			}

			$meta_box->add_field( array(
				'id'                 => $prefix.'notification_where_to_show_'.$item,
				'name'        		 => esc_html__( 'Choose where to show for '.$item, 'hashbar' ),
				'type'        		 => 'select_multiple',
				'options'     		 => $post_list_arr,
			) );
		}

		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_width',
			'name'        		 => esc_html__( 'Width', 'hashbar' ),
			'type'        		 => 'text',
			'description'		 => esc_html__('Input width of notification bar, ex: 300px')
		) );

		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_position',
			'name'        		 => esc_html__( 'Positioning', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'ht-n-left'    		=> esc_html__( 'Left', 'hashbar' ),
				'ht-n-top'       	=> esc_html__( 'Top', 'hashbar' ),
				'ht-n-right'       	=> esc_html__( 'Right', 'hashbar' ),
				'ht-n-bottom'       => esc_html__( 'Bottom', 'hashbar' ),
			),
			'default'     		 => 'ht-n-top',
			'desc' 				 => wp_kses( __( 'Left means the notification bar is always fixed at the left <br> Top means the notificatin bar is always fixed at the top of the page. <br> Right means the notification bar is always fixed at the right<br> Bottom means the notificatin bar is always visible at the bottom of the page', 'hashbar' ), array( 'br' => array() ) ),
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'themes_header_type',
			'name'        		 => esc_html__( 'Theme\'s Header Type', 'hashbar' ),
			'type'        		 => 'select',
			'options'        	 => array(
				'none'			=> 	__('Default', 'hashbar'),
				'transparent'	=> 	__('Transparent or sticky', 'hashbar'),
			),
			'description'		 => __('What kind of header you are using in your theme?<br> Select the header type.<br> If your header transparent or sticky, <br>then you must need input  height of the notification bar and css selector of your header.'),
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_transparent_selector',
			'name'        		 => esc_html__( 'Header Css Selector', 'hashbar' ),
			'type'        		 => 'text',
			'description'		 => esc_html__('Input the CSS selector of your transparent / sticky header. Ex: #header/.header')
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_height',
			'name'        		 => esc_html__( 'Notification Bar Height(px)', 'hashbar' ),
			'type'        		 => 'text',
			'description'		 => esc_html__('Input Height of notification bar, ex: 300. It must need if you theme\'s header type is transparent/sticky')
		) );


		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_display',
			'name'        		 => esc_html__( 'Display', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'ht-n-open'    		=> esc_html__( 'Open', 'hashbar' ),
				'ht-n-close'       	=> esc_html__( 'Close', 'hashbar' ),
			),
			'default'     		 => 'ht-n-open',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_on_desktop',
			'name'        		 => esc_html__( 'Enable / Disable On Desktop Device', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'on'    		=> esc_html__( 'Enable', 'hashbar' ),
				'off'       	=> esc_html__( 'Disable', 'hashbar' ),
			),
			'default'     		 => 'on',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_on_mobile',
			'name'        		 => esc_html__( 'Enable / Disable On Mobile Device', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'on'    		=> esc_html__( 'Enable', 'hashbar' ),
				'off'       	=> esc_html__( 'Disable', 'hashbar' ),
			),
			'default'     		 => 'on',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_schedule',
			'name'        		 => esc_html__( 'Enable / Disable Schedule Pause Time', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'on'    		=> esc_html__( 'Enable', 'hashbar' ),
				'off'       	=> esc_html__( 'Disable', 'hashbar' ),
			),
			'desc'        		 => 'This option useful, if you need to pause this notification at a specific date/time. </br> If you enable shceduling, the scheduled time must be greater than current time, otherwise this notifcation will be saved as draft. </br>Your current time is: '. current_time(get_option( 'date_format')) .' '. current_time('h : i A') . ' If you see it is not correct, set the correct timezone of your location from Settings > General > Timezone or  <a target="_blank" href="'.admin_url( 'options-general.php').'">click here</a>',
			'default'     		 => 'off',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_schedule_datetime',
			'name'        		 => esc_html__( 'Notification Paused Date/Time', 'hashbar' ),
			'type'        		 => 'text_datetime_timestamp',
			'desc'        		 => 'Set the date and time when this notification will be paused.',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_content_width',
			'name'        		 => esc_html__( 'Content Width', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'default-width'    	=> esc_html__( 'Default', 'hashbar' ),
				'ht-n-full-width'       	=> esc_html__( 'Full Width', 'hashbar' ),
			),
			'default'     		 => 'default-width',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_how_many_times_to_show',
			'name'        		 => esc_html__( 'How many time to show notification', 'hashbar' ),
			'type'        		 => 'text',
			'desc'		 	     => esc_html__( 'Input the number, how many time will apprear this notification. Number consider by each page load where the notification appear', 'hashbar' ),
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_content_bg_color',
			'name'        		 => esc_html__( 'Content Background color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_content_bg_image',
			'name'        		 => esc_html__( 'Content Background Image', 'hashbar' ),
			'type'        		 => 'file',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_content_text_color',
			'name'        		 => esc_html__( 'Content Text Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_content_bg_opcacity',
			'name'        		 => esc_html__( 'Opacity', 'hashbar' ),
			'type'        		 => 'text',
		) );

		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button',
			'name'        		 => esc_html__( 'Enable / Disable Close Button', 'hashbar' ),
			'type'        		 => 'radio_inline',
			'options'     		 => array(
				'on'    	=> esc_html__( 'Enable', 'hashbar' ),
				'off'   	=> esc_html__( 'Disable', 'hashbar' ),
			),
			'default'     		 => 'on',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button_text',
			'name'        		 => esc_html__( 'Close Button Text', 'hashbar' ),
			'type'        		 => 'text',
			'before_display'        	 => '<h3 style="border-bottom: 1px solid #e9e9e9;padding-bottom: 1em;">Close Button Options</h3>',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button_bg_color',
			'name'        		 => esc_html__( 'Close Button BG Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button_color',
			'name'        		 => esc_html__( 'Close Button Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button_hover_color',
			'name'        		 => esc_html__( 'Close Button Hover Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_close_button_hover_bg_color',
			'name'        		 => esc_html__( 'Close Button Hover BG Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_arrow_bg_color',
			'name'        		 => esc_html__( 'Arrow Bg Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_arrow_color',
			'name'        		 => esc_html__( 'Arrow Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_arrow_hover_color',
			'name'        		 => esc_html__( 'Arrow Hover Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
		$meta_box->add_field( array(
			'id'                 => $prefix.'notification_arrow_hover_bg_color',
			'name'        		 => esc_html__( 'Arrow Hover Bg Color', 'hashbar' ),
			'type'        		 => 'colorpicker',
		) );
	}
}


add_action( 'admin_footer', 'hashbar_wpnbp_cmb2_js' );
if(!function_exists('hashbar_wpnbp_cmb2_js')){
	function hashbar_wpnbp_cmb2_js(){
		?>
		
		<script>
		(function($){
				//conditional where to show field
				var $current_where_to_show = jQuery('.cmb2-id--wphash-notification-where-to-show li input[checked="checked"]').attr('value');

				var $relation_with_post = jQuery('.cmb2-id--wphash-notification-where-to-show-Post');
				var $relation_with_page = jQuery(' .cmb2-id--wphash-notification-where-to-show-Page');
				var $relation_with_product = jQuery('.cmb2-id--wphash-notification-where-to-show-Product');
				
				$relation_with_post.slideUp();
				$relation_with_page.slideUp();
				$relation_with_product.slideUp();
				

				if( $current_where_to_show == 'post'){
			    	$relation_with_post.slideDown();
			    } else if($current_where_to_show == 'page'){
			    	$relation_with_page.slideDown();
			    } else if($current_where_to_show == 'product'){
			    	$relation_with_product.slideDown();
			    }

				jQuery('.cmb2-id--wphash-notification-where-to-show li input').on('click', function() {
					$clicked_value = this.getAttribute('value');

				    if($clicked_value == 'post'){

				    	$relation_with_post.slideDown();
				    	$relation_with_page.slideUp();
				    	$relation_with_product.slideUp();

				    } else if($clicked_value == 'page'){

				    	$relation_with_post.slideUp();
				    	$relation_with_page.slideDown();
				    	$relation_with_product.slideUp();

				    } else if($clicked_value == 'product') {

				    	$relation_with_post.slideUp();
				    	$relation_with_page.slideUp();
				    	$relation_with_product.slideDown();

				    } else {

				    	$relation_with_post.slideUp();
				    	$relation_with_page.slideUp();
				    	$relation_with_product.slideUp();
				    	
				    }
				});

				//conditional content width
		    	var $current_position = jQuery('.cmb2-id--wphash-notification-position li input[checked="checked"]').attr('value');
		    	var $relation_with_1 = jQuery('.cmb2-id--wphash-notification-content-width');
		    	var $relation_with_2 = jQuery('.cmb2-id--wphash-notification-height,.cmb2-id--wphash-themes-header-type,cmb2-id--wphash-notification-transparent-selector');

		    	if( $current_position == 'ht-n-left' || $current_position == 'ht-n-right'){
		        	$relation_with_1.slideUp();
		        }

		        $relation_with_2.slideUp();
	        	if( $current_position == 'ht-n-top'){
	            	$relation_with_2.slideDown();
	            }

		        jQuery('.cmb2-id--wphash-notification-position li input').on('click', function() {
				    if(this.getAttribute('value') == 'ht-n-top' || this.getAttribute('value') == 'ht-n-bottom'){
				    	$relation_with_1.slideDown();
				    } else {
				    	$relation_with_1.slideUp();
				    }

				    if(this.getAttribute('value') == 'ht-n-top'){
				    	$relation_with_2.slideDown();
				    } else {
				    	$relation_with_2.slideUp();
				    }
		        });


		        // schedule relation
		        var $current_schedule_status = jQuery('.cmb2-id--wphash-notification-schedule li input[checked="checked"]').attr('value');
		        var $relation_with_datetime = jQuery('.cmb2-id--wphash-notification-schedule-datetime');

		        $relation_with_datetime.slideUp();
	        	if( $current_schedule_status == 'on'){
	            	$relation_with_datetime.slideDown();
	            }

                jQuery('.cmb2-id--wphash-notification-schedule li input').on('click', function() {
        		    if(this.getAttribute('value') == 'on'){
        		    	$relation_with_datetime.slideDown();
        		    } else {
        		    	$relation_with_datetime.slideUp();
        		    }
                });

	        })(jQuery);
		</script>

		<?php
	}
}