<?php
/*
Plugin Name: GutenCon
Plugin URI: www.persianscript.ir
Description: Marketing and SEO Booster for Gutenberg
Version: 1.0
Author: پرشین اسکریپت
Author URI: www.persianscript.ir
Text Domain: gutencon
Domain Path: /lang/
*/

namespace GutenCon;

if ( ! defined( 'ABSPATH' ) ) {
	wp_die();
}

define( 'GUTENCON_VERSION', '1.0' );
define( 'GUTENCON_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GUTENCON_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

final class Init {

    private static $instance = null;
    public static function instance(){
        if(is_null(static::$instance)) {
            static::$instance = new static();
        }
        return static::$instance;
    }

    //Declare list of our blocks and asset dependencies
    public $gutblockassets = [
        'box' => array(
            'frontcss' => array(
                'boxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/box/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'titlebox' => array(
            'frontcss' => array(
                'titleboxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/titlebox/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'promobox' => array(
            'frontcss' => array(
                'promoboxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/promobox/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'event' => array(
            'frontcss' => array(
                'eventfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/event/style.css',
                    'dependencies' => array(),
                ),
                'gclightboxfront' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/imagelightbox/imagelightbox.css',
                    'dependencies' => array(),
                ), 
            ),
            'frontjs' => array(
                'gclightboxjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/imagelightbox/imagelightbox.js',
                    'dependencies' => array(),
                )
            ),
            'editorjs' => array(),
        ),
        'offerbox' => array(
            'frontcss' => array(
                'offerboxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/offerbox/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'comparison-table' => array(
            'frontcss' => array(
                'comparisonfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/comparison/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(
                'gcequalizer' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/comparison/equalizer.js',
                    'dependencies' => array(),
                ),
            ),
            'editorjs' => array(),
        ),
        'comparison-item' => array(
            'frontcss' => array(),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'offerlisting' => array(
            'frontcss' => array(
                'offerlistingfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/offerlisting/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'offerlistingfull' => array(
            'frontcss' => array(
                'offerlistingfull' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/offerlistingfull/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'linelist' => array(
            'frontcss' => array(
                'linelistfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/linelist/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'toctop' => array(
            'frontcss' => array(
                'toctopfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/toctop/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(
                'gctoctopjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/toctop/scrolltolist.js',
                    'dependencies' => array(),
                ),
            ),
            'editorjs' => array(),
        ),
        'versus' => array(
            'frontcss' => array(
                'versusfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/versus/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'wclist' => array(
            'frontcss' => array(
                'offerlistingfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/offerlisting/style.css',
                    'dependencies' => array(),
                )
            ),
            'frontjs' => array(),
            'editorjs' => array(),
        ),
        'wcbox' => array(
            'frontcss' => array(
                'offerlistingfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/offerlisting/style.css',
                    'dependencies' => array(),
                ),
                'gctabsfront' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/tabs/tabs.css',
                    'dependencies' => array(),
                ),    
                'gclightboxfront' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/imagelightbox/imagelightbox.css',
                    'dependencies' => array(),
                ),             
            ),
            'frontjs' => array(
                'gctabsjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/tabs/tabs.js',
                    'dependencies' => array(),
                ),
                'gclightboxjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/imagelightbox/imagelightbox.js',
                    'dependencies' => array(),
                )
            ),
            'editorjs' => array(
                'gctabsjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/tabs/tabs.js',
                    'dependencies' => array(),
                )
            ),
        ),
        'accordion' => array(
            'frontcss' => array(
                'accordionfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/accordion/style.css',
                    'dependencies' => array(),
                ),           
            ),
            'frontjs' => array(
                'gcaccordionjs' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/accordion/accordion.js',
                    'dependencies' => array(),
                ),
            ),
        ),
        'reviewbox' => array(
            'frontcss' => array(
                'reviewboxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/reviewbox/style.css',
                    'dependencies' => array(),
                ),           
            )
        ),
        'numberheading' => array(
            'frontcss' => array(
                'numberheadingfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/numberheading/style.css',
                    'dependencies' => array(),
                ),           
            )
        ),
        'proscons' => array(
            'frontcss' => array(
                'prosboxfrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/proscons/style.css',
                    'dependencies' => array(),
                ),           
            )
        ),
        'howto' => array(
            'frontcss' => array(
                'howtofrontcss' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/howto/style.css',
                    'dependencies' => array(),
                ),           
            )
        ),
        'video' => array(
            'frontcss' => array(
                'gc-video' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/video/gc-video.css',
                    'dependencies' => array(),
                ),            
            ),
            'frontjs' => array(
                'gc-video' => array(
                    'link' => GUTENCON_PLUGIN_URL.'assets/video/gc-video.js',
                    'dependencies' => array(),
                ),
            ),
        ),
    ];

    private function __construct(){
        //Parser class
        require_once GUTENCON_PLUGIN_DIR .'class-rest.php';
        require_once GUTENCON_PLUGIN_DIR .'admin/class-admin.php';

        //Send users on first install to welcome page
        
        register_activation_hook(__FILE__, function () {
            add_option('gutencon_activation_redirects', true);
        });
        add_action('admin_init', function () {
            if (get_option('gutencon_activation_redirects', false)) {
                delete_option('gutencon_activation_redirects');
                exit( wp_redirect("admin.php?page=gutenconstart") );
            }
        });

        //Register Gutenberg categories
        add_filter('block_categories', array($this,'block_categories_filter'), 10, 2);

        //Register our blocks and classes
        foreach($this->gutblockassets as $gutname=>$gutvalue){
            if (file_exists(GUTENCON_PLUGIN_DIR .'blockrender/'.$gutname.'/block.php')){
                require_once GUTENCON_PLUGIN_DIR .'blockrender/'.$gutname.'/block.php';
            }
        }
        add_action('init', array( $this, 'init' )); // hook init our blocks
        add_action('enqueue_block_assets', array( $this, 'guten_assets' )); //hook add conditional frontend and backend assets
    
    
    }

    //Declare category of blocks
    function block_categories_filter($categories, $post){
        array_splice($categories, 3, 0, array(
            array(
                'slug'  => 'gutencon-modules',
                'title' => esc_html__('Gutencon modules', 'gutencon'),
            )
        ));
        return $categories;
    }

    // init our blocks
	public function init(){
        load_plugin_textdomain( 'gutencon', false, basename( __DIR__ ) . '/lang' ); //translation files

        // automatically load dependencies and version
        $asset_file = include( GUTENCON_PLUGIN_DIR. 'build/index.asset.php');

        //Common main script file for blocks for editor
        wp_register_script(
            'gutencon_common_js',
            GUTENCON_PLUGIN_URL. 'build/index.js',
            $asset_file['dependencies'],
            $asset_file['version']
        );

        //Translation in scripts
        if ( function_exists( 'wp_set_script_translations' ) ) {
            wp_set_script_translations( 'gutencon_common_js', 'gutencon' );
        }

        //Common Editor styles for blocks for editor
        wp_register_style(
            'gutencon_common_css',
            GUTENCON_PLUGIN_URL. 'build/index.css',
            array( 'wp-edit-blocks' ),
            $asset_file['version']
        );
        wp_style_add_data( 'gutencon_common_css', 'rtl', true );

        //Block registration and frontend conditional asset registration
        foreach($this->gutblockassets as $gutname=>$gutvalue){
            if(!empty($gutvalue['frontcss'])){
                foreach ($gutvalue['frontcss'] as $cssname=>$cssvalue){
                    wp_register_style(
                        $cssname,
                        $cssvalue['link'],
                        $cssvalue['dependencies'],
                        GUTENCON_VERSION
                    );
                }
            }
            if(!empty($gutvalue['frontjs'])){
                foreach ($gutvalue['frontjs'] as $jsname=>$jsvalue){
                    wp_register_script(
                        $jsname,
                        $jsvalue['link'],
                        $jsvalue['dependencies'],
                        GUTENCON_VERSION,
                        true
                    );
                }
            }
            if(!empty($gutvalue['editorjs'])){
                foreach ($gutvalue['editorjs'] as $jsname=>$jsvalue){
                    wp_register_script(
                        $jsname,
                        $jsvalue['link'],
                        $jsvalue['dependencies'],
                        GUTENCON_VERSION,
                        true
                    );
                }
            }
        }

        //Additional registration for complex blocks
		wp_register_style( 'simplelightbox',  GUTENCON_PLUGIN_URL.'assets/video/simpleLightbox.min.css', array(), GUTENCON_VERSION );
		wp_register_script( 'simplelightbox',  GUTENCON_PLUGIN_URL.'assets/video/simpleLightbox.min.js', array(), GUTENCON_VERSION, true );
		wp_register_style( 'swiper',  GUTENCON_PLUGIN_URL.'assets/comparison/swiper-bundle.min.css', array(), GUTENCON_VERSION );
		wp_register_script( 'swiper',  GUTENCON_PLUGIN_URL.'assets/comparison/swiper-bundle.min.js', array(), GUTENCON_VERSION, true );
        wp_register_script( 'gcextsource',  GUTENCON_PLUGIN_URL.'assets/formatsource/index.js', array(), GUTENCON_VERSION, true );
        wp_register_script( 'gctoggler',  GUTENCON_PLUGIN_URL.'assets/toggle/toggle.js', array(), GUTENCON_VERSION, true );

        add_action( 'wp_ajax_gccheck_youtube_url', array( $this, 'gccheck_youtube_url') );

	}

	public function gccheck_youtube_url(){
		$url = $_POST['url'];
		$max = wp_safe_remote_head($url);
		wp_send_json_success( wp_remote_retrieve_response_code($max) );
	}

    //Frontend and backend conditional asset enqueue
    public function guten_assets() {

        //root styles
        $options = get_option( 'gcsettings', array() );
        $btnbgcolor = (!empty($options['btnbgcolor'])) ? $options['btnbgcolor'] : '#de1414';
        $btncolor = (!empty($options['btncolor'])) ? $options['btncolor'] : '#ffffff';
        $gc_global_css = ':root{--gcbtnbg: '.$btnbgcolor.';--gcbtncolor: '.$btncolor.';}';

        wp_add_inline_style( 'wp-block-library', $gc_global_css );

        // conditional scripts
        if(!is_admin()){
            global $post;
            $wp_post = get_post( $post );
            if ( $wp_post ) {
                $content = $wp_post->post_content;
            }else{
                return false;
            }
            $blocks = parse_blocks( $content );
            if(false !== strpos( apply_filters('content', $content), 'gcext-source' )){
                
                wp_enqueue_script( 'gcextsource');
            }
            $this->check_block_array($blocks); //check blocks to inject conditional scripts     
        }
        else{
            foreach($this->gutblockassets as $gutname=>$gutvalue){
                if(!empty($gutvalue['editorjs'])){  
                    foreach ($gutvalue['editorjs'] as $jsname=>$jsvalue){
                        wp_enqueue_script($jsname);
                    }                      
                }
            }            
        }
    }

    public function check_block_array($blocks=array()){
        if ( empty( $blocks ) ) return;

        foreach ( $blocks as $block ) {

            foreach($this->gutblockassets as $gutname=>$gutvalue){
                if(!empty($gutvalue['frontcss']) || !empty($gutvalue['frontjs']) ){
                    if($block['blockName'] === 'gutencon/'.$gutname){
                        if(!empty($gutvalue['frontcss'])){
                            foreach ($gutvalue['frontcss'] as $cssname=>$cssvalue){
                                wp_enqueue_style($cssname);
                            }
                        }   
                        if(!empty($gutvalue['frontjs'])){
                            foreach ($gutvalue['frontjs'] as $jsname=>$jsvalue){
                                wp_enqueue_script($jsname);
                            }
                        }                      
                    }
                }
            }

			if( $block['blockName'] === 'gutencon/video' ){
				if( $block['attrs']['provider'] === "vimeo" ){
					wp_enqueue_script( 'vimeo-player', 'https://player.vimeo.com/api/player.js', array(), true, '1.0' );
				}
				
				if( isset($block['attrs']['overlayLightbox']) && $block['attrs']['overlayLightbox'] ){
					wp_enqueue_style( 'simplelightbox');
					wp_enqueue_script( 'simplelightbox' );
				}
				$width = isset($block['attrs']['width']) ? $block['attrs']['width'] : '';
				$height = isset($block['attrs']['height']) ? $block['attrs']['height'] : '';
				$block_style = "#gc-video-" . $block['attrs']['blockId']. "{";
					if(!empty($width) && $width['desktop']['size'] > 0){
						$block_style .= "width: " . $width['desktop']['size'] . $width['desktop']['unit'] .";";
					}
					if(!empty($height) && $height['desktop']['size'] > 0){
						$block_style .= "height: " . $height['desktop']['size'] . $height['desktop']['unit'] .";";
					}
				$block_style .= "} @media (min-width: 1024px) and (max-width: 1140px) {";
				$block_style .= "#gc-video-" . $block['attrs']['blockId']. "{";
					if(!empty($width) && $width['landscape']['size'] > 0){
						$block_style .= "width: " . $width['landscape']['size'] . $width['landscape']['unit'] .";";
					}
					if(!empty($height) && $height['landscape']['size'] > 0){
						$block_style .= "height: " . $height['landscape']['size'] . $height['landscape']['unit'] .";";
					}
				$block_style .= "}";
				$block_style .= "} @media (min-width: 768px) and (max-width: 1023px) {";
				$block_style .= "#gc-video-" . $block['attrs']['blockId']. "{";
					if(!empty($width) && $width['tablet']['size'] > 0){
						$block_style .= "width: " . $width['tablet']['size'] . $width['tablet']['unit'] .";";
					}
					if(!empty($height) && $height['tablet']['size'] > 0){
						$block_style .= "height: " . $height['tablet']['size'] . $height['tablet']['unit'] .";";
					}
				$block_style .= "}";
				$block_style .= "} @media (max-width: 767px) {";
				$block_style .= "#gc-video-" . $block['attrs']['blockId']. "{";
					if(!empty($width) && $width['mobile']['size'] > 0){
						$block_style .= "width: " . $width['mobile']['size'] . $width['mobile']['unit'] .";";
					}
					if(!empty($height) && $height['mobile']['size'] > 0){
						$block_style .= "height: " . $height['mobile']['size'] . $height['mobile']['unit'] .";";
					}
				$block_style .= "} }";
				wp_add_inline_style( 'gc-video', $block_style );
			}

			if ( $block['blockName'] === 'gutencon/comparison-table' ) {
				if(isset( $block['attrs']['responsiveView']) && $block['attrs']['responsiveView'] == 'slide'){
					wp_enqueue_style('swiper');
					wp_enqueue_script('swiper');
				}
			}

			if ( $block['blockName'] === 'gutencon/offerlistingfull' ) {
				if(!empty( $block['attrs']['enableexpand'])){
					wp_enqueue_script('gctoggler');
				}
			}

            //We check here reusable and inner blocks
            if ( $block['blockName'] === 'core/block' && ! empty( $block['attrs']['ref'] ) ) {
                $post_id = $block['attrs']['ref'];
                $content = get_post_field( 'post_content', $post_id );
                $blocks = parse_blocks( $content );
                $this->check_block_array($blocks);
            }
            if ( !empty($block['innerBlocks'])) {
                $blocks = $block['innerBlocks'];
                $this->check_block_array($blocks);
            }
        }


    }


}

function rhgutenconinit() {
	return Init::instance();
}

// Get the plugin running. Load on plugins_loaded action to avoid issue on multisite.
if ( function_exists( 'is_multisite' ) && is_multisite() ) {
	add_action( 'plugins_loaded', 'rhgutenconinit', 90 );
} else {
	rhgutenconinit();
}
