<?php

namespace Gutencon\Blocks;
defined('ABSPATH') OR exit;

class OfferListingFull{

	protected $name = 'offerlistingfull';

	final public static function instance(){
		static $instance = null;

		if(is_null($instance)) {
			$instance = new static();
		}

		return $instance;
	}

	protected function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type('gutencon/'.$this->name, array(
			'attributes'      => $this->attributes,
			'render_callback' => array( $this, 'render_block' ),
			'editor_script' => 'gutencon_common_js',
			'editor_style' => 'gutencon_common_css'
		));
	}

	protected $attributes = array(
		'titleTag'        => array(
			'type'    => 'string',
			'default' => 'h3',
		),
		'titleColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'btnColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'btntColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'priceColor'      => array(
			'type'    => 'string',
			'default' => '#de1513',
		),
		'readmorecolor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'highlightcolor'      => array(
			'type'    => 'string',
			'default' => '#334dfe',
		),
		'numbercolor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'numberbgcolor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'expandcolor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'expandbg'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'disclaimercolor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'disclaimerbg'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'expandlabel'      => array(
			'type'    => 'string',
			'default' => 'More info +',
		),
		'enableschema'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'enableexpand'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'enableScore'      => array(
			'type'    => 'boolean',
			'default' => true,
		),
		'enableNumber'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'enableScoreIcon'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'colorScore'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'pricecontent'      => array(
			'type'    => 'boolean',
			'default' => false,
		),
		'reviewcolor'      => array(
			'type'    => 'string',
			'default' => '#334dfe',
		),
		'offers' => array(
			'type'    => 'array',
			'default' => array(
				array(
					'score'          => '',
					'scoretext'          => '',
					'enableBadge'    => true,
					'highlight'    => false,
					'thumbnail'      => array(
						'url'    => '',
						'width'  => '',
						'height' => '',
						'alt'    => '',
					),
					'title'          => '',
					'copy'           => '',
					'expandcontent'  => '',
					'customBadge'    => array(
						'text'            => '',
						'textColor'       => '#fff',
						'backgroundColor' => '#334dfe'
					),
					'currentPrice'   => '',
					'oldPrice'       => '',
					'button'         => array(
						'text' => 'Buy Now',
						'url'  => ''
					),
					'couponCode'         => '',
					'expirationDate' => '',
					'offerExpired'   => false,
					'moretext' => '',
					'disclaimer'     => ''
				)
			),
		),
	);

	public function render_block($settings = array()){
		extract($settings);

		$html   = '';
		if ( empty( $offers ) || count( $offers ) === 0 ) {
			return;
		}
		$alignclass = (!empty($settings['align'])) ? ' align'.esc_attr($settings['align']).' ' : '';
		$schemarender = ($enableschema) ? ' itemtype="http://schema.org/ItemList" itemscope' : '';
		$schemaoffer = ($enableschema) ? ' itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"' : '';
		$schemaurl = ($enableschema) ? ' itemprop="url"' : '';
		$btnstyles = ($btnColor || $btntColor) ? 'style="background-color:' . esc_attr($btnColor) . '; color:' . esc_attr($btntColor) . ';"' : '';
		$titlestyles = ($titleColor) ? 'style="color:' . esc_attr($titleColor) . ';"' : '';
		$pricestyles = ($priceColor) ? 'style="color:' . esc_attr($priceColor) . ';"' : '';
		$scoreicon = ($enableScoreIcon) ? '<svg height="512" viewBox="0 0 512 512" width="512" xmlns="https://www.w3.org/2000/svg"><linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="256" x2="256" y1="512" y2="0"><stop offset="0" stop-color="#fd5900"/><stop offset="1" stop-color="#ffde00"/></linearGradient><linearGradient id="SVGID_2_" gradientUnits="userSpaceOnUse" x1="256" x2="256" y1="392.353" y2="91"><stop offset="0" stop-color="#ffe59a"/><stop offset="1" stop-color="#ffffd5"/></linearGradient><g id="Star"><g><g><circle cx="256" cy="256" fill="url(#SVGID_1_)" r="256"/></g></g><g><g><path d="m412.924 205.012c-1.765-5.43-6.458-9.388-12.108-10.209l-90.771-13.19-40.594-82.252c-2.527-5.12-7.742-8.361-13.451-8.361s-10.924 3.241-13.451 8.362l-40.594 82.252-90.771 13.19c-5.65.821-10.345 4.779-12.109 10.209s-.292 11.391 3.796 15.376l65.683 64.024-15.506 90.404c-.965 5.627 1.348 11.315 5.967 14.671 4.62 3.356 10.743 3.799 15.797 1.142l81.188-42.683 81.188 42.683c5.092 2.676 11.212 2.189 15.797-1.142 4.619-3.356 6.933-9.043 5.968-14.671l-15.506-90.404 65.682-64.024c4.088-3.986 5.559-9.947 3.795-15.377z" fill="url(#SVGID_2_)"/></g></g></g></svg>' : '';

		$html .= '<div class="gc-offer-listing'.$alignclass.'"'.$schemarender.'>';

		foreach ( $offers as $index=>$offer ) {
			$score             = !empty($offer['score']) ? $offer['score'] : '';
			$offer_url         = !empty($offer['button']['url']) ? $offer['button']['url'] : '';
			$offer_url 		   = apply_filters('gutencon_url_filter', $offer_url );
			$offer_url 		   = apply_filters('rh_post_offer_url_filter', $offer_url );
			$imageid             = !empty($offer['thumbnail']['id']) ? $offer['thumbnail']['id'] : '';
			$image_url         = !empty($offer['thumbnail']['url']) ? $offer['thumbnail']['url'] : '';
			$image_alt         = !empty($offer['thumbnail']['alt']) ? $offer['thumbnail']['alt'] : '';
			$image_width         = !empty($offer['thumbnail']['width']) ? $offer['thumbnail']['width'] : '';
			$image_height         = !empty($offer['thumbnail']['height']) ? $offer['thumbnail']['height'] : '';
			$title             = !empty($offer['title']) ? $offer['title'] : '';
			$copy              = !empty($offer['copy']) ? $offer['copy'] : '';
			$current_price     = !empty($offer['currentPrice']) ? $offer['currentPrice'] : '';
			$old_price         = !empty($offer['oldPrice']) ? $offer['oldPrice'] : '';
			$button_text       = !empty($offer['button']['text']) ? $offer['button']['text'] : esc_html__( 'Buy Now', 'gutencon' );
			$moretext      	   = !empty($offer['moretext']) ? $offer['moretext'] : '';
			$disclaimer        = !empty($offer['disclaimer']) ? $offer['disclaimer'] : '';
			$expandcontent        = !empty($offer['expandcontent']) ? $offer['expandcontent'] : '';
			$enable_badge      = !empty($offer['enableBadge']) ? $offer['enableBadge'] : '';
			$badge             = !empty($offer['customBadge']) ? $offer['customBadge'] : '';
			$badgebg	       = !empty($badge['backgroundColor']) ? $badge['backgroundColor'] : '';
			$badgetxcolor	   = !empty($badge['textColor']) ? $badge['textColor'] : '';
			$badge_styles      = 'background-color:' . $badgebg . '; color:' . $badgetxcolor . ';';
			$coupon_code      = !empty($offer['couponCode']) ? $offer['couponCode'] : '';
			$offer_coupon_date = !empty($offer['expirationDate']) ? $offer['expirationDate'] : '';
			$coupon_style      = '';
			$scoretext = !empty($offer['scoretext']) ? $offer['scoretext'] : esc_html__('EXCELLENT', 'gutencon');

			if ( empty( $image_url ) ) {
				$image_url = GUTENCON_PLUGIN_URL . '/assets/icons/noimage-placeholder.png';
			}
			$coupon_text = $coupon_style = $expired = '';
			if ( ! empty( $offer_coupon_date ) ) {
				$timestamp1 = strtotime( $offer_coupon_date ) + 86399;
				$seconds    = $timestamp1 - (int) current_time( 'timestamp', 0 );
				$days       = floor( $seconds / 86400 );
				$seconds    %= 86400;

				if ( $days > 0 ) {
					$coupon_text = $days.' '.esc_html__('days left', 'gutencon');
					$coupon_style = '';
					$expired      = 'no';
				} elseif ( $days == 0 ) {
					$coupon_text = esc_html__('Last day', 'gutencon');
					$coupon_style = '';
					$expired      = 'no';
				} else {
					$coupon_text  = esc_html__( 'Expired', 'gutencon' );
					$coupon_style = ' expired_coupon';
					$expired      = '1';
				}
			}
			$highlightstyle = (!empty($offer['highlight'])) ? ' style="box-shadow: inset 0 0 0 3px '.esc_attr($highlightcolor).';"' : '';

			$html .= '<div class="gc-expandable-wrapper gc-offer-listing-item"'.$schemaoffer.'>';
				$position = $index+1;
				if($enableschema){
					$html .= '<meta itemprop="position" content="'.$position.'" />';
				}
				$html .= '<div class="gc-offer-listing-item__wrapper'.$coupon_style.'"'.$highlightstyle.'>';
					$html .= '<div class="gc-offer-listing-image">';
						if ( $enable_badge && !empty($badge['text']) ) {
							$html .= '<span class="gc-list-badge" style="' . esc_attr( $badge_styles ) . '">';
							$html .= '	<span class="gc-list-badge-title">';
							$html .= '      <span>' . esc_html( $badge['text'] ) . '</span>';
							$html .= '	</span>';
							$html .= '  <span class="gc-list-badge-arrow" style="border-top-color:'.esc_attr($badgebg).'"></span>';
							$html .= '</span>';
						}
						if ( $enableNumber) {
							$html .= '<div class="gc-offer-listing-number" style="background-color:'.esc_attr($numberbgcolor).';color: '.$numbercolor.';">'.$position.'</div>';
						}
						$html .= '<figure>';
							if(!empty($imageid)){
								$html .= wp_get_attachment_image($imageid, 'full', false);
							}
							else if(!empty($image_url)){
								$html .= '<img src="'.esc_url($image_url).'" class="attachment-full size-full" alt="'.esc_attr($image_alt).'" loading="lazy" width="'.esc_attr($image_width).'" height="'.esc_attr($image_height).'">';
							}
						$html .= '</figure>';
					$html .= '</div>';
					$html .= '<div class="gc-offer-listing-contwrap">';
						$html .= '<div class="gc-offer-listing-content">';
							$html .= '<'.esc_attr($titleTag) . ' class="gc-offer-listing__title">';
								$html .= '<a href="' . esc_url( $offer_url ) . '" class="gc_track_btn re_track_btn" target="_blank" rel="nofollow sponsored" '.$titlestyles.'>';
									$html .= '' . esc_html( trim( $title ) ) . '';
								$html .= '</a>';
							$html .= '</' . esc_attr($titleTag) . '>';
							if ( $current_price && $pricecontent ) {
								$html .= '<div class="gc-offer-listing-price" style="margin-bottom:15px">';
									$html .= '<span class="rh_regular_price" '.$pricestyles.'>' . esc_html( trim( $current_price ) ) . '</span>';
									if ( $old_price && $old_price !== $current_price ) {
										$html .= '<del class="">' . esc_html( trim( $old_price ) ) . '</del>';
									}
								$html .= '	</div>';
							}
							$html .= '<div class="gc-offer-listing__copy">' .wp_kses_post( $copy ). '</div>';
							if($enableexpand && $expandcontent ){
								$html .='<span class="gc-listing-expand-label gc-expandable-trigger">'.esc_attr($expandlabel).'</span>';
							}
						$html .= '</div>';
						if ( $enableScore ) {
							$html .= '<div class="gc-offer-listing-score">';
								if(!$colorScore){
									$html .= '<div class="gc-lrating">';
										$html .= '<div class="gc-lrating-body">'.$scoreicon.'<span>'.esc_attr($offer['score']).'</span></div>';
										$html .= '<div class="gc-lrating-bottom"><span>'.esc_attr($scoretext).'</span></div>';
									$html .= '</div>';
								}
								if($colorScore){
									$html .= '<div class="gc-colorrating" style="background-color: '.esc_attr($reviewcolor).'">';
										$html .= ''.$scoreicon.'<span>'.esc_attr($offer['score']).'</span>';
									$html .= '</div>';
								}
							$html .= '</div>';
						}
					$html .= '</div>';
					$html .= '<div class="gc-offer-listing-cta">';
						if ( $current_price && !$pricecontent ) {
							$html .= '<div class="gc-offer-listing-price">';
								$html .= '<span class="rh_regular_price" '.$pricestyles.'>' . esc_html( trim( $current_price ) ) . '</span>';
								if ( $old_price && $old_price !== $current_price ) {
									$html .= '<del class="">' . esc_html( trim( $old_price ) ) . '</del>';
								}
							$html .= '	</div>';
						}
						if ( $offer_url ) {
							$html .= '<div class="priced_block priced_block--sm">';
								$html .= '<a href="' . esc_url( $offer_url ) . '" target="_blank" rel="nofollow sponsored" class="btn_offer_block gc_track_btn re_track_btn" '.$btnstyles.$schemaurl.'>';
									$html .= esc_attr($button_text);
								$html .= '</a>';
							$html .= '</div>';
						}
						if ($coupon_code){
							$html .= '<div class="gc_offer_coupon '.$coupon_style.'">
								<input class="coupon_text" readonly value="'.esc_attr($coupon_code).'" />
								<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 480 480"> <g> <g> <rect x="144" y="264" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="296" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="328" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="232" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="200" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="168" width="16" height="16"/> </g> </g> <g> <g> <rect x="144" y="136" width="16" height="16"/> </g> </g> <g> <g> <rect x="32" y="136" width="16" height="16"/> </g> </g> <g> <g> <rect x="432" y="136" width="16" height="16"/> </g> </g> <g> <g> <rect x="432" y="328" width="16" height="16"/> </g> </g> <g> <g> <rect x="32" y="328" width="16" height="16"/> </g> </g> <g> <g> <path d="M472,200c4.418,0,8-3.582,8-8v-80c0-4.418-3.582-8-8-8H8c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8 c22.091,0,40,17.909,40,40s-17.909,40-40,40c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8h464c4.418,0,8-3.582,8-8v-80 c0-4.418-3.582-8-8-8c-22.091,0-40-17.909-40-40S449.909,200,472,200z M416.524,247.956c3.532,24.61,22.867,43.944,47.476,47.476 V360H16v-64.568c30.614-4.394,51.87-32.773,47.476-63.388C59.944,207.435,40.61,188.1,16,184.568V120h448v64.568 C433.386,188.962,412.13,217.341,416.524,247.956z"/> </g> </g> <g> <g> <path d="M240,160c-17.673,0-32,14.327-32,32s14.327,32,32,32c17.673,0,32-14.327,32-32S257.673,160,240,160z M240,208 c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S248.837,208,240,208z"/> </g> </g> <g> <g> <path d="M336,256c-17.673,0-32,14.327-32,32c0,17.673,14.327,32,32,32c17.673,0,32-14.327,32-32C368,270.327,353.673,256,336,256z M336,304c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S344.837,304,336,304z"/> </g> </g> <g> <g> <rect x="197.494" y="231.982" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -85.3385 273.9377)" width="181.017" height="16"/> </g> </g> </svg>
							</div>';
							$html .= '<div class="time_offer">'.esc_attr($coupon_text).'</div>';
						}
						if ( $moretext ) {
							$html .= '<span class="gc-offer-listing__read-more">';
								$html .= wp_kses_post( $moretext );
							$html .= '</span>';
						}

					$html .= '</div>';
				$html .= '</div>';
				if ( $disclaimer ) {
					$html .= '<div class="gc-offer-listing-disclaimer" style="background-color:'.$disclaimerbg.';color:'.$disclaimercolor.';">';
					$html .= wp_kses_post( $disclaimer );
					$html .= '</div>';
				}
				if ( $enableexpand && $expandcontent  ) {
					$html .= '<div class="gc-listing-expand gc-expandable-content" style="background-color:'.esc_attr($expandbg).';color:'.esc_attr($expandcolor).';display:none">';
					$html .= wp_kses_post( $expandcontent  );
					$html .= '</div>';
				}	
			$html .= ' </div>';
		}
		$html .= '</div>';

		return $html;

	}
}

OfferListingFull::instance();