function gcInitTabs(elem){
    "use strict";
    //addEventListener on mouse click
    document.addEventListener('click', function (e) {
 
        //check is the right element clicked
        if (!e.target.matches(elem+' .t-btn')) return;
        else{
            if(!e.target.classList.contains('active')){
 
                //if option true remove active class from all other t-btn and t-panel 
                findActivetabElementAndRemoveIt(elem+' .t-btn');
                findActivetabElementAndRemoveIt(elem+' .t-panel');
 
                //add active class on clicked tab  
                e.target.classList.add('active');  
 
                //setTimeout(function(){   }, 200);              
                    var panel = document.querySelectorAll(elem+' .t-panel.'+e.target.dataset.name);
                    Array.prototype.forEach.call(panel, function (el) {
                        //add active class on right t-panel after 200ms because of the smooth animation  
                        el.classList.add('active');
                    });
                
            }
        }
    });
}
 
//if option true remove active class from added element
function findActivetabElementAndRemoveIt(elem){
    "use strict";
    var elementList = document.querySelectorAll(elem);
    Array.prototype.forEach.call(elementList, function (e) {
        e.classList.remove('active');
    });
}

gcInitTabs('.gcp-tabs');