<?php

//Plugin settings class and init
if ( !class_exists( 'RationalOptionPages' ) ) {
    require_once('RationalOptionPages.php');
}
$styleforsettings = '
    <style>
        .wrap{background:white;max-width: 900px;padding: 1.5em 3em;margin: 2.5em auto;border: 1px solid #dbdde2;box-shadow: 0 10px 20px #ececec;}
        .wrap .notice{display:none}
        .wrap h1{margin-bottom:40px}
        .wrap h2{padding: 15px;background: #f4f4f4;
    </style>
';
$pages = array(
    'gcsettings'	=> array(
        'page_title'	=> esc_html__( 'Gutencon', 'gutencon' ),
        'icon_url' => 'dashicons-superhero-alt',
        'sections'		=> array(
            'section-one'	=> array(
                'title'			=> esc_html__( 'Welcome to Gutencon', 'gutencon' ),
                'include'		=> GUTENCON_PLUGIN_DIR . 'admin/gutenconnew.php',
            ),
        ),
        'subpages'		=> array(
            'startgutencon'	=> array(
                'page_title'	=> esc_html__( 'Getting Started', 'gutencon' ),
                'menu_slug' => 'gutenconstart',
                'sections'		=> array(
                    'sectionstart'	=> array(
                        'title'			=> esc_html__( 'Welcome to Gutencon', 'gutencon' ),
                        'include'		=> GUTENCON_PLUGIN_DIR . 'admin/gutenconstart.php',
                    ),
                ),
            ),
            'bonusgutencon'	=> array(
                'page_title'	=> esc_html__( 'Bonus Plugins', 'gutencon' ),
                'menu_slug' => 'gutenconbonus',
                'sections'		=> array(
                    'sectionstart'	=> array(
                        'title'			=> esc_html__( 'Get Bonus plugins', 'gutencon' ),
                        'include'		=> GUTENCON_PLUGIN_DIR . 'admin/gutenconbonus.php',
                    ),
                ),
            ),
            'globalgutencon'	=> array(
                'page_title'	=> esc_html__( 'Global Options', 'gutencon' ),
                'menu_slug' => 'gutenconopt',
                'sections'		=> array(
                    'colors'	=> array(
                        'text'			=> $styleforsettings,
                        'title'			=> esc_html__( 'Color options', 'gutencon' ),
                        'fields'		=> array(
                            'btnbgcolor'			=> array(
                                'title'			=> esc_html__( 'Default Button Background Color', 'gutencon' ),
                                'type'			=> 'color',
                                'value'			=> '#de1414',
                            ),
                            'btncolor'			=> array(
                                'title'			=> esc_html__( 'Default Button Text Color', 'gutencon' ),
                                'type'			=> 'color',
                                'value'			=> '#ffffff',
                            ),
                        ),
                    ),
                ),
            ),
        ),

    ),
);
$option_page = new \RationalOptionPages( $pages );