<div id="gutenberg-settings" class="tab-pane">
  <div class="setting-panel">
    <h3>Gutenberg</h3>
    <p>Configure how Gutenberg and GutenBricks blocks should behave.</p>

    <table class="form-table" style="width: auto;">
      <tbody>
        <tr>
          <td style="min-width: 150px;vertical-align:top;">
            <label class="bundle-item">
              <b>Gutenberg Menu</b>
            </label>
          </td>
          <td style="min-width: 100px">
            <label class="bundle-item">
              <input type="checkbox" name="_gutenbricks_hide_pattern_tab" value="1" <?php checked(get_option('_gutenbricks_hide_pattern_tab'), "1"); ?> />
              Hide patterns tab
            </label>
            <label class="bundle-item">
              <input type="checkbox" name="_gutenbricks_hide_media_tab" value="1" <?php checked(get_option('_gutenbricks_hide_media_tab'), "1"); ?> />
              Hide media tab
            </label>
            <!--
              @since RC1.0 not available
              <label class="bundle-item">
                <input type="checkbox" name="_gutenbricks_hide_wp_patterns" value="1" <?php checked(get_option('_gutenbricks_hide_wp_patterns'), "1"); ?> />
                Hide default WordPress patterns from Gutenberg editor
              </label>
            -->
            <label class="bundle-item">
              <input type="checkbox" name="_gutenbricks_hide_other_blocks" value="1" <?php checked(get_option('_gutenbricks_hide_other_blocks'), "1"); ?> />
              Hide all the other blocks from Gutenberg editor except the active blocks generated by GutenBricks
            </label>
          </td>
        </tr>
      </tbody>
    </table>


    <table class="form-table" style="width: auto;">
      <tbody>
        <tr>
          <td style="min-width: 150px;vertical-align:top;">
            <label class="bundle-item">
              <b>Default Page Template </b>
              <span class="info-icon" title="Suggested by Jeff Young">C</span>
            </label>
          </td>
          <td style="min-width: 100px">
            <select name="_gutenbricks_default_page_template">
              <?php
              $templates = wp_get_theme()->get_page_templates();
              $selected_template = get_option('_gutenbricks_default_page_template');
              echo '<option value="">Default template</option>';
              foreach ($templates as $template_filename => $template_name) {
                echo '<option value="' . esc_attr($template_filename) . '" ' . selected($selected_template, $template_filename, false) . '>' . esc_html($template_name) . '</option>';
              }
              ?>
            </select>

            <p>This template will be used when user creates a new page.</p>
          </td>
        </tr>
      </tbody>
    </table>

    <div style="min-width: 100px; width: 100%; display: block;">
      <h3>Gutenberg Editor Custom CSS</h3>
      <p>Add custom CSS to the Gutenberg editor. CSS snippets are contributed by the community. If you have a
        snippet to share, please email us
        at <a href="mailto:support@gutenbricks.com">support@gutenbricks.com</a></p>
      <script>
        window._gutenbricksGutenbergCustomCss = <?php echo json_encode(get_option('_gutenbricks_gutenberg_custom_css')); ?>;
      </script>

      <div style="display: flex; height: 320px;">
        <div style="width: 15%; min-width: 200px; padding-right: 10px;">
          <div style="margin-bottom: 10px;">
            <b>Community Snippets</b>
          </div>
          <div id="gb-inject-css-list" style="height: 100%;"></div>
        </div>
        <div style="width: 85%; display: flex; flex-direction: column;">
          <div id="gb-css-editor" style="flex-grow: 1;"></div>
          <input type="hidden" id="gb-css-content" name="_gutenbricks_gutenberg_custom_css" />
        </div>
      </div>
    </div>
    <div style="min-width: 100px; width: 100%; display: block; margin-top: 20px;">
      <h3>Gutenberg Editor Footer HTML</h3>
      <p>You can add custom HTML to the footer of the Gutenberg editor. You can add scripts, styles, or any other HTML.</p>
      <script>
        window._gutenbricksGutenbergFooterHtml = <?php echo json_encode(get_option('_gutenbricks_gutenberg_footer_html')); ?>;
      </script>
      <div style="display: flex; height: 260px;">
        <textarea id="gb-footer-html-editor" style="flex-grow: 1; width: 100%; height: 100%;" 
          placeholder="<script>console.log('Hello World');</script>"
          name="_gutenbricks_gutenberg_footer_html"><?php echo esc_textarea(get_option('_gutenbricks_gutenberg_footer_html')); ?></textarea>
      </div>
    </div>
    <?php submit_button(); ?>
  </div>
</div>