<?php

namespace ThemeAtelier\GreetBubblePro\Frontend\Templates;

class ContactForm
{
    public static function contact_form($bubble_buttons)
    {
        if (!empty($bubble_buttons)) {
            foreach ($bubble_buttons as $key => $button) {
                $btn_ID = $key + 1;
                $button_behavior    = isset($button['button_behavior']) ? $button['button_behavior'] : '';

                $form_title          = isset($button['form_title']) ? $button['form_title'] : '';
                $form_type          = isset($button['form_type']) ? $button['form_type'] : '';
                $email_subject               = isset($button['email_subject']) ? $button['email_subject'] : '';
                $name               = isset($button['name']) ? $button['name'] : '';
                $email              = isset($button['email']) ? $button['email'] : '';
                $phone              = isset($button['phone']) ? $button['phone'] : '';
                $message            = isset($button['message']) ? $button['message'] : '';
                $web3form_button_text            = isset($button['web3form_button_text']) ? $button['web3form_button_text'] : '';
                $access_key         = isset($button['access_key']) ? $button['access_key'] : '';
                $external_form_shortcode            = isset($button['external_form_shortcode']) ? $button['external_form_shortcode'] : '';
                $whatsapp_number    = isset($button['whatsapp_number']) ? $button['whatsapp_number'] : '';
                $user_name   = isset($button['user_name']) ? $button['user_name'] : '';
                $whatsapp_message   = isset($button['whatsapp_message']) ? $button['whatsapp_message'] : '';
                $whatsapp_template = isset($button['greet_email_template']) ? $button['greet_email_template'] : '';
                $whatsapp_button_text = isset($button['whatsapp_button_text']) ? $button['whatsapp_button_text'] : '';
                $whatsapp_loading_text = isset($button['whatsapp_loading_text']) ? $button['whatsapp_loading_text'] : '';
                $web3form_loading_message = isset($button['web3form_loading_message']) ? $button['web3form_loading_message'] : '';
                $web3form_success_message = isset($button['web3form_success_message']) ? $button['web3form_success_message'] : '';
                $web3form_error_message = isset($button['web3form_error_message']) ? $button['web3form_error_message'] : '';

                switch ($button) {
                    case $button_behavior == 'contact_form':
                        switch ($form_type) {
                            case 'web3forms':
?>
                                <form class="greet_contact_form web3forms" data-button="<?php echo esc_attr($web3form_button_text) ?>" data-success="<?php echo esc_attr($web3form_success_message) ?>" data-loading="<?php echo esc_attr($web3form_loading_message) ?>" data-error="<?php echo esc_attr($web3form_error_message) ?>" data-id="<?php echo esc_attr($btn_ID); ?>" action="https://api.web3forms.com/submit" method="POST">
                                    <div class="greet_form_close">
                                        <i class="icofont-close-line"></i>
                                    </div>
                                    <?php
                                    if ($form_title) {
                                        echo '<h3>' . esc_html($form_title) . '</h3>';
                                    }
                                    ?>
                                    <input type="hidden" name="access_key" value="<?php echo esc_html($access_key); ?>" />
                                    <input type="hidden" name="subject" value="<?php echo esc_html($email_subject); ?>" />
                                    <input type="text" name="name" required placeholder="<?php echo esc_html($name); ?>" />
                                    <input type="email" name="email" required placeholder="<?php echo esc_html($email); ?>" />
                                    <input type="number" name="number" required placeholder="<?php echo esc_html($phone); ?>" />
                                    <textarea name="message" required placeholder="<?php echo esc_html($message); ?>"></textarea>
                                    <button class="greet_email_submit" type="submit"><?php echo esc_html($web3form_button_text) ?></button>
                                </form>
                            <?php
                                break;
                            case 'external_form_shortcode':
                                echo '<div class="greet_contact_form" data-id="' . esc_attr($btn_ID) . '">';
                                echo '<div class="greet_form_close">
                                                <i class="icofont-close-line"></i>
                                            </div>';
                                if ($form_title) {
                                    echo '<h3>' . esc_html($form_title) . '</h3>';
                                }
                              
                                echo do_shortcode($external_form_shortcode);
                                echo '</div>';
                                break;
                            case 'whatsapp_form':
                            ?>
                                <!-- <div class="whatsapp_form_wrapper"> -->
                                <form class="greet_contact_form greet_whatsapp_form" data-template="<?php echo esc_attr($whatsapp_template); ?>" data-number="<?php echo esc_attr($whatsapp_number); ?>" data-button="<?php echo esc_attr($whatsapp_button_text) ?>" data-loading="<?php echo esc_attr($whatsapp_loading_text) ?>" data-id="<?php echo esc_attr($btn_ID); ?>">
                                    <div class="greet_form_close">
                                        <i class="icofont-close-line"></i>
                                    </div>
                                    <?php
                                    if ($form_title) {
                                        echo '<h3>' . esc_html($form_title) . '</h3>';
                                    }
                                    ?>
                                    <input id="greet-name" name="greet-name" type="text" placeholder="<?php echo esc_attr($user_name) ?>" required>
                                    <textarea id="greet-message" name="greet-message" rows="5" placeholder="<?php echo esc_html($whatsapp_message) ?>" spellcheck="false" required></textarea>
                                    <?php wp_nonce_field('greet_nonce', 'greet_nonce') ?>
                                    <button class="greet_email_submit" id="submit" type="submit"><?php echo esc_html($whatsapp_button_text) ?></button>
                                </form>
                                <!-- </div> -->
<?php
                                break;
                        }
                        break;
                }
            }
        }
    }
}
