<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin/Views/GreetBubbleOptions
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin\Views;

use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleGeneral;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleAppearance;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleControls;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleTypography;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleAdvanced;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleBackup;
use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

class GreetBubbleOptions
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        GREET_BUBBLE_PRO::createOptions($prefix, array(
            'menu_title'        => esc_html__('Greet Bubble', 'greet-bubble-pro'),
            'menu_icon'         => 'dashicons-format-video',
            'framework_title'   => esc_html__('Greet Bubble', 'greet-bubble-pro'),
            'footer_text'       => __('If you love the plugin don\'t forgot to give us a rating form your <a target="_blank" href="https://codecanyon.net/downloads">download page</a>.', 'greet-bubble-pro'),
            'menu_slug'         => 'greet-bubble-pro',
            'menu_type'         => 'submenu',
            'theme'             => 'light',
            'ajax_save'         => true,
            'show_reset_all'    => false,
            'show_search'       => false,
            'show_footer'       => false,
            'show_all_options'  => false,
            'show_sub_menu'     => false,
            'show_bar_menu'     => false,
            'nav'               => 'inline',
            'menu_position'     => 58,
        ));

        GreetBubbleGeneral::options($prefix);
        GreetBubbleAppearance::options($prefix);
        GreetBubbleControls::options($prefix);
        GreetBubbleTypography::options($prefix);
        GreetBubbleAdvanced::options($prefix);
        GreetBubbleBackup::options($prefix);
    }
}
