<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.
/**
 *
 * Field: background
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
use ThemeAtelier\GreetBubblePro\Admin\Framework\Classes\GREET_BUBBLE_PRO;

if ( ! class_exists( 'GREET_BUBBLE_PRO_Field_background' ) ) {
  class GREET_BUBBLE_PRO_Field_background extends GREET_BUBBLE_PRO_Fields {

    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
      parent::__construct( $field, $value, $unique, $where, $parent );
    }

    public function render() {

      $args                             = wp_parse_args( $this->field, array(
        'background_color'              => true,
        'background_image'              => true,
        'background_position'           => true,
        'background_repeat'             => true,
        'background_attachment'         => true,
        'background_size'               => true,
        'background_origin'             => false,
        'background_clip'               => false,
        'background_blend_mode'         => false,
        'background_gradient'           => false,
        'background_gradient_color'     => true,
        'background_gradient_direction' => true,
        'background_image_preview'      => true,
        'background_auto_attributes'    => false,
        'compact'                       => false,
        'background_image_library'      => 'image',
        'background_image_placeholder'  => esc_html__( 'Not selected', 'greet-bubble-pro' ),
      ) );

      if ( $args['compact'] ) {
        $args['background_color']           = false;
        $args['background_auto_attributes'] = true;
      }

      $default_value                    = array(
        'background-color'              => '',
        'background-image'              => '',
        'background-position'           => '',
        'background-repeat'             => '',
        'background-attachment'         => '',
        'background-size'               => '',
        'background-origin'             => '',
        'background-clip'               => '',
        'background-blend-mode'         => '',
        'background-gradient-color'     => '',
        'background-gradient-direction' => '',
      );

      $default_value = ( ! empty( $this->field['default'] ) ) ? wp_parse_args( $this->field['default'], $default_value ) : $default_value;

      $this->value = wp_parse_args( $this->value, $default_value );

      echo wp_kses_post($this->field_before());

      echo '<div class="greet-bubble-pro--background-colors">';

      //
      // Background Color
      if ( ! empty( $args['background_color'] ) ) {

        echo '<div class="greet-bubble-pro--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="greet-bubble-pro--title">'. esc_html__( 'From', 'greet-bubble-pro' ) .'</div>' : '';

        GREET_BUBBLE_PRO::field( array(
          'id'      => 'background-color',
          'type'    => 'color',
          'default' => $default_value['background-color'],
        ), $this->value['background-color'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      //
      // Background Gradient Color
      if ( ! empty( $args['background_gradient_color'] ) && ! empty( $args['background_gradient'] ) ) {

        echo '<div class="greet-bubble-pro--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="greet-bubble-pro--title">'. esc_html__( 'To', 'greet-bubble-pro' ) .'</div>' : '';

        GREET_BUBBLE_PRO::field( array(
          'id'      => 'background-gradient-color',
          'type'    => 'color',
          'default' => $default_value['background-gradient-color'],
        ), $this->value['background-gradient-color'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      //
      // Background Gradient Direction
      if ( ! empty( $args['background_gradient_direction'] ) && ! empty( $args['background_gradient'] ) ) {

        echo '<div class="greet-bubble-pro--color">';

        echo ( ! empty( $args['background_gradient'] ) ) ? '<div class="greet-bubble-pro---title">'. esc_html__( 'Direction', 'greet-bubble-pro' ) .'</div>' : '';

        GREET_BUBBLE_PRO::field( array(
          'id'          => 'background-gradient-direction',
          'type'        => 'select',
          'options'     => array(
            ''          => esc_html__( 'Gradient Direction', 'greet-bubble-pro' ),
            'to bottom' => esc_html__( '&#8659; top to bottom', 'greet-bubble-pro' ),
            'to right'  => esc_html__( '&#8658; left to right', 'greet-bubble-pro' ),
            '135deg'    => esc_html__( '&#8664; corner top to right', 'greet-bubble-pro' ),
            '-135deg'   => esc_html__( '&#8665; corner top to left', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-gradient-direction'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      echo '</div>';

      //
      // Background Image
      if ( ! empty( $args['background_image'] ) ) {

        echo '<div class="greet-bubble-pro--background-image">';

        GREET_BUBBLE_PRO::field( array(
          'id'          => 'background-image',
          'type'        => 'media',
          'class'       => 'greet-bubble-pro-assign-field-background',
          'library'     => $args['background_image_library'],
          'preview'     => $args['background_image_preview'],
          'placeholder' => $args['background_image_placeholder'],
          'attributes'  => array( 'data-depend-id' => $this->field['id'] ),
        ), $this->value['background-image'], $this->field_name(), 'field/background' );

        echo '</div>';

      }

      $auto_class   = ( ! empty( $args['background_auto_attributes'] ) ) ? ' greet-bubble-pro--auto-attributes' : '';
      $hidden_class = ( ! empty( $args['background_auto_attributes'] ) && empty( $this->value['background-image']['url'] ) ) ? ' greet-bubble-pro--attributes-hidden' : '';

      echo '<div class="greet-bubble-pro--background-attributes'. esc_attr( $auto_class . $hidden_class ) .'">';

      //
      // Background Position
      if ( ! empty( $args['background_position'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'              => 'background-position',
          'type'            => 'select',
          'options'         => array(
            ''              => esc_html__( 'Background Position', 'greet-bubble-pro' ),
            'left top'      => esc_html__( 'Left Top', 'greet-bubble-pro' ),
            'left center'   => esc_html__( 'Left Center', 'greet-bubble-pro' ),
            'left bottom'   => esc_html__( 'Left Bottom', 'greet-bubble-pro' ),
            'center top'    => esc_html__( 'Center Top', 'greet-bubble-pro' ),
            'center center' => esc_html__( 'Center Center', 'greet-bubble-pro' ),
            'center bottom' => esc_html__( 'Center Bottom', 'greet-bubble-pro' ),
            'right top'     => esc_html__( 'Right Top', 'greet-bubble-pro' ),
            'right center'  => esc_html__( 'Right Center', 'greet-bubble-pro' ),
            'right bottom'  => esc_html__( 'Right Bottom', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-position'], $this->field_name(), 'field/background' );

      }

      //
      // Background Repeat
      if ( ! empty( $args['background_repeat'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'          => 'background-repeat',
          'type'        => 'select',
          'options'     => array(
            ''          => esc_html__( 'Background Repeat', 'greet-bubble-pro' ),
            'repeat'    => esc_html__( 'Repeat', 'greet-bubble-pro' ),
            'no-repeat' => esc_html__( 'No Repeat', 'greet-bubble-pro' ),
            'repeat-x'  => esc_html__( 'Repeat Horizontally', 'greet-bubble-pro' ),
            'repeat-y'  => esc_html__( 'Repeat Vertically', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-repeat'], $this->field_name(), 'field/background' );

      }

      //
      // Background Attachment
      if ( ! empty( $args['background_attachment'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'       => 'background-attachment',
          'type'     => 'select',
          'options'  => array(
            ''       => esc_html__( 'Background Attachment', 'greet-bubble-pro' ),
            'scroll' => esc_html__( 'Scroll', 'greet-bubble-pro' ),
            'fixed'  => esc_html__( 'Fixed', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-attachment'], $this->field_name(), 'field/background' );

      }

      //
      // Background Size
      if ( ! empty( $args['background_size'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'        => 'background-size',
          'type'      => 'select',
          'options'   => array(
            ''        => esc_html__( 'Background Size', 'greet-bubble-pro' ),
            'cover'   => esc_html__( 'Cover', 'greet-bubble-pro' ),
            'contain' => esc_html__( 'Contain', 'greet-bubble-pro' ),
            'auto'    => esc_html__( 'Auto', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-size'], $this->field_name(), 'field/background' );

      }

      //
      // Background Origin
      if ( ! empty( $args['background_origin'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'            => 'background-origin',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Origin', 'greet-bubble-pro' ),
            'padding-box' => esc_html__( 'Padding Box', 'greet-bubble-pro' ),
            'border-box'  => esc_html__( 'Border Box', 'greet-bubble-pro' ),
            'content-box' => esc_html__( 'Content Box', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-origin'], $this->field_name(), 'field/background' );

      }

      //
      // Background Clip
      if ( ! empty( $args['background_clip'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'            => 'background-clip',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Clip', 'greet-bubble-pro' ),
            'border-box'  => esc_html__( 'Border Box', 'greet-bubble-pro' ),
            'padding-box' => esc_html__( 'Padding Box', 'greet-bubble-pro' ),
            'content-box' => esc_html__( 'Content Box', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-clip'], $this->field_name(), 'field/background' );

      }

      //
      // Background Blend Mode
      if ( ! empty( $args['background_blend_mode'] ) ) {

        GREET_BUBBLE_PRO::field( array(
          'id'            => 'background-blend-mode',
          'type'          => 'select',
          'options'       => array(
            ''            => esc_html__( 'Background Blend Mode', 'greet-bubble-pro' ),
            'normal'      => esc_html__( 'Normal', 'greet-bubble-pro' ),
            'multiply'    => esc_html__( 'Multiply', 'greet-bubble-pro' ),
            'screen'      => esc_html__( 'Screen', 'greet-bubble-pro' ),
            'overlay'     => esc_html__( 'Overlay', 'greet-bubble-pro' ),
            'darken'      => esc_html__( 'Darken', 'greet-bubble-pro' ),
            'lighten'     => esc_html__( 'Lighten', 'greet-bubble-pro' ),
            'color-dodge' => esc_html__( 'Color Dodge', 'greet-bubble-pro' ),
            'saturation'  => esc_html__( 'Saturation', 'greet-bubble-pro' ),
            'color'       => esc_html__( 'Color', 'greet-bubble-pro' ),
            'luminosity'  => esc_html__( 'Luminosity', 'greet-bubble-pro' ),
          ),
        ), $this->value['background-blend-mode'], $this->field_name(), 'field/background' );

      }

      echo '</div>';

      echo wp_kses_post($this->field_after());

    }

    public function output() {

      $output    = '';
      $bg_image  = array();
      $important = ( ! empty( $this->field['output_important'] ) ) ? '!important' : '';
      $element   = ( is_array( $this->field['output'] ) ) ? join( ',', $this->field['output'] ) : $this->field['output'];

      // Background image and gradient
      $background_color        = ( ! empty( $this->value['background-color']              ) ) ? $this->value['background-color']              : '';
      $background_gd_color     = ( ! empty( $this->value['background-gradient-color']     ) ) ? $this->value['background-gradient-color']     : '';
      $background_gd_direction = ( ! empty( $this->value['background-gradient-direction'] ) ) ? $this->value['background-gradient-direction'] : '';
      $background_image        = ( ! empty( $this->value['background-image']['url']       ) ) ? $this->value['background-image']['url']       : '';


      if ( $background_color && $background_gd_color ) {
        $gd_direction   = ( $background_gd_direction ) ? $background_gd_direction .',' : '';
        $bg_image[] = 'linear-gradient('. $gd_direction . $background_color .','. $background_gd_color .')';
        unset( $this->value['background-color'] );
      }

      if ( $background_image ) {
        $bg_image[] = 'url('. $background_image .')';
      }

      if ( ! empty( $bg_image ) ) {
        $output .= 'background-image:'. implode( ',', $bg_image ) . $important .';';
      }

      // Common background properties
      $properties = array( 'color', 'position', 'repeat', 'attachment', 'size', 'origin', 'clip', 'blend-mode' );

      foreach ( $properties as $property ) {
        $property = 'background-'. $property;
        if ( ! empty( $this->value[$property] ) ) {
          $output .= $property .':'. $this->value[$property] . $important .';';
        }
      }

      if ( $output ) {
        $output = $element .'{'. $output .'}';
      }

      $this->parent->output_css .= $output;

      return $output;

    }

  }
}
