<?php

/**
 * The admin-facing functionality of the plugin.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package greet-bubble-pro
 * @subpackage greet-bubble-pro/Admin
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\GreetBubblePro\Admin;

use ThemeAtelier\GreetBubblePro\Admin\DBUpdates;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleMetaboxOptions;
use ThemeAtelier\GreetBubblePro\Admin\Views\GreetBubbleOptions;

/**
 * The admin class
 */
class Admin
{
    /**
     * The slug of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_slug   The slug of this plugin.
     */
    private $plugin_slug;

    /**
     * The min of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $min   The slug of this plugin.
     */
    private $min;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * The class constructor.
     *
     * @param string $plugin_slug The slug of the plugin.
     * @param string $version Current version of the plugin.
     */
    function __construct($plugin_slug, $version)
    {
        $this->plugin_slug = $plugin_slug;
        $this->version     = $version;
        $this->min         = defined('WP_DEBUG') && WP_DEBUG ? '' : '.min';
        GreetBubbleMetaboxOptions::section('_greet_meta');
        GreetBubbleOptions::options('_greet');
        // Database Updater.
        new DBUpdates();
        // Admin Menu
        add_action('admin_menu', array($this, 'add_plugin_page'));
    }

    public function enqueue_scripts() {}
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_menu_page(
            esc_html__('Greet Bubble', 'greet-bubble-pro'),
            esc_html__('Greet Bubble', 'greet-bubble-pro'),
            'manage_options',
            'greet-bubble-pro',
            array($this, 'greet_bubble_pro_settings'),
            'dashicons-format-video',
            30
        );
    }

    /**
     * Options page callback
     */
    public function greet_bubble_pro_settings() {}
}
