<?php
/*
Plugin Name:  Greet Bubble Pro
Plugin URI:   https://themeatelier.net/plugins/greet/
Description:  Professional video bubble plugin for putting videos on your website in a great and fun way.
Version:      2.2.9
Author:       ThemeAtelier
Author URI:   https://themeatelier.net/
License:      GPL-2.0+
License URI:  https://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  greet-bubble-pro
Domain Path:  /languages
*/

// Block Direct access
if (!defined('ABSPATH')) {
    die('You should not access this file directly!.');
}
require_once __DIR__ . '/vendor/autoload.php';

use ThemeAtelier\GreetBubblePro\GreetBubblePro;

define('GREET_BUBBLE_PRO_VERSION', '2.2.9');
define('GREET_BUBBLE_PRO_FILE', __FILE__);
define('GREET_BUBBLE_PRO_ALERT_MSG', esc_html__('You should not access this file directly.!', 'greet-bubble-pro'));
define('GREET_BUBBLE_PRO_DIRNAME', dirname(__FILE__));
define('GREET_BUBBLE_PRO_DIR_PATH', plugin_dir_path(__FILE__));
define('GREET_BUBBLE_PRO_DIR_URL', plugin_dir_url(__FILE__));
define('GREET_BUBBLE_PRO_BASENAME', plugin_basename(__FILE__));

function greet_bubble_pro()
{
    // Launch the plugin.
    $greet_bubble_pro = new GreetBubblePro();
    $greet_bubble_pro->run();
}

// kick-off the plugin
greet_bubble_pro();

function greet_bubble_pro_deactivate_free_version()
{
    // Define the plugin slug for the free version
    $free_plugin_slug = 'greet-bubble/greet-bubble.php';

    // Check if the free version is active
    if (is_plugin_active($free_plugin_slug)) {
        // Deactivate the free version
        deactivate_plugins($free_plugin_slug);

        // Notify the user
        add_action('admin_notices', function () {
?>
            <div class="notice notice-warning is-dismissible">
                <p><?php _e('The free version of "Greet Bubble" has been deactivated because the pro version is active.', 'greet-bubble-pro'); ?></p>
            </div>
<?php
        });
    }
}
add_action('admin_init', 'greet_bubble_pro_deactivate_free_version');

/**
 * Initialize the plugin tracker
 *
 * @return void
 */
function greet_pro_video_bubble_appsero_init()
{
    if (!class_exists('GreetBubbleProAppSero\Insights')) {
        require_once GREET_BUBBLE_PRO_DIR_PATH . 'src/Admin/appsero/Client.php';
    }
    $client = new GreetBubbleProAppSero\Client('c8924b73-4515-4b41-9954-25487ecf76a9', 'Greet Bubble Pro - Video Bubble Warm Welcome Plugin', __FILE__);
    // Active insights
    $client->insights()->init();
}
greet_pro_video_bubble_appsero_init();
