<?php
// File: /Applications/MAMP/htdocs/wordpress/wp-content/plugins/gpt3-ai-content-generator/classes/core/moderation/AIPKit_BannedWords_Checker.php
// Status: NEW FILE

namespace WPAICG\Core\Moderation;

use WP_Error;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * AIPKit_BannedWords_Checker
 *
 * Checks if the provided text contains any banned words.
 */
class AIPKit_BannedWords_Checker {

    /**
     * Checks text for banned words.
     *
     * @param string $text The text content to check.
     * @param array $banned_words_settings Associative array with 'words' (string) and 'message' (string).
     * @return WP_Error|null WP_Error if a banned word is found, null otherwise.
     */
    public static function check(string $text, array $banned_words_settings): ?WP_Error {
        if (!empty($banned_words_settings['words'])) {
            $banned_words_list = array_map('trim', explode(',', strtolower($banned_words_settings['words'])));
            $lower_text = strtolower($text);
            foreach ($banned_words_list as $banned_word) {
                if ($banned_word !== '' && str_contains($lower_text, $banned_word)) {
                    $banned_word_message = $banned_words_settings['message'] ?: __('Sorry, your message could not be sent as it contains prohibited words.', 'gpt3-ai-content-generator');
                    return new WP_Error('word_banned', $banned_word_message, ['status' => 400]); // Bad Request
                }
            }
        }
        return null;
    }
}