<?php
// File: admin/views/modules/chatbot/partials/appearance/custom-theme/send-button-settings.php
// NEW FILE

/**
 * Partial: Custom Theme - Send Button Color Settings
 */
if (!defined('ABSPATH')) {
    exit;
}

// Variables available from parent script (custom-theme-settings.php):
// $bot_id, $esc_cts_val_attr
?>
<h5 style="margin-top:15px;"><?php esc_html_e('Send Button', 'gpt3-ai-content-generator'); ?></h5>
<div class="aipkit_form-row">
    <div class="aipkit_form-group aipkit_form-col">
        <label class="aipkit_form-label" for="cts_send_button_bg_color_<?php echo esc_attr($bot_id); ?>">
            <?php esc_html_e('Background', 'gpt3-ai-content-generator'); ?>
        </label>
        <input type="color" id="cts_send_button_bg_color_<?php echo esc_attr($bot_id); ?>" name="custom_theme_settings[send_button_bg_color]" class="aipkit_form-input aipkit_color_picker_input" value="<?php echo $esc_cts_val_attr('send_button_bg_color'); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $esc_cts_val_attr is a helper closure that retrieves and escapes the value. ?>">
    </div>
    <div class="aipkit_form-group aipkit_form-col">
        <label class="aipkit_form-label" for="cts_send_button_text_color_<?php echo esc_attr($bot_id); ?>">
            <?php esc_html_e('Icon Color', 'gpt3-ai-content-generator'); ?>
        </label>
        <input type="color" id="cts_send_button_text_color_<?php echo esc_attr($bot_id); ?>" name="custom_theme_settings[send_button_text_color]" class="aipkit_form-input aipkit_color_picker_input" value="<?php echo $esc_cts_val_attr('send_button_text_color'); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Reason: $esc_cts_val_attr is a helper closure that retrieves and escapes the value. ?>">
    </div>
</div>