<?php
/**
 * Partial: AI Training - Indexing Settings Tab
 * This file provides the skeleton for the settings UI.
 * The actual form fields will be dynamically generated by JavaScript.
 * REVISED: Added a tabbed interface for settings.
 */
if (!defined('ABSPATH')) { exit; }

use WPAICG\aipkit_dashboard;

// Get the new general setting for the checkbox default
$training_general_settings = get_option('aipkit_training_general_settings', ['hide_user_uploads' => true]);
$hide_user_uploads_checked = $training_general_settings['hide_user_uploads'] ?? true;

// Check if user is on pro plan
$is_pro = aipkit_dashboard::is_pro_plan();

?>
<div class="aipkit_container-body">
    <form id="aipkit_indexing_settings_form" onsubmit="return false;">

        <div class="aipkit_accordion-group">
            <div class="aipkit_accordion">
                <div class="aipkit_accordion-header aipkit_active">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <?php esc_html_e('Content Indexing Controls', 'gpt3-ai-content-generator'); ?>
                    <?php if (!$is_pro): ?>
                        <span class="aipkit_status-tag" style="background-color: #fef3c7; color: #92400e; border: 1px solid #fde68a; margin-left: 8px; padding: 2px 8px; font-size: 11px; font-weight: 600; border-radius: 12px; text-transform: uppercase;"><?php esc_html_e('Pro', 'gpt3-ai-content-generator'); ?></span>
                    <?php endif; ?>
                </div>
                <div class="aipkit_accordion-content aipkit_active">
                    <?php if (!$is_pro): ?>
                        <div class="aipkit_notice aipkit_notice-info" style="margin-bottom: 15px; padding: 15px; background-color: #f0f8ff; border-left: 4px solid #0073aa; border-radius: 4px;">
                            <p style="margin: 0 0 10px 0;"><?php esc_html_e('Fine-tune indexing settings to control which custom fields, taxonomies, and product data to include when training your AI. Enable/disable specific fields and customize labels for better AI context.', 'gpt3-ai-content-generator'); ?></p>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=wpaicg-pricing')); ?>" class="button button-primary" style="margin-top: 5px;">
                                <?php esc_html_e('Upgrade to Pro', 'gpt3-ai-content-generator'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <p class="aipkit_form-help"><?php esc_html_e('Select which custom fields, product data, and taxonomies to include when indexing content. If a post type is not configured here, all of its public data will be indexed by default.', 'gpt3-ai-content-generator'); ?></p>
                    <div id="aipkit_indexing_settings_form_container">
                        <!-- Accordions will be dynamically generated here by JS -->
                    </div>
                </div>
            </div>
            <div class="aipkit_accordion">
                <div class="aipkit_accordion-header">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <?php esc_html_e('General', 'gpt3-ai-content-generator'); ?>
                </div>
                <div class="aipkit_accordion-content" id="general-training-settings-content">
                    <div class="aipkit_form-group">
                        <label class="aipkit_form-label aipkit_checkbox-label" for="aipkit_hide_user_uploads_checkbox">
                            <input
                                type="checkbox"
                                id="aipkit_hide_user_uploads_checkbox"
                                name="hide_user_uploads"
                                value="1"
                                <?php checked($hide_user_uploads_checked); ?>
                            >
                            <?php esc_html_e('Hide User-Uploaded Files', 'gpt3-ai-content-generator'); ?>
                        </label>
                        <p class="aipkit_form-help">
                            <?php esc_html_e('Hide vector stores created by users via the chatbot file upload feature from the main list.', 'gpt3-ai-content-generator'); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid var(--aipkit_container-border);">
            <div id="aipkit_indexing_settings_messages" class="aipkit_settings_messages" style="min-height: 1.5em; margin-bottom: 8px;"></div>
            <button id="aipkit_save_indexing_settings_btn" class="aipkit_btn aipkit_btn-primary">
                <span class="aipkit_btn-text"><?php esc_html_e('Save', 'gpt3-ai-content-generator'); ?></span>
                <span class="aipkit_spinner" style="display:none;"></span>
            </button>
        </div>
    </form>
</div>