/*jslint browser: true*/
//Revision: 2018.02.13

var gonzales;
gonzales = {
    menu: {
        init: function () {
            "use strict";
            var menuItem;

            menuItem = document.getElementById("wp-admin-bar-gonzales");
            if (menuItem) {
                menuItem.addEventListener("click", function () {
                    var panel = document.getElementById("gonzales");

                    if (panel) {
                        if (panel.style.display === "none") {
                            panel.style.display = "block";
                        } else {
                            panel.style.display = "none";
                        }
                    }
                });
            }
        }
    },
    UI: {
        init: function () {
            "use strict";
            var elements, submitButton;

            elements = document.querySelectorAll("#gonzales input[type=checkbox]");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {
                    document.gonzalesChanged = true;
                });
            });

            elements = document.querySelectorAll("#gonzales select");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {

                    //look for wrappers
                    var tr;
                    if (this.parentNode.tagName.toLowerCase() == 'td') {
                        tr = this.parentNode.parentNode;
                    } else {
                        tr = this.parentNode.parentNode.parentNode; //probably wrapper around select
                    }
                    var sectionCond = tr.querySelector(".g-cond");
                    var sectionExcp = tr.querySelector(".g-excp");
                    var sectionRegex = tr.querySelector(".g-regex");
                    var checkedRadio = tr.querySelector(".g-cond input[type=radio]:checked");

                    if (this.value == 'e') {
                        /**
                         * State = Enable
                         */

                        //ukrywanie sekcji "Where" i "Exceptions"
                        gonzales.helper.addClass("g-disabled", sectionCond);
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }

                        if (checkedRadio) {
                            //odznaczanie stanu "Where"
                            checkedRadio.checked = false;

                            //odznaczanie "Exceptions"
                            var tr2 = this.parentNode.parentNode.parentNode;
                            var section = tr2.querySelector(".g-excp");
                            gonzales.helper.clearSelected(section);
                        }
                    } else {
                        /**
                         * State = Disable
                         */

                        //pokazywanie sekcji "where"
                        gonzales.helper.removeClass("g-disabled", sectionCond);

                        //jeśli zaznaczono "Everywhere" pokaż tą sekcję
                        if (checkedRadio && checkedRadio.value == 'everywhere') {

                            if (sectionRegex) {
                                gonzales.helper.addClass("g-disabled", sectionRegex);
                            }
                            gonzales.helper.removeClass("g-disabled", sectionExcp);
                        } else if (checkedRadio && checkedRadio.value == 'regex') {
                            gonzales.helper.addClass("g-disabled", sectionExcp);
                            
                            if (sectionRegex) {
                                gonzales.helper.removeClass("g-disabled", sectionRegex);
                            }
                        }
                    }

                    document.gonzalesChanged = true;
                });
            });

            elements = document.querySelectorAll("#gonzales .g-cond input[type=radio]");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {

                    var tr = this.parentNode.parentNode.parentNode;
                    var sectionExcp = tr.querySelector(".g-excp");
                    var sectionRegex = tr.querySelector(".g-regex");

                    if (this.value == 'here') {
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }
                        gonzales.helper.clearSelected(sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.clearSelected(sectionRegex);
                        }
                    } else if (this.value == 'everywhere') {
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }
                        gonzales.helper.removeClass("g-disabled", sectionExcp);
                    } else if (this.value == 'regex') {
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.removeClass("g-disabled", sectionRegex);
                        }
                    }

                    document.gonzalesChanged = true;
                });
            });

            submitButton = document.getElementById("submit-gonzales");
            if (submitButton) {
                submitButton.addEventListener("click", function () {
                    document.gonzalesChanged = false;
                });
            }
        },
        protection: function () {
            "use strict";
            window.addEventListener("beforeunload", function (e) {
                if (document.gonzalesChanged) {
                    var confirmationMessage = "It looks like you have been editing configuration and tried to leave page without saving. Press cancel to stay on page.";
                    (e || window.event).returnValue = confirmationMessage;
                    return confirmationMessage;
                }
            });
        }
    },
    helper: {
        addClass: function(className, el) {
            "use strict";
            if (el.classList) {
                el.classList.add(className);
            } else {
                el.className += ' ' + className;
            }
        },
        removeClass: function(className, el) {
            "use strict";
            if (el.classList) {
                el.classList.remove(className);
            } else {
                el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
            }
        },
        clearSelected: function(el) {
            "use strict";
            var elements = el.querySelectorAll("input[type=checkbox]");
            Array.prototype.forEach.call(elements, function (input) {
                input.checked = false;
            });

            var elements = el.querySelectorAll("textarea");
            Array.prototype.forEach.call(elements, function (input) {
                input.value = "";
            });
        }
    },
    ready: function (fn) {
        "use strict";
        if (document.readyState !== "loading") {
            fn();
        } else {
            document.addEventListener("DOMContentLoaded", fn);
        }
    },
    init: function () {
        "use strict";
        gonzales.ready(gonzales.menu.init);
        gonzales.ready(gonzales.UI.init);
        gonzales.ready(gonzales.UI.protection);
    }
};

setTimeout(function(){ gonzales.init(); }, 100);
