/*jslint browser: true*/
//Revision: 2019.11.12

var gonzales;
gonzales = {
    menu: {
        init: function () {
            let menuItem = document.getElementById("wp-admin-bar-gonzales");
            if (menuItem) {
                menuItem.addEventListener("click", function () {
                    if (document.getElementById("gonzales-logo").src == 'data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==') {
                        document.getElementById("gonzales-logo").src = document.getElementById("gonzales-logo").getAttribute("data-src");
                    }

                    document.body.classList.toggle("gonzales");
                });
            }
        }
    },
    UI: {
        init: function () {
            let elements = document.querySelectorAll("#gnzl input[type=checkbox]");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {
                    document.gonzalesChanged = true;
                });
            });

            elements = document.querySelectorAll("#gnzl select");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {

                    //look for wrappers
                    var tr;
                    if (this.parentNode.tagName.toLowerCase() == 'td') {
                        tr = this.parentNode.parentNode;
                    } else {
                        tr = this.parentNode.parentNode.parentNode; //probably wrapper around select
                    }
                    var sectionCond = tr.querySelector(".g-cond");
                    var sectionExcp = tr.querySelector(".g-excp");
                    var sectionRegex = tr.querySelector(".g-regex");
                    var checkedRadio = tr.querySelector(".g-cond input[type=radio]:checked");

                    if (this.value == 'e') {
                        /**
                         * State = Enable
                         */

                        //ukrywanie sekcji "Where" i "Exceptions"
                        gonzales.helper.addClass("g-disabled", sectionCond);
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }

                        if (checkedRadio) {
                            //odznaczanie stanu "Where"
                            checkedRadio.checked = false;

                            //odznaczanie "Exceptions"
                            var tr2 = this.parentNode.parentNode.parentNode;
                            var section = tr2.querySelector(".g-excp");
                            gonzales.helper.clearSelected(section);
                        }
                    } else {
                        /**
                         * State = Disable
                         */

                        //pokazywanie sekcji "where"
                        gonzales.helper.removeClass("g-disabled", sectionCond);

                        //jeśli zaznaczono "Everywhere" pokaż tą sekcję
                        if (checkedRadio && checkedRadio.value == 'everywhere') {

                            if (sectionRegex) {
                                gonzales.helper.addClass("g-disabled", sectionRegex);
                            }
                            gonzales.helper.removeClass("g-disabled", sectionExcp);
                        } else if (checkedRadio && checkedRadio.value == 'regex') {
                            gonzales.helper.addClass("g-disabled", sectionExcp);
                            
                            if (sectionRegex) {
                                gonzales.helper.removeClass("g-disabled", sectionRegex);
                            }
                        }
                    }

                    document.gonzalesChanged = true;
                });
            });

            elements = document.querySelectorAll("#gnzl .g-cond input[type=radio]");
            Array.prototype.forEach.call(elements, function (el) {
                el.addEventListener("change", function () {

                    var tr = this.parentNode.parentNode.parentNode;
                    var sectionExcp = tr.querySelector(".g-excp");
                    var sectionRegex = tr.querySelector(".g-regex");

                    if (this.value == 'here') {
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }
                        gonzales.helper.clearSelected(sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.clearSelected(sectionRegex);
                        }
                    } else if (this.value == 'everywhere') {
                        if (sectionRegex) {
                            gonzales.helper.addClass("g-disabled", sectionRegex);
                        }
                        gonzales.helper.removeClass("g-disabled", sectionExcp);
                    } else if (this.value == 'regex') {
                        gonzales.helper.addClass("g-disabled", sectionExcp);
                        if (sectionRegex) {
                            gonzales.helper.removeClass("g-disabled", sectionRegex);
                        }
                    }

                    document.gonzalesChanged = true;
                });
            });

            let submitButton = document.getElementById("submit-gonzales");
            if (submitButton) {
                submitButton.addEventListener("click", function () {
                    document.gonzalesChanged = false;
                });
            }
        },
        protection: function () {
            window.addEventListener("beforeunload", function (e) {
                if (document.gonzalesChanged) {
                    var confirmationMessage = "It looks like you have been editing configuration and tried to leave page without saving. Press cancel to stay on page.";
                    (e || window.event).returnValue = confirmationMessage;
                    return confirmationMessage;
                }
            });
        }
    },
    helper: {
        addClass: function(className, el) {
            if (el.classList) {
                el.classList.add(className);
            } else {
                el.className += ' ' + className;
            }
        },
        removeClass: function(className, el) {
            if (el.classList) {
                el.classList.remove(className);
            } else {
                el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ').join('|') + '(\\b|$)', 'gi'), ' ');
            }
        },
        clearSelected: function(el) {
            var elements = el.querySelectorAll("input[type=checkbox]");
            Array.prototype.forEach.call(elements, function (input) {
                input.checked = false;
            });

            /*var elements = el.querySelectorAll("textarea");
            Array.prototype.forEach.call(elements, function (input) {
                input.value = "";
            });*/
        }
    },
    ready: function (fn) {
        if (document.readyState !== "loading") {
            fn();
        } else {
            document.addEventListener("DOMContentLoaded", fn);
        }
    },
    init: function () {
        gonzales.ready(gonzales.menu.init);
        gonzales.ready(gonzales.UI.init);
        gonzales.ready(gonzales.UI.protection);
    }
};

setTimeout(function(){ gonzales.init(); }, 100);
