<?php
// IMPLEMENTING TINYMCE LIGHTBOX
	
function gg_action_admin_init() {
	if( !current_user_can('edit_posts') && !current_user_can('edit_pages') )
		return;

	if(get_user_option('rich_editing') == 'true') {
		add_filter('mce_external_plugins', 'gg_filter_mce_plugin');
		add_filter('mce_buttons', 'gg_filter_mce_button');
	}
}
add_action('admin_init', 'gg_action_admin_init');

	
function gg_filter_mce_button( $buttons ) {
	array_push( $buttons, 'gg_btn');
	return $buttons;
}

function gg_filter_mce_plugin( $plugins ) {
	$plugins['ggallery'] = GG_URL . '/js/tinymce_btn.js?v='. GG_VER;
	return $plugins;
}




function gg_editor_btn_content() {
	if(strpos($_SERVER['REQUEST_URI'], 'post.php') === false && strpos($_SERVER['REQUEST_URI'], 'post-new.php') === false && !isset($GLOBALS['gg_tinymce_editor'])) {
		return false;
	}
	include_once(GG_DIR .'/settings/field_options.php');


	// get galleries
	$args = array(
		'post_type' => 'gg_galleries',
		'numberposts' => -1,
		'post_status' => 'publish',
		'fields' => 'ids'
	);
	
	$gall_ids = get_posts( $args );
	$galleries = array();
	
	foreach($gall_ids as $id) {
		$galleries[ $id ] = get_the_title($id);	
	}
	
	
	// get collections
	$collections = get_terms(array(
        'taxonomy'   => 'gg_collections',
        'hide_empty' => false,
    ));
?>


	<div id="ggallery_sc_wizard" class="gg_displaynone">
    	<div class="gg_scw_choser_wrap gg_scw_choser_wrap">
            <select name="gg_scw_choser" class="gg_scw_choser gg_scw_choser" autocomplete="off">
                <option value="#gg_sc_gall" selected="selected"><?php esc_html_e('Gallery', 'gg_ml') ?></option>
                <option value="#gg_sc_itg"><?php esc_html_e('Image-to-Gallery', 'gg_ml') ?></option>
                <option value="#gg_sc_coll"><?php esc_html_e('Collection', 'gg_ml') ?></option>	
                <option value="#gg_sc_slider"><?php esc_html_e('Slider', 'gg_ml') ?></option>	
                <option value="#gg_sc_car"><?php esc_html_e('Carousel', 'gg_ml') ?></option>	
            </select>	
        </div>
        
          
		<div id="gg_sc_gall" class="gg_scw_block gg_scw_block"> 
            <ul>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Which gallery?', 'gg_ml') ?></label>
               		<select id="gg_gall_choose" name="gg_gall_choose" data-placeholder="<?php esc_attr_e('Select gallery', 'gg_ml') ?> .." autocomplete="off">
						<?php
						foreach($galleries as $gid => $g_tit) {
							echo '<option value="'. absint($gid) .'">'. esc_html($g_tit) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Random display?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_random" name="gg_random" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Use watermark?', 'gg_ml') ?> <em>(<?php esc_html_e('where available', 'gg_ml') ?>)</em></label>
                    <input type="checkbox" id="gg_watermark" name="gg_watermark" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Use tags filter?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_tag_filter" name="gg_tag_filter" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Enable search?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_gall_search" name="gg_gall_search" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Pagination system', 'gg_ml') ?></label>
               		<select id="gg_gall_pagination" name="gg_gall_pagination" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
						
                        <option value=""><?php esc_html_e('Auto - follow global settings', 'gg_ml') ?></option>
                        <?php
						foreach(gg_pag_sys() as $id => $val) {
							echo '<option value="'. esc_attr($id) .'">'. esc_html($val) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field">
                	<input type="button" value="<?php esc_attr_e('Insert Gallery', 'gg_ml') ?>" name="gg_insert_gallery" id="gg_insert_gallery" class="button-primary" />
                </li>
			</ul>
		</div>  
        
        
        
        <div id="gg_sc_itg" class="gg_scw_block gg_scw_block"> 
            <ul>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Which gallery?', 'gg_ml') ?></label>
               		<select name="gg_itg_gall" data-placeholder="<?php esc_attr_e('Select gallery', 'gg_ml') ?> .." autocomplete="off">
						<?php
						foreach($galleries as $gid => $g_tit) {
							echo '<option value="'. absint($gid) .'">'. esc_html($g_tit) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("Box width", 'gg_ml') ?></label>
                    <input type="number" name="gg_itg_w" value="100" maxlength="4" autocomplete="off" />
                    
                    <select name="gg_itg_w_type" class="gg_scw_type_dd" autocomplete="off">
                    	<option value="%">%</option>
                        <option value="px">px</option>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("Images height", 'gg_ml') ?> <em>(<?php esc_html_e('% is proportional to width', 'gg_ml') ?>)</em></label>
                    
                    <input type="number" name="gg_itg_h" value="75" maxlength="4" autocomplete="off" />
                    
                    <select name="gg_itg_h_type" class="gg_scw_type_dd" autocomplete="off">
                    	<option value="%">%</option>
                        <option value="px">px</option>
                    </select>
                </li>
                <li class="gg_scw_field">
                	<label><?php esc_html_e("Layout", 'gg_ml') ?></label>

                    <select name="gg_itg_layout" autocomplete="off">
                    	<option value="">(<?php esc_html_e('default one', 'gg_ml') ?>)</option>
                       	<?php
						foreach(gg_itg_layouts() as $key => $val) {
							echo '<option value="'. esc_attr($key) .'">'. esc_html($val) .'</option>';	
						}
						?>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("How many images to display?", 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('This will be ignored if chosen layout is "main image + two on sides"', 'gg_ml') ?>"></span></label>

                    <select name="gg_itg_img_num" autocomplete="off">
                    	<option value="1">1</option>
                        <option value="2">2</option>
                        <option value="4">4</option>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("Custom font size", 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('Leave empty to use default one', 'gg_ml') ?>"></span></label>

                     <input type="number" name="gg_itg_font_size" value="" max="5" min="0.1" step="0.1" maxlength="4" autocomplete="off" /> rem
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Random images?', 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('Check to randomly pick images randomly from gallery', 'gg_ml') ?>"></span></label>
                    <input type="checkbox" name="gg_itg_random" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Use watermark?', 'gg_ml') ?> <em>(<?php esc_html_e('where available', 'gg_ml') ?>)</em></label>
                    <input type="checkbox" name="gg_itg_watermark" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field gg_itg_img_num">
                	<label><?php esc_html_e("Custom overlay text", 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('Remember you can use placeholders and FontAwesome icons as explained in settings', 'gg_ml') ?>"></span></label>
                    
                	<textarea name="gg_itg_cust_txt"></textarea>
				</li>

                <li class="gg_scw_field">
                	<input type="button" value="<?php esc_attr_e('Insert Image', 'gg_ml') ?>" name="gg_insert_itg" id="gg_insert_itg" class="button-primary" />
                </li>
			</ul>
		</div>  
		
        
        
        <div id="gg_sc_coll" class="gg_scw_block gg_scw_block"> 
            <ul>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Which collection?', 'gg_ml') ?></label>
               		<select id="gg_collection_choose" name="gg_collection_choose" data-placeholder="<?php esc_attr_e('Select gallery', 'gg_ml') ?> .." autocomplete="off">
						<?php
						foreach($collections as $collection) {
							echo '<option value="'. absint($collection->term_id) .'">'. esc_html($collection->name) .'</option>';
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Random display?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_coll_random" name="gg_coll_random" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Allow filters?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_coll_filter" name="gg_coll_filter" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                
                <li class="gg_scw_field lcwp_scwf_half gg_coll_scw_filter_related_fields pc_displaynone">
                	<label><?php esc_html_e('Selected filter', 'gg_ml') ?></label>
                    <select id="gg_coll_sel_filter" name="gg_coll_sel_filter" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
                        <option value="">(<?php esc_html_e('none', 'gg_ml') ?>)</option>
						<?php
                        $gall_cats = get_terms(array(
                            'taxonomy'   => 'gg_gall_categories',
                            'hide_empty' => false,
                        ));
						foreach($gall_cats as $cat) {
							echo '<option value="'. absint($cat->term_id) .'">'. esc_html($cat->name) .'</option>';
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half gg_coll_scw_filter_related_fields pc_displaynone">
                	<label><?php esc_html_e('Hide "All" filter?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_coll_hide_all_filter" name="gg_coll_hide_all_filter" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Pagination system', 'gg_ml') ?></label>
               		<select id="gg_coll_pagination" name="gg_coll_pagination" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
						
                        <option value=""><?php esc_html_e('None', 'gg_ml') ?></option>
                        <option value="auto"><?php esc_html_e('Auto - follow global settings', 'gg_ml') ?></option>
                        <?php
						foreach(gg_pag_sys() as $id => $val) {
							echo '<option value="'. esc_attr($id) .'">'. esc_html($val) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("How many galleries per page?", 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('Leave empty to disable pagination', 'gg_ml') ?>"></span></label>

                     <input type="number" id="gg_coll_per_page" name="gg_coll_per_page" value="" min="0" step="1" maxlength="3" autocomplete="off" />
                </li>
                <li class="gg_scw_field">
                	<input type="button" value="<?php esc_attr_e('Insert Collection', 'gg_ml') ?>" name="gg_insert_collection" id="gg_insert_collection" class="button-primary" />
                </li>
			</ul>
		</div>  
        
        
        
        <div id="gg_sc_slider" class="gg_scw_block gg_scw_block"> 
            <ul>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Images source', 'gg_ml') ?></label>
               		<select name="gg_slider_gallery" id="gg_slider_gallery" data-placeholder="<?php esc_attr_e('Select gallery', 'gg_ml') ?> .." autocomplete="off">
						<?php
						foreach($galleries as $gid => $g_tit) {
							echo '<option value="'. absint($gid) .'">'. esc_html($g_tit) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("Slider's width", 'gg_ml') ?></label>
                    
                    <input type="number" name="gg_slider_w" value="" id="gg_slider_w" maxlength="4" autocomplete="off" />
                    
                    <select name="gg_slider_w_type" id="gg_slider_w_type" class="gg_scw_type_dd" autocomplete="off">
                    	<option value="%">%</option>
                        <option value="px">px</option>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e("Slider's height", 'gg_ml') ?> <em>(<?php esc_html_e('% is proportional to width', 'gg_ml') ?>)</em></label>
                    
                    <input type="number" name="gg_slider_h" value="" id="gg_slider_h" maxlength="4" autocomplete="off" />
                    
                    <select name="gg_slider_h_type" id="gg_slider_h_type" class="gg_scw_type_dd" autocomplete="off">
                    	<option value="%">%</option>
                        <option value="px">px</option>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Images management method', 'gg_ml') ?></label>
               		<select name="gg_slider_crop" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
						<?php
                        foreach(gg_slider_crop_methods() as $opt => $val) {
                            echo '<option value="'. esc_attr($opt) .'">'. esc_html($val) .'</option>';   
                        }
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Hide extra navigation system?', 'gg_ml') ?></label>
                    <input type="checkbox" name="gg_no_extra_nav" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Zoom image on hover?', 'gg_ml') ?></label>
                    <input type="checkbox" name="zoom_on_hover" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Random display?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_slider_random" name="gg_slider_random" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Use watermark?', 'gg_ml') ?> <em>(<?php esc_html_e('where available', 'gg_ml') ?>)</em></label>
                    <input type="checkbox" id="gg_slider_watermark" name="gg_slider_watermark" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Autoplay slider?', 'gg_ml') ?></label>
               		<select id="gg_slider_autop" name="gg_slider_autop" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
						
                        <option value="auto">(<?php esc_html_e('as default', 'gg_ml') ?>)</option>
						<option value="1"><?php esc_html_e('Yes', 'gg_ml') ?></option>
                      	<option value="0"><?php esc_html_e('No', 'gg_ml') ?></option>
                	</select>
                </li>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Elements to remove (leave empty to use the default setup)', 'gg_ml') ?></label>
               		<select name="gg_slider_to_hide" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off" multiple>
						<?php
                        foreach(gg_slider_elems_to_hide() as $opt => $val) {
                            echo '<option value="'. esc_attr($opt) .'">'. esc_html($val) .'</option>';   
                        }
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field">
                	<input type="button" value="<?php esc_attr_e('Insert Slider', 'gg_ml') ?>" name="gg_insert_slider" id="gg_insert_slider" class="button-primary" />
                </li>
			</ul>
		</div>
        
        
        
        <div id="gg_sc_car" class="gg_scw_block gg_scw_block"> 
            <ul>
                <li class="gg_scw_field">
                	<label><?php esc_html_e('Which gallery?', 'gg_ml') ?></label>
               		<select name="gg_car_gallery" id="gg_car_gallery" data-placeholder="<?php esc_attr_e('Select gallery', 'gg_ml') ?> .." autocomplete="off">
						<?php
						foreach($galleries as $gid => $g_tit) {
							echo '<option value="'. absint($gid) .'">'. esc_html($g_tit) .'</option>';	
						}
                        ?>
                	</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Images max width', 'gg_ml') ?></label>
                    <input type="number" name="gg_car_max_w" value="" min="20" id="gg_car_max_w" maxlength="4" autocomplete="off" /> px
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Images height', 'gg_ml') ?></label>
                    <input type="number" name="gg_car_h" value="" id="gg_car_h" maxlength="4" autocomplete="off" /> 
                    
                    <select name="gg_car_h_type" id="gg_car_h_type" class="gg_scw_type_dd" autocomplete="off">
                        <option value="px">px</option>
                        <option value="%">%</option>
                    </select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Rows', 'gg_ml') ?></label>
                    
                    <select id="gg_car_rows" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." name="gg_car_rows" autocomplete="off">
						<?php
                        for($a=1; $a<=10; $a++) {
                        	echo '<option value="'. absint($a) .'">'. absint($a) .'</option>';  
                        }
                        ?>
					</select>
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Multi-scroll?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_car_multiscroll" name="gg_car_multiscroll" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Center display mode?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_car_center_mode" name="gg_car_center_mode" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Avoid images crop?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_car_nocrop" name="gg_car_nocrop" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Static mode?', 'gg_ml') ?> <span class="dashicons dashicons-info" title="<?php esc_attr_e('Disables overlay and lightbox', 'gg_ml') ?>"></span></label>
                    <input type="checkbox" id="gg_car_static" name="gg_car_static" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Random display?', 'gg_ml') ?></label>
                    <input type="checkbox" id="gg_car_random" name="gg_car_random" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Use watermark?', 'gg_ml') ?> <em>(<?php esc_html_e('where available', 'gg_ml') ?>)</em></label>
                    <input type="checkbox" id="gg_car_watermark" name="gg_car_watermark" value="1" class="gg_lc_switch" autocomplete="off" />
                </li>
                <li class="gg_scw_field lcwp_scwf_half">
                	<label><?php esc_html_e('Autoplay carousel?', 'gg_ml') ?></label>
               		<select id="gg_car_autop" name="gg_car_autop" data-placeholder="<?php esc_attr_e('Select an option', 'gg_ml') ?> .." autocomplete="off">
						
                        <option value="auto">(<?php esc_html_e('as default', 'gg_ml') ?>)</option>
						<option value="1"><?php esc_html_e('Yes', 'gg_ml') ?></option>
                      	<option value="0"><?php esc_html_e('No', 'gg_ml') ?></option>
                	</select>
                </li>
                <li class="gg_scw_field">
                	<input type="button" value="<?php esc_attr_e('Insert Carousel', 'gg_ml') ?>" name="gg_insert_carousel" id="gg_insert_carousel" class="button-primary" />
                </li>
			</ul>
    	</div> 
	</div>
<?php    
}
add_action('admin_footer', 'gg_editor_btn_content');
