<?php 

// get WP pages list - id => title
function gg_get_pages() {
	$pages = array();
	
	foreach(get_pages() as $pag) {
		$pages[ $pag->ID ] = $pag->post_title;	
	}
	
	return $pages;	
}


// galleries pagination systems
function gg_pag_sys() {
	return array(
		'standard' 			=> esc_html__('Standard', 'gg_ml'),
		'inf_scroll'		=> esc_html__('Infinite scroll', 'gg_ml'),
		'auto_inf_scroll'	=> esc_html__('Automatic Infinite scroll', 'gg_ml'),
		'num_btns'	 		=> esc_html__('Numbered buttons', 'gg_ml'),
		'dots'	 			=> esc_html__('Dots', 'gg_ml'),
	);
}


// galleries pagination systems
function gg_deeplink_elems() {
	return array(
		'ggt_' => esc_html__('Gallery tags', 'gg_ml'),
		'ggs_' => esc_html__('Gallery search', 'gg_ml'),
		'ggp_' => esc_html__('Gallery page', 'gg_ml'),
		'gcc_' => esc_html__('Collection category', 'gg_ml'),
		'gcg_' => esc_html__('Collection gallery', 'gg_ml'),
	);
}


// pagination layouts
function gg_pag_layouts($type = false) {
	$types = array(
		'standard' 	 	=> esc_html__('Commands + full text', 'gg_ml'),
		'only_num'  	=> esc_html__('Commands + page numbers', 'gg_ml'),
		'only_arr'		=> esc_html__('Only arrows', 'gg_ml'),
		'only_arr_mb'	=> esc_html__('Only arrows - monoblock', 'gg_ml'),	
	);
	
	if($type === false) {return $types;}
	else {return $types[$type];}
}


// image-to-gallery layouts
function gg_itg_layouts($layout = false) {
	$layouts = array(
		'corner_txt' 	=> esc_html__('Bottom-right corner overlay on last image', 'gg_ml'),
		'100_op_ol'  	=> esc_html__('100% opaque - full overlay on last image', 'gg_ml'),
		'50_op_ol'		=> esc_html__('50% opaque - full overlay on last image', 'gg_ml'),
		'0_op_ol'		=> esc_html__('0% opaque - full overlay on last image', 'gg_ml'),
		'block_over'	=> esc_html__('Centered text block over images', 'gg_ml'),	
		'main_n_sides'	=> esc_html__('Main image with central overlay + two smaller on sides', 'gg_ml'),	
	);
	
	if($layout === false) {return $layouts;}
	else {return $layouts[$layout];}	
}



// slider crop methods
function gg_slider_crop_methods($add_auto = true) {
	$opts = array(
		'auto'         => '(' . esc_html__('as default', 'gg_ml') . ')',
        'cover'        => esc_html__('Fill slider size (crop)', 'gg_ml'),
        'contain'      => esc_html__('Show full image (downscale)', 'gg_ml'),
        'contain_blur' => esc_html__('Show full image (downscale) + blurred image background', 'gg_ml'),
	);	
	
    if(!$add_auto) {
        unset($opts['auto']);   
    }
	return $opts;
}



// slider - elements to hide
function gg_slider_elems_to_hide() {
	$opts = array(
		'play' 		=> esc_html__('Play button', 'gg_ml'), 
        'lightbox' 	=> esc_html__('Lightbox button', 'gg_ml'), 
        'info' 		=> esc_html__("Images data", 'gg_ml'),
        'counter' 	=> esc_html__("Images counter", 'gg_ml') 
	);	
	return $opts;
}



// slider easings
function gg_slider_easings() {
	$opts = array(
		'ease' => esc_html__("Ease", 'gg_ml'),
		'linear' => esc_html__("Linear", 'gg_ml'),
		'ease-in' => esc_html__("Ease-in", 'gg_ml'),
		'ease-out' => esc_html__("Ease-out", 'gg_ml'),
		'ease-in-out' => esc_html__("Ease-in-out", 'gg_ml'),
		'ease-in-back' => esc_html__("Ease-in-back", 'gg_ml'),
		'ease-out-back' => esc_html__("Ease-out-back", 'gg_ml'),
		'ease-in-out-back' => esc_html__("Ease-in-out-back", 'gg_ml')
	);	
	
	return $opts;
}



// slider effects
function gg_slider_fx($type = false) {
	$types = array(
		'fadeslide' => esc_html__('Fade and slide', 'gg_ml'),
		'fade' 		=> esc_html__('Fade', 'gg_ml'),
		'slide'		=> esc_html__('Slide', 'gg_ml'),
		'v_slide'	=> esc_html__('Vertical slide', 'gg_ml'),
		'overlap'	=> esc_html__('Overlap', 'gg_ml'),
		'v_overlap'	=> esc_html__('Vertical overlap', 'gg_ml'),
		'zoom-in'	=> esc_html__('Zoom-in', 'gg_ml'),
		'zoom-out'	=> esc_html__('Zoom-out', 'gg_ml'),
	);
	
	return ($type === false) ? $types : $types[$type];
}


// slider thumbs visibility options
function gg_slider_thumb_opts($type = false) {
	$types = array(
		'always'	=> esc_html__('Always', 'gg_ml'),
		'yes' 		=> esc_html__('Yes with toggle button', 'gg_ml'),
		'no' 		=> esc_html__('No with toggle button', 'gg_ml'),
	);
	
	return ($type === false) ? $types : $types[$type];
}


// preloader types
function gg_preloader_types($type = false) {
	$types = array(
		'default' 				=> esc_html__('Default loader', 'gg_ml'),
		'rotating_square' 		=> esc_html__('Rotating square', 'gg_ml'),
		'overlapping_circles' 	=> esc_html__('Overlapping circles', 'gg_ml'),
		'stretch_rect' 			=> esc_html__('Stretching rectangles', 'gg_ml'),
		'spin_n_fill_square'	=> esc_html__('Spinning & filling square', 'gg_ml'),
		'pulsing_circle' 		=> esc_html__('Pulsing circle', 'gg_ml'),
		'spinning_dots'			=> esc_html__('Spinning dots', 'gg_ml'),
		'appearing_cubes'		=> esc_html__('Appearing cubes', 'gg_ml'),
		'folding_cube'			=> esc_html__('Folding cube', 'gg_ml'),
		'old_style_spinner'		=> esc_html__('Old-style spinner', 'gg_ml'),
		'minimal_spinner'		=> esc_html__('Minimal spinner', 'gg_ml'),
		'spotify_like'			=> esc_html__('Spotify-like spinner', 'gg_ml'),
		'vortex'				=> esc_html__('Vortex', 'gg_ml'),
		'bubbling_dots'			=> esc_html__('Bubbling Dots', 'gg_ml'),
		'overlapping_dots'		=> esc_html__('Overlapping dots', 'gg_ml'),
		'fading_circles'		=> esc_html__('Fading circles', 'gg_ml'),
	);
	return (!$type) ? $types : $types[$type];
}


// lightboxes list
function gg_lightboxes($type = false) {
	$types = array(
		'lcweb' 	=> 'LC Lightbox',
        'photoswipe'=> 'PhotoSwipe',
		'lightcase' => 'Lightcase',
		'simplelb' 	=> 'Simple Lightbox',
		'mag_popup' => 'Magnific Popup',
		'imagelb' 	=> 'imageLightbox',
		'photobox' 	=> 'Photobox',
	);
	return (!$type) ? $types : $types[$type];
}



// lightcase lightbox - transition styles
function gg_lightcase_trans_styles() {
	return array(
		'none'				=> esc_html__('No transition', 'gg_ml'), 
		'fade'				=> esc_html__('Fade', 'gg_ml'),  
		'elastic'			=> esc_html__('Elastic', 'gg_ml'),
		'scrollTop'			=> esc_html__('Downwards', 'gg_ml'),
		'scrollRight'		=> esc_html__('Leftwards', 'gg_ml'), 
		'scrollBottom'		=> esc_html__('Upwards', 'gg_ml'),
		'scrollLeft'		=> esc_html__('Rightwards', 'gg_ml'),
		'scrollHorizontal'	=> esc_html__('Horizontal scroll', 'gg_ml'),
		'scrollVertical'	=> esc_html__('Vertical scroll', 'gg_ml'),
	);
}


// LC Lightbox - openClose effects list
function gg_lcl_openclose_list() {
	return array(
		'lcl_fade_oc' 		=> esc_html__('Fade', 'gg_ml'),
		'lcl_zoomin_oc' 	=> esc_html__('Zoom-in', 'gg_ml'),
		'lcl_bottop_oc' 	=> esc_html__('Bottom to top', 'gg_ml'),
		'lcl_bottop_v2_oc' 	=> esc_html__('Bottom to top v2', 'gg_ml'),
		'lcl_rtl_oc' 		=> esc_html__('Right to left', 'gg_ml'),
		'lcl_horiz_flip_oc' => esc_html__('Horizontal flip', 'gg_ml'),
		'lcl_vert_flip_oc' 	=> esc_html__('Vertical flip', 'gg_ml'),
		'' 					=> esc_html__('None (customizable through CSS)', 'gg_ml'),
	);
}


// get the LC lightbox patterns list 
function gg_lcl_patterns_list() {
	$patterns = array();
	$patterns_list = scandir(GG_DIR."/js/lightboxes/lc-lightbox/img/patterns");
	
	foreach($patterns_list as $pattern_name) {
		if($pattern_name != '.' && $pattern_name != '..') {
			$patterns[$pattern_name] = substr($pattern_name, 0, -4);
		}
	}
	return $patterns;	
}

