<?php
// REGISTER BLOCK
include_once(GG_DIR .'/settings/field_options.php');


// structure
$defaults = array(
	'gid' => array(
		'label'		=> esc_html__('Images source', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => esc_html__('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'width' => array(
		'label'		=> esc_html__("Slider width", 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 100,
		'panel'		=> 'main',
	),
	'w_type' => array(
		'label'		=> esc_html__("Width unit type", 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'height' => array(
		'label'		=> esc_html__("Slider height", 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 55,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> esc_html__("Height unit type", 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
    'crop_method' => array(
		'label'		=> esc_html__('Images management method', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> gg_slider_crop_methods(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
    'no_extra_nav' => array(
		'label'		=> esc_html__('Hide extra navigation system?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
    'zoom_on_hover' => array(
		'label'		=> esc_html__('Zoom image on hover?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
        'help'      => esc_html__('If checked, zooms the shown image hovering the slider with the cursor', 'gg_ml'),
	),
	'random' => array(
		'label'		=> esc_html__('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> esc_html__('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'autoplay' => array(
		'label'		=> esc_html__('Autoplay slider?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'auto'	=> esc_html__('as default', 'gg_ml'),
			'1'		=> esc_html__('Yes', 'gg_ml'),
			'0'		=> esc_html__('No', 'gg_ml'),
		),
		'default' 	=> 'auto',
		'panel'		=> 'main',
	),
    'hidden_elems' => array(
		'label'		=> esc_html__('Elements to remove (leave empty to use the default setup)', 'gg_ml'),
		'type'		=> 'multi-opt',
		'opts'		=> gg_slider_elems_to_hide(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
);




$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-slider', array(
	'editor_script' 	=> 'gg_slider_on_guten',
	'render_callback' 	=> 'gg_slider_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_slider_defaults', $defaults);
