(function($) { 
	"use strict";
	
	
	var icon = wp.element.RawHTML({
			children: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 13.08 16"><defs><style>.a{fill:#6d6e71;}.b{fill:#fff;}.c{opacity:0.59;}.d{opacity:0.26;}</style></defs><polygon class="a" points="0.23 12.05 3.67 4.19 12.67 8.13 9.25 15.94 0.23 12.05"/><path class="a" d="M7.14,6.31,16,10.13l-3.33,7.74L3.8,14,7.14,6.31m0-.14L3.67,14.1,12.73,18l3.42-7.92L7.09,6.17Z" transform="translate(-3.46 -2)"/><path class="b" d="M8.3,10.43a2.07,2.07,0,0,0-.5,0H7.7l.51-1.19.45.19-.58.3Z" transform="translate(-3.46 -2)"/><path class="b" d="M7.43,7.22,4.66,13.65l6.13,2.64,2.77-6.43L7.43,7.22ZM10.6,16l-.51-1.69.79-.41-1-3.4,1.18-.59L10.8,9l2.36,1L10.6,16Zm-2.8-2.2a1,1,0,0,1-.37-.08,1,1,0,0,1-.49-1.23.94.94,0,0,1,.86-.56,1,1,0,0,1,.37.07.94.94,0,0,1-.37,1.8Z" transform="translate(-3.46 -2)"/><g class="c"><rect class="b" x="5.6" y="7.16" width="8.63" height="9.86" transform="translate(-8.57 14.4) rotate(-66.68)"/></g><polygon class="a" points="0.04 7.58 6.07 1.48 13.05 8.38 7.05 14.44 0.04 7.58"/><path class="a" d="M9.49,3.59l6.91,6.76-5.89,6L3.6,9.61l5.89-6m0-.14-6,6.16,7.05,6.9,6-6.16-7-6.9Z" transform="translate(-3.46 -2)"/><path class="b" d="M9.09,7.85a2.24,2.24,0,0,0-.54-.26l.91-.92L9.81,7l-.66.06Z" transform="translate(-3.46 -2)"/><path class="b" d="M9.43,4.55l-4.89,5,4.77,4.67,4.89-5L9.43,4.55Zm-.17,9.28.13-1.76.88-.09.28-3.54,1.32-.13.07-.88,1.83,1.79L9.26,13.83Zm-1.49-3a1,1,0,0,1-.65-.26.94.94,0,0,1,0-1.33A1,1,0,0,1,7.77,9a.94.94,0,0,1,.67,1.59.92.92,0,0,1-.67.28Z" transform="translate(-3.46 -2)"/><g class="d"><rect class="b" x="5.69" y="5.05" width="8.63" height="9.86" transform="translate(-7.59 8.15) rotate(-45.62)"/></g><polygon class="a" points="1.58 2.42 9.82 0.05 12.54 9.48 4.34 11.83 1.58 2.42"/><path class="a" d="M13.2,2.12l2.72,9.28L7.83,13.77,5.11,4.5,13.2,2.12M13.26,2,5,4.43,7.77,13.9,16,11.46,13.26,2Z" transform="translate(-3.46 -2)"/><path class="b" d="M6,4.9l1.88,6.41,6.72-2-1.88-6.4Zm2.39,1a.93.93,0,1,1-.63,1.16A.93.93,0,0,1,8.35,5.89Zm5.83,3.24L8,11,9,9.47l.82.35,2-2.94L13,7.4l.5-.73Z" transform="translate(-3.46 -2)"/></svg>'
	});
	
	
		
	// recreate attributes from PHP array
	var atts = {};
	$.each(gg_gall_defaults, function(i, v) {
		atts[i] = {default : v.default};
	});
	
	
	
	
	// trick executing javascript on server rendered element
    window.gg_gall_guten_tout;
	window.gg_gall_guten_on_display = function(blockId) {
		setTimeout(function() { // wait a bit for possible guten mess
			
			if(!$('#block-'+ blockId +' .gg_gallery_wrap').length || $('#block-'+ blockId +' .components-placeholder').length) {
				setTimeout(function() {
					gg_gall_guten_on_display(blockId);
				}, 350);
				return false;
			}
            
            else {
                if(window.gg_gall_guten_tout) {
                    clearTimeout(window.gg_gall_guten_tout);    
                }
                
                window.gg_gall_guten_tout = setTimeout(function() {
                    let subj_id = $('#block-'+ blockId +' .gg_gallery_wrap').attr('id');
                    if(subj_id) {
                        gg_galleries_init(subj_id);
                    
                        // track "lazy" module reloads
                        const intval = setInterval(() => {
                            let live_subj_id = $('#block-'+ blockId +' .gg_gallery_wrap').attr('id');

                            if(subj_id != live_subj_id) {
                                gg_gall_guten_on_display(blockId);
                                clearInterval(intval);
                            }
                        }, 100);
                    }
                }, 360);
            }
		}, 400);
	};
	
		
	
	// register block
	var args = {
		block_id			: 'lcweb/g-gallery',
		category			: 'lc-global-gallery',
		title				: 'Gallery',
		icon				: icon,
		panels				: gg_panels,
		structure			: gg_gall_defaults,
		attributes			: atts,
		on_display_callback : 'gg_gall_guten_on_display',
	};
	lc_register_block(args); 


})(jQuery); 