<?php

class MeowPro_MGCL_Library {
  private $core = null;

	public function __construct( $core ) {
    $this->core = $core;
    if ( is_admin() ) {
      add_filter( 'admin_init', array( $this, 'admin_init' ), 10, 0 );
    }
	}

  function admin_init() {
    if ( $this->core->can_access_features() ) {
      add_action( 'pre_get_posts', array( $this, 'my_custom_filter' ), 60, 2 );
      add_action( 'admin_print_footer_scripts', array( $this, 'admin_print_footer_scripts' ), 60 );
      add_filter( 'manage_media_columns', array( $this, 'manage_media_columns' ) );
		  add_action( 'manage_media_custom_column', array( $this, 'manage_media_custom_column' ), 10, 2 );
    }
  }

  function my_custom_filter( $query ) {
    if ( $query->is_main_query() ) {
      if ( isset( $_GET['attachment-filter'] ) && $_GET['attachment-filter'] === 'mgcl_unlinked' ) {
        $query->set( 'meta_query', array(
          array(
          'key'     => '_gallery_link_url',
          'compare' => 'NOT EXISTS'
          )
        ));
      }
    }
    return $query;
  }

  function manage_media_columns( $cols ) {
		$cols["GalleryCustomLinks"] = "Gallery Custom Links";
		return $cols;
	}

	function manage_media_custom_column( $column_name, $post_id ) {
		if ( $column_name != 'GalleryCustomLinks' )
			return;
		$url = get_post_meta( $post_id, '_gallery_link_url', true );
		$target = get_post_meta( $post_id, '_gallery_link_target', true );
		$rel = get_post_meta( $post_id, '_gallery_link_rel', true );
		$aria = get_post_meta( $post_id, '_gallery_link_aria', true );
		echo '<div class="mgcl-edit-link-field" data-post-id="' . esc_attr( $post_id ) . '" data-url="' . esc_attr( $url ) . '" data-target="' . esc_attr( $target ) . '" data-rel="' . esc_attr( $rel ) . '" data-aria="' . esc_attr( $aria ) . '"></div>';
	}

  function admin_print_footer_scripts() { 
    ?>
      <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function() {
          let attachmentFilter = document.getElementById('attachment-filter');
          if (attachmentFilter) {
            let newOption = document.createElement("option");
            newOption.text = "Unlinked";
            newOption.value = "mgcl_unlinked";
            attachmentFilter.appendChild(newOption);
          }
        });
      </script>
  <?php }
}

