/*!
 * Signature Pad v2.3.2
 * https://github.com/szimek/signature_pad
 *
 * Copyright 2017 Szymon Nowak
 * Released under the MIT license
 *
 * The main idea and some parts of the code (e.g. drawing variable width Bézier curve) are taken from:
 * http://corner.squareup.com/2012/07/smoother-signatures.html
 *
 * Implementation of interpolation using cubic Bézier curves is taken from:
 * http://benknowscode.wordpress.com/2012/09/14/path-interpolation-using-cubic-bezier-and-control-point-estimation-in-javascript
 *
 * Algorithm for approximated length of a Bézier curve is taken from:
 * http://www.lemoda.net/maths/bezier-length/index.html
 *
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.SignaturePad=e()}(this,(function(){"use strict";function t(t,e,i){this.x=t,this.y=e,this.time=i||(new Date).getTime()}function e(t,e,i,o){this.startPoint=t,this.control1=e,this.control2=i,this.endPoint=o}function i(t,e){var o=this,n=e||{};this.velocityFilterWeight=n.velocityFilterWeight||.7,this.minWidth=n.minWidth||.5,this.maxWidth=n.maxWidth||2.5,this.throttle="throttle"in n?n.throttle:16,this.minDistance="minDistance"in n?n.minDistance:5,this.throttle?this._strokeMoveUpdate=function(t,e,i){var o,n,a,s=null,r=0;i||(i={});var h=function(){r=!1===i.leading?0:Date.now(),s=null,a=t.apply(o,n),s||(o=n=null)};return function(){var c=Date.now();r||!1!==i.leading||(r=c);var d=e-(c-r);return o=this,n=arguments,d<=0||d>e?(s&&(clearTimeout(s),s=null),r=c,a=t.apply(o,n),s||(o=n=null)):s||!1===i.trailing||(s=setTimeout(h,d)),a}}(i.prototype._strokeUpdate,this.throttle):this._strokeMoveUpdate=i.prototype._strokeUpdate,this.dotSize=n.dotSize||function(){return(this.minWidth+this.maxWidth)/2},this.penColor=n.penColor||"black",this.backgroundColor=n.backgroundColor||"rgba(0,0,0,0)",this.onBegin=n.onBegin,this.onEnd=n.onEnd,this._canvas=t,this._ctx=t.getContext("2d"),this.clear(),this._handleMouseDown=function(t){1===t.which&&(o._mouseButtonDown=!0,o._strokeBegin(t))},this._handleMouseMove=function(t){o._mouseButtonDown&&o._strokeMoveUpdate(t)},this._handleMouseUp=function(t){1===t.which&&o._mouseButtonDown&&(o._mouseButtonDown=!1,o._strokeEnd(t))},this._handleTouchStart=function(t){if(1===t.targetTouches.length){var e=t.changedTouches[0];o._strokeBegin(e)}},this._handleTouchMove=function(t){t.preventDefault();var e=t.targetTouches[0];o._strokeMoveUpdate(e)},this._handleTouchEnd=function(t){t.target===o._canvas&&(t.preventDefault(),o._strokeEnd(t))},this.on()}return t.prototype.velocityFrom=function(t){return this.time!==t.time?this.distanceTo(t)/(this.time-t.time):1},t.prototype.distanceTo=function(t){return Math.sqrt(Math.pow(this.x-t.x,2)+Math.pow(this.y-t.y,2))},t.prototype.equals=function(t){return this.x===t.x&&this.y===t.y&&this.time===t.time},e.prototype.length=function(){for(var t=0,e=void 0,i=void 0,o=0;o<=10;o+=1){var n=o/10,a=this._point(n,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),s=this._point(n,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y);if(o>0){var r=a-e,h=s-i;t+=Math.sqrt(r*r+h*h)}e=a,i=s}return t},e.prototype._point=function(t,e,i,o,n){return e*(1-t)*(1-t)*(1-t)+3*i*(1-t)*(1-t)*t+3*o*(1-t)*t*t+n*t*t*t},i.prototype.clear=function(){var t=this._ctx,e=this._canvas;t.fillStyle=this.backgroundColor,t.clearRect(0,0,e.width,e.height),t.fillRect(0,0,e.width,e.height),this._data=[],this._reset(),this._isEmpty=!0},i.prototype.fromDataURL=function(t){var e=this,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},o=new Image,n=i.ratio||window.devicePixelRatio||1,a=i.width||this._canvas.width/n,s=i.height||this._canvas.height/n;this._reset(),o.src=t,o.onload=function(){e._ctx.drawImage(o,0,0,a,s)},this._isEmpty=!1},i.prototype.toDataURL=function(t){var e;switch(t){case"image/svg+xml":return this._toSVG();default:for(var i=arguments.length,o=Array(i>1?i-1:0),n=1;n<i;n++)o[n-1]=arguments[n];return(e=this._canvas).toDataURL.apply(e,[t].concat(o))}},i.prototype.on=function(){this._handleMouseEvents(),this._handleTouchEvents()},i.prototype.off=function(){this._canvas.removeEventListener("mousedown",this._handleMouseDown),this._canvas.removeEventListener("mousemove",this._handleMouseMove),document.removeEventListener("mouseup",this._handleMouseUp),this._canvas.removeEventListener("touchstart",this._handleTouchStart),this._canvas.removeEventListener("touchmove",this._handleTouchMove),this._canvas.removeEventListener("touchend",this._handleTouchEnd)},i.prototype.isEmpty=function(){return this._isEmpty},i.prototype._strokeBegin=function(t){this._data.push([]),this._reset(),this._strokeUpdate(t),"function"==typeof this.onBegin&&this.onBegin(t)},i.prototype._strokeUpdate=function(t){var e=t.clientX,i=t.clientY,o=this._createPoint(e,i),n=this._data[this._data.length-1],a=n&&n[n.length-1],s=a&&o.distanceTo(a)<this.minDistance;if(!a||!s){var r=this._addPoint(o),h=r.curve,c=r.widths;h&&c&&this._drawCurve(h,c.start,c.end),this._data[this._data.length-1].push({x:o.x,y:o.y,time:o.time,color:this.penColor})}},i.prototype._strokeEnd=function(t){var e=this.points.length>2,i=this.points[0];if(!e&&i&&this._drawDot(i),i){var o=this._data[this._data.length-1],n=o[o.length-1];i.equals(n)||o.push({x:i.x,y:i.y,time:i.time,color:this.penColor})}"function"==typeof this.onEnd&&this.onEnd(t)},i.prototype._handleMouseEvents=function(){this._mouseButtonDown=!1,this._canvas.addEventListener("mousedown",this._handleMouseDown),this._canvas.addEventListener("mousemove",this._handleMouseMove),document.addEventListener("mouseup",this._handleMouseUp)},i.prototype._handleTouchEvents=function(){this._canvas.style.msTouchAction="none",this._canvas.style.touchAction="none",this._canvas.addEventListener("touchstart",this._handleTouchStart),this._canvas.addEventListener("touchmove",this._handleTouchMove),this._canvas.addEventListener("touchend",this._handleTouchEnd)},i.prototype._reset=function(){this.points=[],this._lastVelocity=0,this._lastWidth=(this.minWidth+this.maxWidth)/2,this._ctx.fillStyle=this.penColor},i.prototype._createPoint=function(e,i,o){var n=this._canvas.getBoundingClientRect();return new t(e-n.left,i-n.top,o||(new Date).getTime())},i.prototype._addPoint=function(t){var i=this.points;if(i.push(t),i.length>2){3===i.length&&i.unshift(i[0]);var o=this._calculateCurveControlPoints(i[0],i[1],i[2]).c2,n=this._calculateCurveControlPoints(i[1],i[2],i[3]).c1,a=new e(i[1],o,n,i[2]),s=this._calculateCurveWidths(a);return i.shift(),{curve:a,widths:s}}return{}},i.prototype._calculateCurveControlPoints=function(e,i,o){var n=e.x-i.x,a=e.y-i.y,s=i.x-o.x,r=i.y-o.y,h=(e.x+i.x)/2,c=(e.y+i.y)/2,d=(i.x+o.x)/2,l=(i.y+o.y)/2,u=Math.sqrt(n*n+a*a),p=Math.sqrt(s*s+r*r),v=p/(u+p),m=d+(h-d)*v,f=l+(c-l)*v,_=i.x-m,g=i.y-f;return{c1:new t(h+_,c+g),c2:new t(d+_,l+g)}},i.prototype._calculateCurveWidths=function(t){var e=t.startPoint,i=t.endPoint,o={start:null,end:null},n=this.velocityFilterWeight*i.velocityFrom(e)+(1-this.velocityFilterWeight)*this._lastVelocity,a=this._strokeWidth(n);return o.start=this._lastWidth,o.end=a,this._lastVelocity=n,this._lastWidth=a,o},i.prototype._strokeWidth=function(t){return Math.max(this.maxWidth/(t+1),this.minWidth)},i.prototype._drawPoint=function(t,e,i){var o=this._ctx;o.moveTo(t,e),o.arc(t,e,i,0,2*Math.PI,!1),this._isEmpty=!1},i.prototype._drawCurve=function(t,e,i){var o=this._ctx,n=i-e,a=Math.floor(t.length());o.beginPath();for(var s=0;s<a;s+=1){var r=s/a,h=r*r,c=h*r,d=1-r,l=d*d,u=l*d,p=u*t.startPoint.x;p+=3*l*r*t.control1.x,p+=3*d*h*t.control2.x,p+=c*t.endPoint.x;var v=u*t.startPoint.y;v+=3*l*r*t.control1.y,v+=3*d*h*t.control2.y,v+=c*t.endPoint.y;var m=e+c*n;this._drawPoint(p,v,m)}o.closePath(),o.fill()},i.prototype._drawDot=function(t){var e=this._ctx,i="function"==typeof this.dotSize?this.dotSize():this.dotSize;e.beginPath(),this._drawPoint(t.x,t.y,i),e.closePath(),e.fill()},i.prototype._fromData=function(e,i,o){for(var n=0;n<e.length;n+=1){var a=e[n];if(a.length>1)for(var s=0;s<a.length;s+=1){var r=a[s],h=new t(r.x,r.y,r.time),c=r.color;if(0===s)this.penColor=c,this._reset(),this._addPoint(h);else if(s!==a.length-1){var d=this._addPoint(h),l=d.curve,u=d.widths;l&&u&&i(l,u,c)}}else this._reset(),o(a[0])}},i.prototype._toSVG=function(){var t=this,e=this._data,i=this._canvas,o=Math.max(window.devicePixelRatio||1,1),n=i.width/o,a=i.height/o,s=document.createElementNS("http://www.w3.org/2000/svg","svg");s.setAttributeNS(null,"width",i.width),s.setAttributeNS(null,"height",i.height),this._fromData(e,(function(t,e,i){var o=document.createElement("path");if(!(isNaN(t.control1.x)||isNaN(t.control1.y)||isNaN(t.control2.x)||isNaN(t.control2.y))){var n="M "+t.startPoint.x.toFixed(3)+","+t.startPoint.y.toFixed(3)+" C "+t.control1.x.toFixed(3)+","+t.control1.y.toFixed(3)+" "+t.control2.x.toFixed(3)+","+t.control2.y.toFixed(3)+" "+t.endPoint.x.toFixed(3)+","+t.endPoint.y.toFixed(3);o.setAttribute("d",n),o.setAttribute("stroke-width",(2.25*e.end).toFixed(3)),o.setAttribute("stroke",i),o.setAttribute("fill","none"),o.setAttribute("stroke-linecap","round"),s.appendChild(o)}}),(function(e){var i=document.createElement("circle"),o="function"==typeof t.dotSize?t.dotSize():t.dotSize;i.setAttribute("r",o),i.setAttribute("cx",e.x),i.setAttribute("cy",e.y),i.setAttribute("fill",e.color),s.appendChild(i)}));var r='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 '+n+" "+a+'" width="'+n+'" height="'+a+'">',h=s.innerHTML;if(void 0===h){var c=document.createElement("dummy"),d=s.childNodes;c.innerHTML="";for(var l=0;l<d.length;l+=1)c.appendChild(d[l].cloneNode(!0));h=c.innerHTML}return"data:image/svg+xml;base64,"+btoa(r+h+"</svg>")},i.prototype.fromData=function(t){var e=this;this.clear(),this._fromData(t,(function(t,i){return e._drawCurve(t,i.start,i.end)}),(function(t){return e._drawDot(t)})),this._data=t},i.prototype.toData=function(){return this._data},i})),function(t){function e(e){var i=!1;(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4)))&&(i=!0);var o=e,n=o.find("[data-action=clear]")[0],a=o.find("canvas"),s=a[0],r=o.find("input.signature-source"),h=o.find("input.signature-changed"),c=!1;function d(){var t=Math.max(window.devicePixelRatio||1,1);s.width=s.offsetWidth*t,s.height=s.offsetHeight*t,s.getContext("2d").scale(t,t)}i||void 0===s||(window.onresize=d()),setInterval((function(){if(t(a).is(":visible")&&!c){var e=new SignaturePad(s,{backgroundColor:"rgba(255, 255, 255, 0)",penColor:"rgb(0, 0, 0)",velocityFilterWeight:.7,minWidth:.5,maxWidth:2.5,throttle:16,minPointDistance:3});d(),c=!0;var i=t(r).val();i.length&&e.fromDataURL(i),t(n).on("click",(function(i){i.preventDefault(),e.clear(),t(r).val(""),t(h).val(1)})),t(s).on("touchend mouseup mouseleave",(function(i){e&&(e.isEmpty()?t(r).val(""):t(r).val(e.toDataURL()),t(h).val(1))}))}}),100)}void 0!==acf.add_action?acf.add_action("ready append",(function(i){acf.get_fields({type:"form_signature"},i).each((function(){e(t(this))}))})):t(document).on("acf/setup_fields",(function(i,o){t(o).find('.field[data-field_type="form_signature"]').each((function(){e(t(this))}))}))}(jQuery);