<?php

require_once dirname( __FILE__ ) . '/forminator-addon-slack-exception.php';
require_once dirname( __FILE__ ) . '/lib/class-wp-slack-api.php';

/**
 * Class Forminator_Addon_Slack
 * Slack Addon Main Class
 *
 * @since 1.0 Slack Addon
 */
final class Forminator_Addon_Slack extends Forminator_Addon_Abstract {

	/**
	 * @var self|null
	 */
	private static $_instance = null;

	protected $_slug                   = 'slack';
	protected $_version                = FORMINATOR_ADDON_SLACK_VERSION;
	protected $_min_forminator_version = '1.1';
	protected $_short_title            = 'Slack';
	protected $_title                  = 'Slack';
	protected $_url                    = 'https://premium.wpmudev.org';
	protected $_full_path              = __FILE__;

	protected $_form_settings = 'Forminator_Addon_Slack_Form_Settings';
	protected $_form_hooks    = 'Forminator_Addon_Slack_Form_Hooks';

	/**
	 * Forminator_Addon_Slack constructor.
	 *
	 * @since 1.0 Slack Addon
	 */
	public function __construct() {
		// late init to allow translation
		$this->_description                = __( 'Get your slack team notified.', Forminator::DOMAIN );
		$this->_activation_error_message   = __( 'Sorry but we failed to activate Slack Integration, don\'t hesitate to contact us', Forminator::DOMAIN );
		$this->_deactivation_error_message = __( 'Sorry but we failed to deactivate Slack Integration, please try again', Forminator::DOMAIN );

		$this->_update_settings_error_message = __(
			'Sorry, we are failed to update settings, please check your form and try again',
			Forminator::DOMAIN
		);

		$this->_icon     = forminator_addon_slack_assets_url() . 'icons/slack.png';
		$this->_icon_x2  = forminator_addon_slack_assets_url() . 'icons/slack@2x.png';
		$this->_image    = forminator_addon_slack_assets_url() . 'img/slack.png';
		$this->_image_x2 = forminator_addon_slack_assets_url() . 'img/slack@2x.png';
	}

	/**
	 * Get Instance
	 *
	 * @since 1.0 Slack Addon
	 * @return self|null
	 */
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Override on is_connected
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @return bool
	 */
	public function is_connected() {
		return false;
	}

	/**
	 * Check if Slack is connected with current form
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param $form_id
	 *
	 * @return bool
	 */
	public function is_form_connected( $form_id ) {
		return false;
	}

	/**
	 * Override settings available,
	 *
	 * @since 1.0 Slack Addon
	 * @return bool
	 */
	public function is_settings_available() {
		return true;
	}

	/**
	 * Flag show full log on entries
	 *
	 * @since 1.0 Slack Addon
	 * @return bool
	 */
	public static function is_show_full_log() {
		if ( defined( 'FORMINATOR_ADDON_SLACK_SHOW_FULL_LOG' ) && FORMINATOR_ADDON_SLACK_SHOW_FULL_LOG ) {
			return true;
		}

		return false;
	}

	/**
	 * Allow multiple connection on one form
	 *
	 * @since 1.0 Slack Addon
	 * @return bool
	 */
	public function is_allow_multi_on_form() {
		return true;
	}

}