<?php

require_once dirname( __FILE__ ) . '/forminator-addon-slack-form-settings-exception.php';

/**
 * Class Forminator_Addon_Slack_Form_Settings
 * Handle how form settings displayed and saved
 *
 * @since 1.0 Slack Addon
 */
class Forminator_Addon_Slack_Form_Settings extends Forminator_Addon_Form_Settings_Abstract {

	/**
	 * @var Forminator_Addon_Slack
	 * @since 1.0 Slack Addon
	 */
	protected $addon;

	/**
	 * Forminator_Addon_Slack_Form_Settings constructor.
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param Forminator_Addon_Abstract $addon
	 * @param                           $form_id
	 *
	 * @throws Forminator_Addon_Exception
	 */
	public function __construct( Forminator_Addon_Abstract $addon, $form_id ) {
		parent::__construct( $addon, $form_id );

		$this->_update_form_settings_error_message = __(
			'Sorry, we are failed to update settings for this form, please check your form and input then try again',
			Forminator::DOMAIN
		);
	}

	/**
	 * Slack Form Settings wizard
	 *
	 * @since 1.0 Slack Addon
	 * @return array
	 */
	public function form_settings_wizards() {
		// numerical array steps
		return array(
			// 0
			array(
				'callback'     => array( $this, 'setup_something' ),
				'is_completed' => array( $this, 'setup_something_is_completed' ),
			),
		);
	}

	/**
	 * Setup webhook url
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param $submitted_data
	 *
	 * @return array
	 */
	public function setup_something( $submitted_data ) {
		return array();
	}

	/**
	 * Check if setup webhook url is completed
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param $submitted_data
	 *
	 * @return bool
	 */
	public function setup_something_is_completed( $submitted_data ) {
		return false;
	}

	/**
	 * Generate multi id for multiple connection
	 *
	 * @since 1.0 Slack Addon
	 * @return string
	 */
	public function generate_multi_id() {
		return uniqid( 'slack_', true );
	}


	/**
	 * Override how multi connection displayed
	 *
	 * @since 1.0 Slack Addon
	 * @return array
	 */
	public function get_multi_ids() {
		$multi_ids = array();
		foreach ( $this->get_form_settings_values() as $key => $value ) {
			$multi_ids[] = array(
				'id'    => $key,
				// use name that was added by user on creating connection
				'label' => isset( $value['name'] ) ? $value['name'] : $key,
			);
		}

		return $multi_ids;
	}

	/**
	 * Disconnect a connection from current form
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param array $submitted_data
	 */
	public function disconnect_form( $submitted_data ) {
		// only execute if multi_id provided on submitted data
		if ( isset( $submitted_data['multi_id'] ) && ! empty( $submitted_data['multi_id'] ) ) {
			$addon_form_settings = $this->get_form_settings_values();
			unset( $addon_form_settings[ $submitted_data['multi_id'] ] );
			$this->save_form_settings_values( $addon_form_settings );
		}
	}
}