/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * WordPress dependencies
 */
var __ = wp.i18n.__;
var registerBlockType = wp.blocks.registerBlockType;
var _wp$components = wp.components,
    Placeholder = _wp$components.Placeholder,
    SelectControl = _wp$components.SelectControl,
    Spinner = _wp$components.Spinner,
    Toolbar = _wp$components.Toolbar,
    IconButton = _wp$components.IconButton;
var _wp$element = wp.element,
    Component = _wp$element.Component,
    RawHTML = _wp$element.RawHTML;
var _wp$editor = wp.editor,
    InspectorControls = _wp$editor.InspectorControls,
    BlockControls = _wp$editor.BlockControls,
    BlockAlignmentToolbar = _wp$editor.BlockAlignmentToolbar;

/**
 * Block edit class
 */

var BlockEdit = function (_Component) {
	_inherits(BlockEdit, _Component);

	/**
  * Class constructor
  */
	function BlockEdit() {
		_classCallCheck(this, BlockEdit);

		var _this = _possibleConstructorReturn(this, (BlockEdit.__proto__ || Object.getPrototypeOf(BlockEdit)).apply(this, arguments));

		_this.update_id = _this.update_id.bind(_this);
		_this.preview = _this.preview.bind(_this);

		_this.state = {
			loading: false, // Set to true while loading preview markup
			markup: '' // Preview markup
		};
		return _this;
	}

	/**
  * Update module id
  */


	_createClass(BlockEdit, [{
		key: 'update_id',
		value: function update_id(id) {
			this.props.setAttributes({ module_id: id });
		}

		/**
   * Preview module
   */

	}, {
		key: 'preview',
		value: function preview(attributes) {
			var _this2 = this;

			var module_id = attributes.module_id;

			// Check if we already process ajax request

			if (this.state.loading) {
				// Ajax request in process, skip
				return;
			}

			// Set loading to true
			this.setState({ loading: true });

			// Build AJAX Url
			var ajax_url = wpApiSettings.root + 'forminator/v1/preview/forms/?module_id=' + module_id;

			window.fetch(ajax_url).then(function (response) {
				return response.json();
			}).then(function (data) {

				if (data.success) {
					_this2.setState({ markup: data.data.markup });
				}

				setTimeout(function () {
					var form = window.jQuery('form.forminator-custom-form');
					_this2.form_scripts(form, module_id);
				}, 10);

				// Set loading to false
				_this2.setState({ loading: false });
			}).catch(function (error) {
				return { success: false };
			});
		}
	}, {
		key: 'form_scripts',
		value: function form_scripts(form, module_id) {
			//Prevent form submission
			form.submit(function (e) {
				e.preventDefault();

				return false;
			});

			// Pagination
			var total_steps = form.find(".forminator-pagination").length;
			if (total_steps > 0) {
				form.forminatorFrontPagination({
					totalSteps: total_steps,
					step: 0
				});
			}

			// Date picker
			// form.find('.forminator-datepicker').forminatorFrontDatePicker();

			// Select 2
			if (form.hasClass('forminator-design--default')) {
				form.find(".forminator-select").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-dropdown forminator-dropdown--default forminator-ddfor--" + module_id
				});

				form.find(".forminator-time").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-droptime forminator-droptime--default forminator-ddfor--" + module_id
				});
			} else if (form.hasClass('forminator-design--material')) {

				form.find(".forminator-select").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-dropdown forminator-dropdown--material forminator-ddfor--" + module_id
				});

				form.find(".forminator-time").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-droptime forminator-droptime--material forminator-ddfor--" + module_id
				});
			} else if (form.hasClass('forminator-design--bold')) {

				form.find(".forminator-select").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-dropdown forminator-dropdown--bold forminator-ddfor--" + module_id
				});

				form.find(".forminator-time").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-droptime forminator-droptime--bold forminator-ddfor--" + module_id
				});
			} else if (form.hasClass('forminator-design--flat')) {

				form.find(".forminator-select").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-dropdown forminator-dropdown--flat forminator-ddfor--" + module_id
				});

				form.find(".forminator-time").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-droptime forminator-droptime--flat forminator-ddfor--" + module_id
				});
			} else {

				form.find(".forminator-select").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-dropdown forminator-ddfor--" + module_id
				});

				form.find(".forminator-time").wpmuiSelect({
					allowClear: false,
					containerCssClass: "forminator-select2",
					dropdownCssClass: "forminator-droptime forminator-droptime--flat forminator-ddfor--" + module_id
				});
			}
		}

		/**
   * React method called when block initialized
   */

	}, {
		key: 'componentDidMount',
		value: function componentDidMount() {
			var attributes = this.props.attributes;
			var module_id = attributes.module_id;

			// Check if module ID set

			if (!module_id) {
				// Fallback
				return;
			} else {
				// Load preview
				this.preview(attributes);
			}
		}

		/**
   * React method called when block updated
   */

	}, {
		key: 'componentDidUpdate',
		value: function componentDidUpdate(prevProps) {
			var attributes = this.props.attributes;

			// Check if module is same => skip preview update

			if (prevProps.attributes.module_id === attributes.module_id) {
				return;
			}

			// Check if we have module ID set
			if (!attributes.module_id) {

				// Clear the preview markup
				this.setState({ markup: '' });

				return;
			}

			// Load preview
			this.preview(attributes);
		}
	}, {
		key: 'update_alignment',
		value: function update_alignment(nextAlign) {
			this.props.setAttributes({ alignment: nextAlign });
		}
	}, {
		key: 'open_settings',
		value: function open_settings(module_id) {
			var url = frmnt_form_data.admin_url + '?page=forminator-cform-wizard&id=' + module_id;

			window.location.href = url;
		}

		/**
   * Render
   */

	}, {
		key: 'render',
		value: function render() {
			var _this3 = this;

			var _state = this.state,
			    loading = _state.loading,
			    markup = _state.markup;
			var _props = this.props,
			    attributes = _props.attributes,
			    setAttributes = _props.setAttributes,
			    isSelected = _props.isSelected;
			var module_id = attributes.module_id,
			    alignment = attributes.alignment;

			var update = function update(e) {
				return _this3.update_id(e.target.value);
			};
			var update_alignment = function update_alignment(e) {
				return _this3.update_alignment(e.target);
			};
			var open_settings = function open_settings(e) {
				return _this3.open_settings(module_id);
			};

			var options = frmnt_form_data.forms;

			var controls = [isSelected && wp.element.createElement(
				InspectorControls,
				{ key: 'inspector' },
				wp.element.createElement(SelectControl, {
					label: frmnt_form_data.l10n.choose_form,
					value: module_id,
					options: options,
					onChange: this.update_id
				})
			), wp.element.createElement(
				BlockControls,
				null,
				wp.element.createElement(BlockAlignmentToolbar, {
					value: alignment,
					onChange: update_alignment
				}),
				!!module_id && wp.element.createElement(
					Toolbar,
					null,
					wp.element.createElement(IconButton, {
						className: 'components-toolbar__control',
						label: frmnt_form_data.l10n.customize_form,
						icon: 'edit',
						onClick: open_settings
					})
				)
			)];

			// If preview is being loaded, show spinner
			if (loading) {
				return [controls, wp.element.createElement(
					'div',
					{ key: 'loading', className: 'wp-block-embed is-loading' },
					wp.element.createElement(Spinner, null),
					wp.element.createElement(
						'span',
						null,
						frmnt_form_data.l10n.rendering
					)
				)];
			}

			// If we have preview markup display it
			if (markup) {
				return [controls, wp.element.createElement(
					RawHTML,
					null,
					markup
				)];
			}

			// Fallback, display the select
			return [controls, wp.element.createElement(
				Placeholder,
				{ key: 'placeholder', className: 'wp-block-embed' },
				wp.element.createElement(
					'div',
					{ className: 'forminator-forms--placeholder' },
					wp.element.createElement(
						'svg',
						{ xmlns: 'http://www.w3.org/2000/svg', width: '21', height: '19', viewBox: '0 0 21 19' },
						wp.element.createElement('path', { 'fill-rule': 'evenodd', d: 'M13.5451769,1.48693014 L12.356375,0.277549982 L12.356375,0.277370522 C12.1589668,0.0776914902 11.8400315,0.0778709501 11.644035,0.277549982 L3.85388279,8.20010569 C3.75915623,8.29591605 3.70603717,8.42627017 3.70635606,8.5621361 C3.70635606,8.69900417 3.75882569,8.82773673 3.85388279,8.9241665 L5.04274349,10.1335467 C5.13711698,10.2296063 5.26521317,10.2835046 5.39873701,10.2833358 C5.53236272,10.2835841 5.66057917,10.2296798 5.75502464,10.1335467 L13.5451769,2.21099096 C13.7415263,2.01125211 13.7415263,1.68660918 13.5451769,1.48693014 Z M19.9111198,2.79064639 L18.7219062,1.58144568 C18.5259097,1.38176665 18.2059744,1.38176665 18.0099779,1.58144568 L7.67751904,12.0887621 C7.48116967,12.2884411 7.48116967,12.6132635 7.67751904,12.8129426 L8.86673268,14.0221433 C8.96108128,14.1182263 9.08920386,14.1720926 9.22272619,14.1718128 C9.35154738,14.1718128 9.48066267,14.1219828 9.57860207,14.0221433 L19.9111786,3.51464738 C20.107175,3.31514781 20.107175,2.99050488 19.9111786,2.79064639 L19.9111198,2.79064639 Z M3.06548538,12.612127 C2.98066339,12.5261058 2.86166556,12.4904532 2.74331477,12.5197649 C2.62715849,12.547545 2.53376958,12.6351195 2.49714279,12.7506102 L1.44463254,16.0325725 C1.4040862,16.157297 1.43633413,16.2946136 1.52792514,16.3872451 C1.61898925,16.4804231 1.75399238,16.5133047 1.8766835,16.4721894 L5.10438943,15.4017112 L5.10438943,15.4015318 C5.21787953,15.3643255 5.30393376,15.2694133 5.33120882,15.1513647 C5.35929029,15.0334893 5.32470763,14.9092629 5.24003401,14.8238504 L3.0655442,12.612127 L3.06548538,12.612127 Z M17.695866,8.01897085 L15.7484897,9.99937049 C15.6760825,10.0726186 15.6280511,10.1670889 15.6111393,10.2695174 C15.0349145,13.5837826 12.2153188,15.9893825 8.9066143,15.9893825 C8.57691443,15.9893825 8.24156759,15.9616859 7.8819859,15.9048569 C7.72563581,15.8795531 7.56110939,15.932733 7.44834674,16.0474079 L6.57312739,16.9374093 C6.44265917,17.0702694 6.39448358,17.2575657 6.4443062,17.4387604 C6.49412882,17.6202541 6.63147926,17.7552678 6.81141716,17.7999533 C7.49733836,17.9696708 8.20074162,18.0554422 8.90667313,18.0554444 C13.7857019,18.0554444 17.7552179,14.0187933 17.7552179,9.05702664 C17.7552179,8.85148525 17.7407476,8.64947324 17.7263949,8.44764069 L17.695866,8.01897085 Z M9.61448377,0.0884590833 L7.51793371,2.21888719 C7.44475857,2.29126935 7.34123105,2.32052131 7.24046817,2.34474839 C4.51304725,3.00085373 2.15938423,5.57323172 2.09544422,8.80231324 C2.0888561,9.13754431 2.08991491,9.46948527 2.13950224,9.83612182 C2.16161948,9.99554201 2.10650284,10.1619013 1.99179905,10.2746021 L1.1014035,11.1488709 C0.968464742,11.2792784 0.812291115,11.3312021 0.606236044,11.2711429 C0.400180972,11.2110836 0.288594769,11.06943 0.247830806,10.8857229 C0.0931277404,10.1871454 0.0364817131,9.46787013 0.065481185,8.73860498 C0.262948177,3.78144441 4.17987685,0.158448438 8.70673559,0.0590276622 C8.90884956,0.0546009851 8.93349617,0.0510117874 9.13172785,0.0691970557 L9.61454259,0.0884590833 L9.61448377,0.0884590833 Z' })
					),
					wp.element.createElement(
						'strong',
						null,
						'Choose form'
					)
				),
				wp.element.createElement(
					'form',
					null,
					wp.element.createElement(
						'select',
						{ value: module_id, onChange: update },
						options.map(function (row) {
							return wp.element.createElement(
								'option',
								{ key: row.value, value: row.value },
								row.label
							);
						})
					)
				)
			)];
		}
	}]);

	return BlockEdit;
}(Component);

/**
 * Register block
 */


registerBlockType('forminator/forms', {
	title: frmnt_form_data.l10n.form,
	description: frmnt_form_data.l10n.form_description,
	icon: function icon() {
		return wp.element.createElement(
			'svg',
			{ xmlns: 'http://www.w3.org/2000/svg', width: '21', height: '19', viewBox: '0 0 21 19' },
			wp.element.createElement('path', { 'fill-rule': 'evenodd', d: 'M13.5451769,1.48693014 L12.356375,0.277549982 L12.356375,0.277370522 C12.1589668,0.0776914902 11.8400315,0.0778709501 11.644035,0.277549982 L3.85388279,8.20010569 C3.75915623,8.29591605 3.70603717,8.42627017 3.70635606,8.5621361 C3.70635606,8.69900417 3.75882569,8.82773673 3.85388279,8.9241665 L5.04274349,10.1335467 C5.13711698,10.2296063 5.26521317,10.2835046 5.39873701,10.2833358 C5.53236272,10.2835841 5.66057917,10.2296798 5.75502464,10.1335467 L13.5451769,2.21099096 C13.7415263,2.01125211 13.7415263,1.68660918 13.5451769,1.48693014 Z M19.9111198,2.79064639 L18.7219062,1.58144568 C18.5259097,1.38176665 18.2059744,1.38176665 18.0099779,1.58144568 L7.67751904,12.0887621 C7.48116967,12.2884411 7.48116967,12.6132635 7.67751904,12.8129426 L8.86673268,14.0221433 C8.96108128,14.1182263 9.08920386,14.1720926 9.22272619,14.1718128 C9.35154738,14.1718128 9.48066267,14.1219828 9.57860207,14.0221433 L19.9111786,3.51464738 C20.107175,3.31514781 20.107175,2.99050488 19.9111786,2.79064639 L19.9111198,2.79064639 Z M3.06548538,12.612127 C2.98066339,12.5261058 2.86166556,12.4904532 2.74331477,12.5197649 C2.62715849,12.547545 2.53376958,12.6351195 2.49714279,12.7506102 L1.44463254,16.0325725 C1.4040862,16.157297 1.43633413,16.2946136 1.52792514,16.3872451 C1.61898925,16.4804231 1.75399238,16.5133047 1.8766835,16.4721894 L5.10438943,15.4017112 L5.10438943,15.4015318 C5.21787953,15.3643255 5.30393376,15.2694133 5.33120882,15.1513647 C5.35929029,15.0334893 5.32470763,14.9092629 5.24003401,14.8238504 L3.0655442,12.612127 L3.06548538,12.612127 Z M17.695866,8.01897085 L15.7484897,9.99937049 C15.6760825,10.0726186 15.6280511,10.1670889 15.6111393,10.2695174 C15.0349145,13.5837826 12.2153188,15.9893825 8.9066143,15.9893825 C8.57691443,15.9893825 8.24156759,15.9616859 7.8819859,15.9048569 C7.72563581,15.8795531 7.56110939,15.932733 7.44834674,16.0474079 L6.57312739,16.9374093 C6.44265917,17.0702694 6.39448358,17.2575657 6.4443062,17.4387604 C6.49412882,17.6202541 6.63147926,17.7552678 6.81141716,17.7999533 C7.49733836,17.9696708 8.20074162,18.0554422 8.90667313,18.0554444 C13.7857019,18.0554444 17.7552179,14.0187933 17.7552179,9.05702664 C17.7552179,8.85148525 17.7407476,8.64947324 17.7263949,8.44764069 L17.695866,8.01897085 Z M9.61448377,0.0884590833 L7.51793371,2.21888719 C7.44475857,2.29126935 7.34123105,2.32052131 7.24046817,2.34474839 C4.51304725,3.00085373 2.15938423,5.57323172 2.09544422,8.80231324 C2.0888561,9.13754431 2.08991491,9.46948527 2.13950224,9.83612182 C2.16161948,9.99554201 2.10650284,10.1619013 1.99179905,10.2746021 L1.1014035,11.1488709 C0.968464742,11.2792784 0.812291115,11.3312021 0.606236044,11.2711429 C0.400180972,11.2110836 0.288594769,11.06943 0.247830806,10.8857229 C0.0931277404,10.1871454 0.0364817131,9.46787013 0.065481185,8.73860498 C0.262948177,3.78144441 4.17987685,0.158448438 8.70673559,0.0590276622 C8.90884956,0.0546009851 8.93349617,0.0510117874 9.13172785,0.0691970557 L9.61454259,0.0884590833 L9.61448377,0.0884590833 Z' })
		);
	},
	category: 'embed',
	attributes: {
		module_id: {
			type: 'integer'
		},
		alignment: {
			type: 'string',
			default: 'none'
		}
	},
	supports: {
		customClassName: false,
		className: false,
		html: false
	},
	transforms: {
		from: [{
			type: 'shortcode',
			tag: ['forminator_form'],
			attributes: {
				module_id: {
					type: 'integer',
					shortcode: function shortcode(_ref) {
						var id = _ref.named.id;

						return parseInt(id);
					}
				}
			}
		}]
	},
	edit: BlockEdit,
	save: function save(_ref2) {
		var attributes = _ref2.attributes;
		var module_id = attributes.module_id;


		if (module_id) {
			return wp.element.createElement(
				'div',
				{ 'class': 'forminator-guttenberg' },
				'[forminator_form id="',
				module_id,
				'"]'
			);
		}

		return null;
	}
});

/***/ })
/******/ ]);