<?php

/**
 * Class Forminator_Addon_Slack_Form_Hooks
 *
 * @since 1.0 Slack Addon
 *
 */
class Forminator_Addon_Slack_Form_Hooks extends Forminator_Addon_Form_Hooks_Abstract {

	/**
	 * Addon instance are auto available form abstract
	 * Its added here for development purpose,
	 * Auto-complete will resolve addon directly to `Slack` instance instead of the abstract
	 * And its public properties can be exposed
	 *
	 * @since 1.0 Slack Addon
	 * @var Forminator_Addon_Slack
	 */
	protected $addon;

	/**
	 * Form Settings Instance
	 *
	 * @since 1.0 Slack Addon
	 * @var Forminator_Addon_Slack_Form_Settings | null
	 */
	protected $form_settings_instance;

	/**
	 * Forminator_Addon_Slack_Form_Hooks constructor.
	 *
	 * @since 1.0 Slack Addon
	 *
	 * @param Forminator_Addon_Abstract $addon
	 * @param                           $form_id
	 *
	 * @throws Forminator_Addon_Exception
	 */
	public function __construct( Forminator_Addon_Abstract $addon, $form_id ) {
		parent::__construct( $addon, $form_id );
		$this->_submit_form_error_message = __( 'Slack failed to process submitted data. Please check your form and try again', Forminator::DOMAIN );
	}
}