<?php

/**
 * Append additional data to output upon successful signin
 * @param type $output
 */
function fooevents_append_output_data($output) {
    //include config for plugin version
    require_once(WP_PLUGIN_DIR.'/fooevents/config.php');

    $tempConfig = new FooEvents_Config();

    $output['data']['plugin_version'] = (string)$tempConfig->pluginVersion; 

    // Get app settings
    $output['data']['app_logo'] = preg_replace_callback('/[^\x20-\x7f]/', function($match) {
        return urlencode($match[0]);
    }, (string)get_option('globalWooCommerceEventsAppLogo', ''));
    
    $output['data']['app_color'] = (string)get_option('globalWooCommerceEventsAppColor', '');
    $output['data']['app_text_color'] = (string)get_option('globalWooCommerceEventsAppTextColor', '');
    $output['data']['app_background_color'] = (string)get_option('globalWooCommerceEventsAppBackgroundColor', '');
    $output['data']['app_signin_text_color'] = (string)get_option('globalWooCommerceEventsAppSignInTextColor', '');

    // Check if multiday event plugin is enabled
    if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
        require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    }

    if (fooevents_check_plugin_active('fooevents_multi_day/fooevents-multi-day.php') || is_plugin_active_for_network('fooevents_multi_day/fooevents-multi-day.php')) {
        
        $output['data']['multiday_enabled'] = 'Yes';

    } else {
        
        $output['data']['multiday_enabled'] = 'No';
        
    }

    return $output;
}

/**
 * Get all events as an array
 * 
 * @return array eventsArray
 */

function getAllEvents($user = null) {

    $eventsArray = array();
    $args = array(
            'post_type' => 'product',
            'order' => 'ASC',
            'posts_per_page' => -1,
            'meta_query' => array(
                    array(
                            'key' => 'WooCommerceEventsEvent',
                            'value' => 'Event',
                            'compare' => '=',
                    ),
            ),
    );

    $appEvents = get_option('globalWooCommerceEventsAppEvents', 'all');

    if ( $appEvents != 'all' ) {
        if ( $appEvents === 'user' && $user != null ) {
            $args['author'] = $user->ID;
        } elseif ( $appEvents === 'id' ) {
            $appEventIDs = get_option('globalWooCommerceEventsAppEventIDs', array());
            
            if ( !empty($appEvents) ) {
                $args['post__in'] = $appEventIDs;
            }
        }
    }
    
    $query = new WP_Query($args);
    $events = $query->get_posts();

    foreach ( $events as &$event ) {
        
        $tempEvent = array();
        $tempEvent['WooCommerceEventsProductID'] = (string)$event->ID;
        $tempEvent['WooCommerceEventsName'] = (string)$event->post_title;
        $tempEvent['WooCommerceEventsDate'] = (string)get_post_meta($event->ID, 'WooCommerceEventsDate', true);
        $tempEvent['WooCommerceEventsHour'] = (string)get_post_meta($event->ID, 'WooCommerceEventsHour', true);
        $tempEvent['WooCommerceEventsMinutes'] = (string)get_post_meta($event->ID, 'WooCommerceEventsMinutes', true);
        $tempEvent['WooCommerceEventsTicketLogo'] = (string)get_post_meta($event->ID, 'WooCommerceEventsTicketLogo', true);      
        $tempEvent['WooCommerceEventsTicketHeaderImage'] = (string)get_post_meta($event->ID, 'WooCommerceEventsTicketHeaderImage', true);
        $tempEvent['WooCommerceEventsHourEnd'] = (string)get_post_meta($event->ID, 'WooCommerceEventsHourEnd', true);
        $tempEvent['WooCommerceEventsMinutesEnd'] = (string)get_post_meta($event->ID, 'WooCommerceEventsMinutesEnd', true);
        $tempEvent['WooCommerceEventsLocation'] = (string)get_post_meta($event->ID, 'WooCommerceEventsLocation', true);
        $tempEvent['WooCommerceEventsSupportContact'] = (string)get_post_meta($event->ID, 'WooCommerceEventsSupportContact', true);
        $tempEvent['WooCommerceEventsEmail'] = (string)get_post_meta($event->ID, 'WooCommerceEventsEmail', true);
        $tempEvent['WooCommerceEventsGPS'] = (string)get_post_meta($event->ID, 'WooCommerceEventsGPS', true);
        $tempEvent['WooCommerceEventsGoogleMaps'] = (string)get_post_meta($event->ID, 'WooCommerceEventsGoogleMaps', true);
        $tempEvent['WooCommerceEventsDirections'] = (string)get_post_meta($event->ID, 'WooCommerceEventsDirections', true);       
        $tempEvent['WooCommerceEventsNumDays'] = (string)get_post_meta($event->ID, 'WooCommerceEventsNumDays', true);

        $eventsArray[] = $tempEvent;

        unset($tempEvent);

    }

    return $eventsArray;

}

/**
 * Get all tickets for an event as an array
 * 
 * @param string $eventID
 * @return array ticketsArray
 */

function getEventTickets($eventID) {

    global $woocommerce;
    $ticketsArray = array();
    $ticketStatusOptions = array();
    
    $eventID = sanitize_text_field($eventID);
    
    $globalWooCommerceHideUnpaidTicketsApp = get_option('globalWooCommerceHideUnpaidTicketsApp', true);

    if ( $globalWooCommerceHideUnpaidTicketsApp == 'yes' ) {

        $ticketStatusOptions = array('key' => 'WooCommerceEventsStatus', 'compare' => '!=', 'value' => 'Unpaid');

    }

    $events_query = new WP_Query( array('post_type' => array('event_magic_tickets'), 'posts_per_page' => -1, 'fields' => 'ids', 'meta_query' => array( array( 'key' => 'WooCommerceEventsProductID', 'value' => $eventID ), $ticketStatusOptions )) );
    $ticket_ids = $events_query->get_posts();

    foreach ( $ticket_ids as $ticket_id ) {

        $tempTicket = array();

        $order_id = get_post_meta($ticket_id, 'WooCommerceEventsOrderID', true);

        try {

            $order = new WC_Order( $order_id );

            $tempTicket['customerFirstName'] = (string)$order->get_billing_first_name();
            $tempTicket['customerLastName'] = (string)$order->get_billing_last_name();
            $tempTicket['customerEmail'] = (string)$order->get_billing_email();
            $tempTicket['customerPhone'] = (string)$order->get_billing_phone();

            if ( trim($tempTicket['customerFirstName']) == "" ) {
                $tempTicket['customerFirstName'] = get_post_meta($ticket_id, 'WooCommerceEventsPurchaserFirstName', true);
                $tempTicket['customerLastName'] = get_post_meta($ticket_id, 'WooCommerceEventsPurchaserLastName', true);
                $tempTicket['customerEmail'] = get_post_meta($ticket_id, 'WooCommerceEventsPurchaserEmail', true);
            }

            $tempTicket['WooCommerceEventsAttendeeName'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeName', true);
            $tempTicket['WooCommerceEventsAttendeeLastName'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeLastName', true);
            $tempTicket['WooCommerceEventsAttendeeEmail'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeEmail', true);           
            $tempTicket['WooCommerceEventsAttendeeTelephone'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeTelephone', true);           
            $tempTicket['WooCommerceEventsAttendeeCompany'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeCompany', true);            
            $tempTicket['WooCommerceEventsAttendeeDesignation'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsAttendeeDesignation', true);
            $tempTicket['WooCommerceEventsTicketID'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsTicketID', true);
            $tempTicket['WooCommerceEventsStatus'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsStatus', true); 
            $tempTicket['WooCommerceEventsMultidayStatus'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsMultidayStatus', true);
            $tempTicket['WooCommerceEventsTicketType'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsTicketType', true);
            $tempTicket['WooCommerceEventsVariationID'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsVariationID', true);
            $tempTicket['WooCommerceEventsProductID'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsProductID', true);
            $tempTicket['WooCommerceEventsTicketPrice'] = (string)get_post_meta($ticket_id, 'WooCommerceEventsPrice', true);

            $WooCommerceEventsVariations = get_post_meta($ticket_id, 'WooCommerceEventsVariations', true);

            $WooCommerceEventsVariationsOutput = array();

            if ( !empty($WooCommerceEventsVariations) ) {

                foreach ( $WooCommerceEventsVariations as $variationName => $variationValue ) {

                    $variationNameOutput = str_replace('attribute_', '', $variationName);
                    $variationNameOutput = str_replace('pa_', '', $variationNameOutput);
                    $variationNameOutput = str_replace('_', ' ', $variationNameOutput);
                    $variationNameOutput = str_replace('-', ' ', $variationNameOutput);
                    $variationNameOutput = str_replace('Pa_', '', $variationNameOutput);
                    $variationNameOutput = ucwords($variationNameOutput);                    

                    $variationValueOutput = str_replace('_', ' ', $variationValue);
                    $variationValueOutput = str_replace('-', ' ', $variationValueOutput);
                    $variationValueOutput = ucwords($variationValueOutput);

                    $WooCommerceEventsVariationsOutput[$variationNameOutput] = (string)$variationValueOutput;

                }

            }

            $tempTicket['WooCommerceEventsVariations'] = $WooCommerceEventsVariationsOutput;

            $post_meta = get_post_meta($ticket_id); 

            $custom_values = array();

            foreach($post_meta as $key => $meta) {

               if (strpos($key, 'fooevents_custom_') === 0) {

                    $custom_values[$key] = $meta[0];

               }

            }

            $custom_values_output = array();
            foreach($custom_values as $key => $value) {

                $custom_values_output[fooevents_output_custom_field_name($key)] = $value;

            }

            $tempTicket['WooCommerceEventsCustomAttendeeFields'] = $custom_values_output;

            $ticketsArray[] = $tempTicket;

            unset($tempTicket);

        }

        catch ( Exception $e ) {

            // do nothing

        }

    }

    return $ticketsArray;

}

/**
 * Update ticket ID with the provided status
 * @param type $ticketPostID
 * @param type $status
 */
function updateTicketStatus($ticketPostID, $status) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'fooevents_check_in';
    
    $events_query = new WP_Query( array('post_type' => array('event_magic_tickets'), 'meta_query' => array( array( 'key' => 'WooCommerceEventsTicketID', 'value' => $ticketPostID ) )) );
    $ticket = $events_query->get_posts();
    $ticket = $ticket[0];

    $eventID = get_post_meta($ticket->ID, 'WooCommerceEventsProductID', true);
    
    $timestamp = current_time('timestamp');
    
    $output = array();

    if(!empty($status)) {

        if(update_post_meta( $ticket->ID, 'WooCommerceEventsStatus', strip_tags( $status ))) {

            // Check if multiday event plugin is enabled
            if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
                require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
            }
            
            if (fooevents_check_plugin_active('fooevents_multi_day/fooevents-multi-day.php') || is_plugin_active_for_network('fooevents_multi_day/fooevents-multi-day.php')) {
                
                $WooCommerceEventsProductID = get_post_meta($ticket->ID, "WooCommerceEventsProductID", true);
                $WooCommerceEventsNumDays = (int)get_post_meta($WooCommerceEventsProductID, "WooCommerceEventsNumDays", true);
                
                if ( $WooCommerceEventsNumDays > 1 )
                {
                    $WooCommerceEventsMultidayStatus = array();
                    
                    for ( $day = 1; $day <= $WooCommerceEventsNumDays; $day++ ) {
                        $WooCommerceEventsMultidayStatus[$day] = strip_tags( $status );
                    }
                    
                    $WooCommerceEventsMultidayStatus = json_encode($WooCommerceEventsMultidayStatus);
                    
                    update_post_meta($ticket->ID, 'WooCommerceEventsMultidayStatus', strip_tags($WooCommerceEventsMultidayStatus));
                }
                
            } else {
                
                if($status == 'Checked In') {

                    $wpdb->insert($table_name, array(
                            'tid' => $ticket->ID,
                            'eid' => $eventID,
                            'day' => 1,
                            'checkin' => $timestamp
                        ));

                }
                
            }
            
            $output['message'] = 'Status updated';

        } 

    } else {

        $output['message'] = 'Status is required';

    }

    return $output;
}

/**
 * Update multiple ticket IDs with the provided statuses
 * @param type $ticketsStatus
 */
function updateTicketMultipleStatus($ticketsStatus) {
    $output = array();

    $ticketsStatus = json_decode($ticketsStatus, true);

    if(!empty($ticketsStatus)) {

        foreach($ticketsStatus as $tempTicketID => $status) {

            if ( strpos($tempTicketID, "_") !== false )
            {
                $tempTicketArray = explode("_", $tempTicketID);
                
                $ticketID = $tempTicketArray[0];
                $day = $tempTicketArray[1];
                
                $output['message'][$ticketID] = updateTicketMultidayStatus($ticketID, $status, $day);
            }
            else
            {
                $ticketID = $tempTicketID;
                $events_query = new WP_Query( array('post_type' => array('event_magic_tickets'), 'meta_query' => array( array( 'key' => 'WooCommerceEventsTicketID', 'value' => $ticketID ) )) );
                $ticket = $events_query->get_posts();
                $ticket = $ticket[0];

                if(update_post_meta( $ticket->ID, 'WooCommerceEventsStatus', strip_tags( $status ))) {

                    $output['message'][$ticketID] = 'Status updated';

                } else {

                    $output['message'][$ticketID] = 'Status unchanged';

                }
            }
        }

    } else {

        $output['message'] = 'Status is required';

    }

    return $output;
}

/**
 * Update ticket ID status for a specified day in a multiday event
 * @param type $ticketID
 * @param type $status
 * @param type $day
 */
function updateTicketMultidayStatus($ticketID, $status, $day)
{
    
    global $wpdb;
    $table_name = $wpdb->prefix . 'fooevents_check_in';
    
    $ticketID = sanitize_text_field($ticketID);
    $status = sanitize_text_field($status);
    $day = sanitize_text_field($day);
    
    $events_query = new WP_Query( array('post_type' => array('event_magic_tickets'), 'meta_query' => array( array( 'key' => 'WooCommerceEventsTicketID', 'value' => $ticketID ) )) );
    $ticket = $events_query->get_posts();

    if(!empty($ticket)) {
        
        $ticket = $ticket[0];
        $eventID = get_post_meta($ticket->ID, 'WooCommerceEventsProductID', true);
        $timestamp = current_time('timestamp');
        if($status == 'Checked In') {

            $wpdb->insert($table_name, array(
                    'tid' => $ticket->ID,
                    'eid' => $eventID,
                    'day' => $day,
                    'checkin' => $timestamp
                ));

        }
        
        $WooCommerceEventsMultidayStatus = get_post_meta($ticket->ID, "WooCommerceEventsMultidayStatus", true);
        $WooCommerceEventsMultidayStatus = json_decode($WooCommerceEventsMultidayStatus, true);
        
        $WooCommerceEventsMultidayStatus[$day] = $status;

        $WooCommerceEventsMultidayStatus = json_encode($WooCommerceEventsMultidayStatus);
        
        update_post_meta($ticket->ID, 'WooCommerceEventsMultidayStatus', strip_tags($WooCommerceEventsMultidayStatus));
        update_post_meta($ticket->ID, 'WooCommerceEventsStatus', strip_tags($status));
        
        return 'Status updated';
    }
    else
    {
        return 'Status not updated';
    }
}

/**
 * Output the name of a custom field
 * @param type $field_name
 */
function fooevents_output_custom_field_name($field_name) {

    $field_name = str_replace('fooevents_custom_', "", $field_name);
    $field_name = str_replace('_', " ", $field_name);
    $field_name = ucwords($field_name);

    return $field_name;

}
