<?php
  global $foodbookAttr;

  $options = get_option('foodbook_options');

  $column       = '4';
  $cat          = '';
  $limit        = '-1';
  $layout       = 'grid';
  $paddingTop   = '120px';
  $paddingBottom  = '120px';
  $branch_id    = '';
  $taxonomy    = '';


  if( !empty( $foodbookAttr ) ) {

    $column = foodbook_bootstrap_column_map( $foodbookAttr['col'] );
    $cat             = !empty(  $foodbookAttr['cat'] ) ? $foodbookAttr['cat'] : '';
    $limit           = !empty(  $foodbookAttr['limit'] ) ? $foodbookAttr['limit'] : '';
    $layout          = !empty(  $foodbookAttr['layout'] ) ? $foodbookAttr['layout'] : '';
    $sidebar         = !empty(  $foodbookAttr['sidebar'] ) ? $foodbookAttr['sidebar'] : '';
    $paddingTop      = !empty(  $foodbookAttr['padding_top'] ) ? $foodbookAttr['padding_top'] : '0px';
    $paddingBottom   = !empty(  $foodbookAttr['padding_bottom'] ) ? $foodbookAttr['padding_bottom'] : '0px';
    // Check
    if( !empty(  $foodbookAttr['branch_id'] ) ) {
      $branch_id = $foodbookAttr['branch_id'];
    }

  }
?>

<div class="fb__wrapper" style="padding-top:<?php echo esc_attr( $paddingTop ); ?>;padding-bottom: <?php echo esc_attr( $paddingBottom ); ?>">

  <!-- Product -->
  <section>
    <div class="fb_container">
      <div class="fb_row">
          <?php
          $productMarkup = new \FoodBook\Product_Layout();

          $branchId = '';

          $options = get_option( 'foodbook_options' );

          // Default Init
          $args = array(
            'limit'     => esc_html( $limit ),
            'status'    => 'publish',
            'order'     => esc_html( 'DESC' ),
            'paginate'  => true
          );

          if( !empty( $branch_id ) ) {
            $args['product_by_branch'] = $branch_id;
          }

          // add category slug
          if( !empty( $cat ) ) {
            $args['category'] = array_filter( explode(',', $cat) );
          }

          // Add taxonomy term slug for tax query
          if( !empty( $cat ) && $taxonomy == 'specialoffer' ) {

            $args['tax_query'] = array(
                      array(
                          'taxonomy' => 'specialoffer',
                          'field'    => 'slug',
                          'terms'    => $cat
                      ),
                  );

          }

          $query = wc_get_products( $args );

          $products = $query->products;

          if( !empty( $products ) ):
            
            foreach( $products as $product ):

              $imgId = $product->get_image_id();

              $imgUrl = wp_get_attachment_url( absint( $imgId ) );

              if( $layout != 'grid' ) {
                $productMarkup->product_layout_list( $product, $options, $column, $imgUrl );
              } else {
                $productMarkup->product_layout_grid( $product, $options, $column, $imgUrl );
              }
             
            endforeach;
          endif;
          
          ?>
          
      </div>

    </div>
  </section>
  <!-- End Product -->
  
</div>
